<?php
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "api_call.php";
 date_default_timezone_set("Africa/Lagos");
   if($_SERVER["REQUEST_METHOD"] !== "POST"){
     echo "Invalid server request method only post method allowed";
     exit();
   }
 
   $user_id = $_SESSION["user_id"];
   $user = Control::fetchDetail($conn, $user_id);
   if($user["status"] !== "VERIFIED"){
       echo "Your account is ".$user["status"]." you cant perform any action please contact customer care";
       unset($_SESSION["user_id"]);
       exit();
   }
   
   if(!isset($_POST["provider"]) || !isset($_POST["quantity"]) || !isset($_POST["amount"])){
     echo "Invalid request check and try again";
     exit();
   }
   
   $exam_type = validate::validateInt($conn, $_POST["provider"]);
   $quatity = validate::validateInt($conn, $_POST["quantity"]);
   $amount = validate::validateInt($conn, $_POST["amount"]);
   $provider_txt = validate::validateString($conn, $_POST["provider-name"]);
   
   $fetchDiscount = Control::fetchDiscount($conn, "Exam pin");
   $percent = $fetchDiscount["discount"];
   $discount = Control::calculateDiscount($percent, $amount);
   
   
   $pin_1 = validate::validateInt($conn, $_POST["pin-1"]);
   $pin_2 = validate::validateInt($conn, $_POST["pin-2"]);
   $pin_3 = validate::validateInt($conn, $_POST["pin-3"]);
   $pin_4 = validate::validateInt($conn, $_POST["pin-4"]);
   
   $pin_join = $pin_1.$pin_2.$pin_3.$pin_4;
   
   if(empty($exam_type) || empty($quatity) || empty($amount)){
     echo "Err! All fields are required";
     exit();
   }
   
   $checkPin = Control::checkPin($conn, $user_id, $pin_join);
   if($checkPin["status"] == false){
     echo $checkPin["msg"];
     exit();
   }
   
   $int = (INT)$amount;
   if($int < 1){
       Control::updateUserPrevilage($conn, $user_id, "RESTRICTED");
       session_destroy();
   }
   
   $checkBalance = Control::checkBalance($conn, $user_id, $amount);
   if($checkBalance["status"] == false){
     echo $checkBalance["msg"];
     exit();
   }
   
    
   
   $generateId = Control::generateId("CD", 10);
   
   $buyExam= Api::buyExam($conn, strtolower($provider_txt), $quatity, $generateId);
   if($buyExam["status"] == false){
     echo $buyExam["msg"];
     exit();
   }
   
   $updateBalance = Control::updateBalance($conn, $user_id, "debit", $discount);
   if($updateBalance["status"] == false){
     echo "Err! Please contact customer support";
   }
   
   $description = "Purchase of ".$provider_txt." exam pins: Quantity ".$quatity." at a total amount of NGN ".number_format($discount)." with a discount of ".$percent;
   
   $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Exam Pin", "", $provider_txt, "success", $user["bal"], $user["bal"] - $discount, $discount, $buyExam["pins"]." || ".$buyExam["serials"], $description, date("D d-M-Y h:i a"));
   if($insertTransaction["status"] == false){
     echo $insertTransaction["msg"];
     exit();
   }
   
echo '
    <div class="finish">
      <div class="finish-box">
       <div class="finish-box-head">
         <img src="images/check.png" alt="success image">
         <h2>SUCCESS.</h2>
       </div>
       <table>
         <tr>
           <td>Provider</td>
           <td>'.$provider_txt.'</td>
         </tr>
         <tr>
           <td>Quantity</td>
           <td>'.$quantity.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($discount, 2).'</td>
         </tr>
         <tr>
           <td>Reference</td>
           <td>'.$generateId.' <i class="bi bi-copy"></i></td>
         </tr>
       </table>
       <div class="buttons">
         <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
         <button class="bg" onclick="window.location = `dashboard.php`;">BUY AGAIN</button>
       </div>
      </div>
    </div>
   ';
?>