<?php
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "api_call.php";
 date_default_timezone_set("Africa/Lagos");
 if($_SERVER["REQUEST_METHOD"] === "POST"){
   $user_id = $_SESSION["user_id"];
   $user = Control::fetchDetail($conn, $user_id);
   if($user["status"] !== "VERIFIED"){
       echo "Your account is ".$user["status"]." you cant perform any action please contact customer care";
       unset($_SESSION["user_id"]);
       exit();
   }
   
   $provider = validate::validateInt($conn, $_POST["provider"]);
   $provider_name = validate::validateString($conn, $_POST["provider-name"]);
   
   $type = validate::validateInt($conn, $_POST["type"]);
   $type_name = validate::validateString($conn, $_POST["type-name"]);
   
   $meter_no = validate::validateInt($conn, $_POST["meter-no"]);
   $meter_name = validate::validateString($conn, $_POST["meter-name"]);
   
   $amount = validate::validateInt($conn, $_POST["amount"]);
   
   $fetchDiscount = Control::fetchDiscount($conn, "Electricity");
   $percent = $fetchDiscount["discount"];
   $discount = Control::calculateDiscount($percent, $amount);
   
   
   $pin_1 = validate::validateInt($conn, $_POST["pin-1"]);
   $pin_2 = validate::validateInt($conn, $_POST["pin-2"]);
   $pin_3 = validate::validateInt($conn, $_POST["pin-3"]);
   $pin_4 = validate::validateInt($conn, $_POST["pin-4"]);
   
   $pin_join = $pin_1.$pin_2.$pin_3.$pin_4;
   
   $checkPin = Control::checkPin($conn, $user_id, $pin_join);
   if($checkPin["status"] == false){
     echo $checkPin["msg"];
     exit();
   }
   
   $checkBalance = Control::checkBalance($conn, $user_id, $amount);
   if($checkBalance["status"] == false){
     echo $checkBalance["msg"];
     exit();
   }
   
    
   
   $generateId = Control::generateId("CD", 10);
   
   $buyElectric = Api::buyElectric($conn, $provider, $type, $meter_no, $amount, $generateId);
   if($buyElectric["status"] == false){
     echo $buyElectric["msg"];
     exit();
   }
   
   $updateBalance = Control::updateBalance($conn, $user_id, "debit", $discount);
   if($updateBalance["status"] == false){
     echo "Err! Please contact customer support";
   }
   
   $description = "".$provider_name." purchase of ".number_format($amount)." for ".$meter_name."(".$meter_no.") at discount of ".$percent."(".$discount.")";
   
   $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Electricity", $buyElectric["units"], $provider_name, "success", $user["bal"], $user["bal"] - $discount, $discount, $buyElectric["token"], $description, date("D d-M-Y h:i a"));
   if($insertTransaction["status"] == false){
     echo $insertTransaction["msg"];
     exit();
   }
   
    echo '<div class="finish">
      <div class="finish-box">
       <div class="finish-box-head">
         <img src="images/check.png" alt="success image">
         <h2>Success, Your meter purchase was successful "'.$buyElectric["details"][0]["token"].'"</h2>
       </div>
       <table>
         <tr>
           <td>Provider</td>
           <td>'.$provider_name.'</td>
         </tr>
         <tr>
           <td>Token</td>
           <td>'.$buyElectric["token"].'</td>
         </tr>
         <tr>
           <td>Meter No</td>
           <td>'.$meter_no.'</td>
         </tr>
         <tr>
           <td>Meter Name</td>
           <td>'.$meter_name.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($amount, 2).'</td>
         </tr>
       </table>
       <div class="buttons">
         <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
         <button class="bg" onclick="window.location.reload()">BUY AGAIN</button>
       </div>
      </div>
    </div>
   ';
   exit();
   
 }
?>