<?php
require_once 'conn.php';
require_once 'controller.php';
require_once 'api_call.php';

session_start();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo 'Invalid request method';
    exit;
}
session_regenerate_id(true);
$user_id = $_SESSION['user_id'];
$user = Control::fetchDetail($conn, $user_id);

if ($user['status'] !== 'VERIFIED') {
    echo 'Account not verified';
    unset($_SESSION['user_id']);
    exit;
}

$networkId = validate::validateInt($conn, $_POST['network']);
$quantity = validate::validateInt($conn, $_POST['quantity']);
$amount = validate::validateInt($conn, $_POST['amount']) * $quantity;
$cardname = validate::validateString($conn, $_POST['nameoncard']);
$amountp = validate::validateInt($conn, $_POST['amount']);

$percent = '1.5%';
$discount = Control::calculateDiscount($percent, $amount);


$pin_1 = validate::validateInt($conn, $_POST['pin-1']);
$pin_2 = validate::validateInt($conn, $_POST['pin-2']);
$pin_3 = validate::validateInt($conn, $_POST['pin-3']);
$pin_4 = validate::validateInt($conn, $_POST['pin-4']);

$pin_join = $pin_1 . $pin_2 . $pin_3 . $pin_4;


$checkPin = Control::checkPin($conn, $user_id, $pin_join);
if ($checkPin['status'] === false) {
    echo $checkPin['msg'];
    exit;
}

$checkBalance = Control::checkBalance($conn, $user_id, $amount);
if ($checkBalance['status'] === false) {
    echo $checkBalance['msg'];
    exit;
}


$generateId = Control::generateId('CD', 20);

switch ($amountp) {
    case 140:
        $mappedAmount = 3;
        break;
    case 280:
        $mappedAmount = 5;
        break;
    case 600:
        $mappedAmount = 6;
        break;
          case 750:
        $mappedAmount = 7;
          case 1400:
        $mappedAmount = 8;
          case 1800:
        $mappedAmount = 9;
    default:
        $mappedAmount = 0;
}

$buyAirtimePin = Api::buyDatapin($conn, $networkId, $mappedAmount, $quantity, $cardname, $generateId);
if ($buyAirtimePin['status'] === false) {
   error_log($buyAirtimePin['msg'] . $mappedAmount);
   
   $description = 'Data pin purchase of ' . $network_txt . ' ' . $quantity . ' quantity at amount of ' . number_format($amount) . ' for ' . $cardname. 'Failed';

$insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, 'Data Card', $networkId, $buyAirtimePin['load_pin'] . '||' . $buyAirtimePin['serial_no'], 'failed', $user['bal'], $user['bal'] - $amount, $amount, $buyAirtimePin['pin'], $description, date("D d-M-Y h:i a"));


   echo '
    <div class="finish">
      <div class="finish-box">
       <div class="finish-box-head">
         <img src="images/eror.png" alt="success image">
         <h2>Failed, Data pin purchase Failed please try again</h2>
       </div>
       <table>
         <tr>
           <td>Network</td>
           <td>'.$network_txt.'</td>
         </tr>
         <tr>
           <td>Name on card</td>
           <td>'.$cardname.'</td>
         </tr>
         <tr>
           <td>Quantity</td>
           <td>'.$quantity.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($amount, 2).'</td>
         </tr>
       </table>
       <div class="buttons">
         <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
         <button class="bg" onclick="window.location.reload();">GO HOME</button>
       </div>
      </div>
    </div>
   ';
    exit();
}


$updateBalance = Control::updateBalance($conn, $user_id, 'debit', $amount);
if ($updateBalance['status'] === false) {
    echo 'Error updating balance';
}


$description = 'Data pin purchase of ' . $network_txt . ' ' . $quantity . ' quantity at amount of ' . number_format($amount) . ' for ' . $cardname;

$insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, 'Data Card', $networkId, $buyAirtimePin['load_pin'] . '||' . $buyAirtimePin['serial_no'], 'success', $user['bal'], $user['bal'] - $amount, $amount, $buyAirtimePin['pin'], $description, date("D d-M-Y h:i a"));

if ($insertTransaction['status'] === false) {
    echo $insertTransaction['msg'];
    exit();
}

   echo '
    <div class="finish">
      <div class="finish-box">
       <div class="finish-box-head">
         <img src="images/verified.png" alt="success image">
         <h2>Success, Data pin purchase successful</h2>
       </div>
       <table>
         <tr>
           <td>Network</td>
           <td>'.$network_txt.'</td>
         </tr>
         <tr>
           <td>Name on card</td>
           <td>'.$cardname.'</td>
         </tr>
         <tr>
           <td>Quantity</td>
           <td>'.$quantity.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($amount, 2).'</td>
         </tr>
       </table>
       <div class="buttons">
         <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
         <button class="bg" onclick="window.location.reload();">GO HOME</button>
       </div>
      </div>
    </div>
   ';
   exit();
   
?>