<?php
class validate {
   //validate email
   
   public static function checkSession(){
     if(!isset($_SESSION["user_id"])){
       header("Location: http://".$_SERVER["HTTP_HOST"]."/mobile/login.php");
       exit();
     }
   }
   public static function validateEmail($conn, $email){
     $var = filter_var($email, FILTER_SANITIZE_EMAIL);
     $special = htmlspecialchars($var);
     $escape = mysqli_real_escape_string($conn, $special);
     if(!empty($email)){
       return $escape;
     }else{
       return "";
     }
   }
   
   //validate string
   public static function validateString($conn, $string){
     $var = filter_var($string, FILTER_SANITIZE_SPECIAL_CHARS);
     $special = htmlspecialchars($var);
     $escape = mysqli_real_escape_string($conn, $special);
     if(!empty($string)){
       return $escape;
     }else{
       return "";
     }
   }
   
   //validate number
   public static function validateInt($conn, $int){
     $var = filter_var($int, FILTER_SANITIZE_NUMBER_INT);
     $special = htmlspecialchars($var);
     $escape = mysqli_real_escape_string($conn, $special);
     if(!empty($int)){
       return $escape;
     }else{
       return "";
     }
   }
   
   //validate password
   public static function validatePassword($conn, $password){
     $passHash = password_hash($password, PASSWORD_DEFAULT);
     if(!empty($password)){
       return $passHash;
     }else{
       return "";
     }
   }
   
   //validate url
   public static function validateUrl($conn, $url){
     $var = filter_var($url, FILTER_SANITIZE_URL);
     $special = htmlspecialchars($var);
     $escape = mysqli_real_escape_string($conn, $special);
     if(!empty($url)){
       return $escape;
     }else{
       return "";
     }
   }
   
   
   public static function checkDataPlan($conn, $service_id, $service, $service_name, $amount){
     $response = array();
     $sql = "SELECT * FROM service_details WHERE service_id = ? AND service = ? AND name = ?";
     $stmt = $conn->prepare($sql);
     $stmt->bind_param("sss", $service_id, $service, $service_name);
     $stmt->execute();
     $query = $stmt->get_result();
     if($query->num_rows > 0){
       $row = $query->fetch_assoc();
       
       $rowAmt = (float)$row["amount"];
       $sentAmt = (float)$amount;
       
       if($sentAmt !== $rowAmt){
         $response["status"] = false;
         $response["msg"] = "Unmobileised Tampering with data service amount your account will be blocked if you keep persisting or try again, if this is an error report to support to fix.";
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Data Plan amount match successfully you can proceed to next";
         $response["plan_name"] = "";
         return $response;
         exit();
       }
     }else{
       $response["status"] = false;
       $response["msg"] = "Unmobileized Tampering with data service amount your account will be blocked if you keep persisting or try again, if this is an error report to support to fix.";
       return $response;
       exit();
     }
   }
   
   
   public static function checkDataPlanApi($conn, $service_id, $service, $service_name, $amount){
     $response = array();
     $sql = "SELECT * FROM service_details WHERE service_id = ? AND service = ? AND name = ?";
     $stmt = $conn->prepare($sql);
     $stmt->bind_param("sss", $service_id, $service, $service_name);
     $stmt->execute();
     $query = $stmt->get_result();
     if($query->num_rows > 0){
       $row = $query->fetch_assoc();
  
         $response["status"] = true;
         $response["msg"] = "Data Plan amount match successfully you can proceed to next";
         $response["details"][] = $row;
         return $response;
         exit();
     }else{
       $response["status"] = false;
       $response["msg"] = "Plan with this id dosn't exist ".$service;
       return $response;
       exit();
     }
   }
   
}


class Control {
  
  
  public static function insertSignup($conn, $user_id, $email, $phone, $fname, $lname, $gender, $adress, $state, $city, $password, $bal, $pin, $api_key, $img, $two_factor, $mode, $level, $status){
    $response = array();
    
    $sql = "SELECT * FROM regtable WHERE email = ? OR phone = ?";
    $query = $conn->prepare($sql);
    $query->bind_param("ss", $email, $phone);
    $query->execute();
    $res = $query->get_result();
    if($res->num_rows > 0){
      $response["status"] = false;
      $response["msg"] = "user with this email or phone number already exists";
      return json_encode($response);
      exit();
    }
    $query->close();
     
        $sql2 = "INSERT INTO regtable (unique_id, email, phone, fname, lname, gender, address, state, city, password, bal, pin, api_key, img, two_factor, mode, level, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt2 = $conn->prepare($sql2);
        $stmt2->bind_param("ssssssssssssssssss", $user_id, $email, $phone, $fname, $lname, $gender, $adress, $state, $city, $password, $bal, $pin, $api_key, $img, $two_factor, $mode, $level, $status);
        if($stmt2->execute()){
          $response["status"] = true;
          $response["msg"] = "congratulations your account has been created successfully you can now login your account";
          return json_encode($response);
        }else{
          $response["status"] = false;
          $response["msg"] = "unable to create account";
          return json_encode($response);
        }
      $stmt2->close();
  }
  
  
  public static function insertVerification($conn, $user_id){
    $response = array();
    $empty = "";
    $sql = "INSERT INTO verification (unique_id, email, phone, bvn, nin) VALUES (?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssss", $user_id, $empty, $empty, $empty, $empty);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "success";
      return $response;
    }else{
      $response["status"] = false;
      $response["msg"] = "fail";
      return $response;
    }
  }
  
  
  public static function insertReferral($conn, $user_id, $otherUser_id, $bonus, $date){
    $response = array();
    
    $sql = "INSERT INTO referral (unique_id, user_id, bonus, date) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $user_id, $otherUser_id, $bonus, $date);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "success";
      return $response;
    }else{
      $response["status"] = false;
      $response["msg"] = "fail to insert referral";
      return $response;
    }
  }
  
  
  public static function fetchVerification($conn, $user_id){
    $response = array();
    
    $sql = "SELECT * FROM verification WHERE unique_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $query = $stmt->get_result();
    if($query->num_rows > 0){
      $row = $query->fetch_assoc();
      $response["status"] = true;
      $response["email"] = $row["email"];
      $response["phone"] = $row["phone"];
      $response["bvn"] = $row["bvn"];
      $response["nin"] = $row["nin"];
      $response["utility_bill"] = $row["utility"];
      return $response;
    }else{
      $response["status"] = false;
      return $response;
    }
  }
  
  
  
  public static function userLogin($conn, $emailOrphone, $password){
    $sql = "SELECT * FROM regtable WHERE email = ? OR phone = ?";
    $query = $conn->prepare($sql);
    $query->bind_param("ss", $emailOrphone, $emailOrphone);
    $query->execute();
    $res = $query->get_result();
    if($res->num_rows > 0){
      $row = $res->fetch_assoc();
      if($row["status"] == "BANNED"){
        $response["status"] = false;
        $response["msg"] = 'User account has been "BANNED"';
        return json_encode($response);
      }else if($row["status"] == "RESTRICTED"){
        $response["status"] = false;
        $response["msg"] = 'User account has been "RESTRICTED" please contact support or admin to resolve issue';
        return json_encode($response);
      }else{
        if(password_verify($password, $row["password"])){
          if($row["two_factor"] == "On"){
            $response["status"] = "authentication";
            $response["msg"] = "A 4 digits OTP(One Time Passcode) code will be sent to your email please verify to be able to login your account";
            return json_encode($response);
          }else{
            $response["status"] = true;
            $response["msg"] = "Login successful you will be redirected shortly";
            $_SESSION["user_id"] = $row["unique_id"];
            setcookie("user_id", $row["unique_id"], time() + (86400 * 30), "/");
            return json_encode($response);
          }
        }else{
          $response["status"] = false;
          $response["msg"] = "Incorrect details please check details and try again";
          return json_encode($response);
        }
      }
    }else{
      $response["status"] = false;
      $response["msg"] = "Incorrect details please check details and try again ?";
      return json_encode($response);
    }
    $query->close();
  }
  
  
  public static function checkPin($conn, $user_id, $pin){
    $response = array();
    
    $sql = "SELECT pin FROM regtable WHERE unique_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $res = $stmt->get_result();
    if($res->num_rows == 1){
      $row = $res->fetch_assoc();
      $pin_float = (float)$pin;
      $saved_pin_float = (float)$row["pin"];
      if($pin_float == $saved_pin_float){
        $response["status"] = true;
        $response["msg"] = "User Entered Pin is correct";
        return $response;
      }else{
        $response["status"] = false;
        $response["msg"] = "Incorrect pin";
        return $response;
      }
    }else{
      $response["status"] = false;
      $response["msg"] = "User doesn't exist";
      return $response;
    }
  }
  
  
  public static function checkBalance($conn, $user_id, $amount){
    $response = array();
    
    $sql = "SELECT bal FROM regtable WHERE unique_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $res = $stmt->get_result();
    if($res->num_rows == 1){
      $row = $res->fetch_assoc();
      $balance_float = (float)$amount;
      $saved_balance_float = (float)$row["bal"];
      if($saved_balance_float >= $balance_float){
        $response["status"] = true;
        $response["msg"] = "User has enough balance to proceed";
        return $response;
      }else{
        $response["status"] = false;
        $response["msg"] = "Insufficient wallet balance, please fund your wallet and try again";
        return $response;
      }
    }else{
      $response["status"] = false;
      $response["msg"] = "User doesn't exist";
      return $response;
    }
  }
  
  
  public static function generateId($siteNameSlang, $howLong){
    $transactionId = "$siteNameSlang||".substr(str_shuffle("1234567890987654321567888899"), 0, $howLong)."||".rand(time(), 9999);
    return $transactionId;
  }
  
  
  public static function updateBalance($conn, $user_id, $type, $amount){
    $response = array();
    $t = "";
    $m = "";
    if($type == "credit"){
      $t = '+';
      $m = "credited";
    }else if($type == "debit"){
      $t = '-';
      $m = "debited";
    }
   $sql = "UPDATE regtable SET bal = bal ".$t." ? WHERE unique_id = ?";
   $stmt = $conn->prepare($sql);
   $stmt->bind_param("ss", $amount, $user_id);
   if($stmt->execute()){
     $response["status"] = true;
     $response["msg"] = "User wallet ".$m." successfully";
     return $response;
   }else{
     $response["status"] = false;
     $response["msg"] = "Unable To ".$m." user";
     return $response;
   }
  }
  
  public static function fetchDetail($conn, $user_id){
    $response = array();
    $sql = "SELECT * FROM regtable WHERE unique_id = ? OR email = ? OR phone = ? OR api_key = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $user_id, $user_id, $user_id, $user_id);
    $stmt->execute();
    $res = $stmt->get_result();
    if($res->num_rows > 0){
      $row = $res->fetch_assoc();
      
      $row["format_balance"] = "NGN ".number_format($row["bal"], 2);
      return $row;
    }else{
      $response["status"] = false;
      $response["msg"] = "No User found with this id ".$user_id."";
      return $response;
    }
  }
  
  
  public static function insertTransaction($conn, $user_id, $reference, $type, $phone, $network, $status, $old_bal, $new_bal, $amount, $no, $description, $date){
    $response = array();
    
    $sql = "INSERT INTO transaction (unique_id, reference, type, phone, network, status, old_bal, new_bal, amount, no, description, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssssssss", $user_id, $reference, $type, $phone, $network, $status, $old_bal, $new_bal, $amount, $no, $description, $date);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "User transaction recorded successfully";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "Unable/Fail to record transaction contact customer service to report this";
      return $response;
      exit();
    }
  }
  
  
  public static function fetchDiscount($conn, $service){
    $response = array();
    $sts = "On";
    $sql = "SELECT * FROM discount WHERE service = ? AND status = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $service, $sts);
    $stmt->execute();
    $query = $stmt->get_result();
    if($query->num_rows > 0){
      $row = $query->fetch_assoc();
      $response["status"] = true;
      $response["discount"] = $row["subscriber_percentage"];
      $response["msg"] = "Discount fetched Successfully";
      return $response;
    }else{
      $response["status"] = false;
      $response["msg"] = "No discount for airtime";
      return $response;
    }
  }
  
  public static function updateMode($conn, $user_id, $mode){
    $response = array();
    $sql = "UPDATE regtable SET mode = ? WHERE unique_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $mode, $user_id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "Mode Turned ".$mode." successfully";
      return $response;
    }else{
      $response["status"] = false;
      $response["msg"] = "Unable to update mode";
      return $response;
    }
  }
  
  
  
  public static function updatePassword($conn, $user_id, $newPassword){
    $response = array();
    
    $sql = "UPDATE regtable SET password = ? WHERE unique_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $newPassword, $user_id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "Password updated successfully";
      return $response;
    }else{
      $response["status"] = false;
      $response["msg"] = "unable to update password";
      return $response;
    }
  }
  
  
  
  public static function updatePin($conn, $user_id, $newPin){
    $response = array();
    
    $sql = "UPDATE regtable SET pin = ? WHERE unique_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $newPin, $user_id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "PIN updated successfully";
      return $response;
    }else{
      $response["status"] = false;
      $response["msg"] = "unable to update PIN";
      return $response;
    }
  }
  
  
  public static function site($conn){
    $response = array();
    
    $sql = "SELECT * FROM site_setting";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $query = $stmt->get_result();
    if($query->num_rows > 0){
      $row = $query->fetch_assoc();
      return $row;
    }
  }
  
  
  public static function createLock($conn, $user_id, $lock_type, $lock_name, $lock_desc, $amount, $status, $start, $end, $date){
    $response = array();
    
    $sql = "INSERT INTO lock_plan (unique_id, lock_type, lock_name, lock_description, amount, status, date_start, date_end, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssssss", $user_id, $lock_type, $lock_name, $lock_desc, $amount, $status, $start, $end, $date);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "Plan lock created successfully";
      return $response;
    }else{
      $response["status"] = false;
      $response["msg"] = "unable to create lock";
      return $response;
    }
  }
  
  public static function fetchTransaction($conn, $user_id, $ref){
    $response = array();
    
    $sql = "SELECT * FROM transaction WHERE unique_id = ? AND reference = ? OR phone = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sss", $user_id, $ref, $ref);
    $stmt->execute();
    $query = $stmt->get_result();
    
    if($query->num_rows > 0){
      $row = $query->fetch_assoc();
      $response["status"] = true;
      $response["msg"] = "Transaction fetched successfully"; 
      $response["details"][] = $row;
      return $response;
    }else{
      $response["status"] = false;
      $response["msg"] = "No transaction found with this reference"; 
      return $response;
    }
  }
  
  public static function updateTStatus($conn, $user_id, $reference, $status){
    $response = array();
    
    $sql = "UPDATE transaction SET status = ? WHERE unique_id = ? AND reference = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sss", $status, $user_id, $reference);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "Transaction record updated successful"; 
      return $response;
    }else{
      $response["status"] = false;
      $response["msg"] = "Unable to update transaction record"; 
      return $response;
    }
  }
  
  
  public static function calculateDiscount($discount, $amount){
    $float = (int)$discount / 100;
    $done = (int)$amount * (1 - $float);
    return (int)$done;
  }
  
  
  public static function countReferral($conn, $user_id){
    $response = array();
    
    $sql = "SELECT COUNT(*) as total_ref, SUM(bonus) as total_amount FROM referral WHERE unique_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $query = $stmt->get_result();
    if($query->num_rows > 0){
      while($row = $query->fetch_assoc()){
        return $row;
      }
    }else{
      $response["status"] = false;
      return $response;
    }
  }
  
  
  public static function fetchReferral($conn, $user_id){
    $response = array();
    
    $sql = "SELECT * FROM referral WHERE unique_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $query = $stmt->get_result();
    $all = array();
    if($query->num_rows > 0){
      while($row = $query->fetch_assoc()){
        $all[] = $row;
      }
      foreach ($all as $a){
        return $a["user_id"];
      }
    }else{
      $response["status"] = false;
      return $response;
    }
  }
  
  
  public static function updateVerification($conn, $user_id, $type, $value){
   $sql = "UPDATE verification SET ".$type." = ? WHERE unique_id = ?";
   $stmt = $conn->prepare($sql);
   $stmt->bind_param("ss", $value, $user_id);
   if($stmt->execute()){
     $response["status"] = true;
     $response["msg"] = "Verification updated successfully";
     return $response;
   }else{
     $response["status"] = false;
     $response["msg"] = "Unable to update verification";
     return $response;
   }
  }
  
  
public static function insertCardDetails($conn, $user_id, $cur, $cName, $cNumber, $expDate, $cvv, $cType, $date, $status, $reference){
    $response = array();
    
    $sql = "INSERT INTO cards (unique_id, currency, card_name, card_number, exp_date, cvv, card_type, date, status, reference) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssssss", $user_id, $cur, $cName, $cNumber, $expDate, $cvv, $cType, $date, $status, $reference);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "success";
      return $response;
    }else{
      $response["status"] = false;
      $response["msg"] = "Something went wrong try again later or contact support";
      return $response;
    }
    
    $stmt->close();
  }
  
    public static function updateUserPrevilage($conn, $user_id, $statusType){
       $sql = "UPDATE regtable SET status = ? WHERE unique_id = ?"; 
       $stmt = $conn->prepare($sql);
       $stmt->bind_param("ss", $statusType, $user_id);
       if($stmt->execute()){
         $response["status"] = true;
         $response["msg"] = "User account ".$statusType." successfully";
         return $response;
       }else{
         $response["status"] = false;
         $response["msg"] = "Unable to user ".$statusType." account";
         return $response;
       }
    }
    
    public static function siteService($conn, $service){
      $response = array();
      
      $sts = "On";
      $sql = "SELECT * FROM services WHERE service_name = ? AND status = ?";
      $stmt = $conn->prepare($sql);
      $stmt->bind_param("ss", $service, $sts);
      $stmt->execute();
      $query = $stmt->get_result();
      
      if($query->num_rows > 0){
        $row = $query->fetch_assoc();
        $response["status"] = true;
        $response["msg"] = $service." is avaiable"; 
        return $response;
        exit();
      }else{
        $response["status"] = false;
        $response["msg"] = $service." is unavaiable please check back later"; 
        return $response;
        exit();
      }
    }
}
?>