<?php
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "api_call.php";
 date_default_timezone_set("Africa/Lagos");
 if($_SERVER["REQUEST_METHOD"] === "POST"){
   $user_id = $_SESSION["user_id"];
   $user = Control::fetchDetail($conn, $user_id);
   if($user["status"] !== "VERIFIED"){
       echo "Your account is ".$user["status"]." you cant perform any action please contact customer care";
       unset($_SESSION["user_id"]);
       exit();
   }
   
   $amount = validate::validateInt($conn, $_POST["amount"]);
   $cable_type = validate::validateInt($conn, $_POST["cable-type"]);
   $cable_type_name = validate::validateString($conn, $_POST["cable-type-name"]);
   $cable_plan = validate::validateInt($conn, $_POST["cable-plan"]);
   $cable_plan_name = trim(str_replace(["(", ")", "=", number_format($amount)], "", validate::validateString($conn, $_POST["cable-plan-name"])));
   $iuc_number = validate::validateInt($conn, $_POST["iuc-number"]);
   $iuc_name = validate::validateString($conn, $_POST["iuc-name"]);
   
   $fetchDiscount = Control::fetchDiscount($conn, "Airtime");
   $percent = $fetchDiscount["discount"];
   $discount = Control::calculateDiscount($percent, $amount);
   
   
   $pin_1 = validate::validateInt($conn, $_POST["pin-1"]);
   $pin_2 = validate::validateInt($conn, $_POST["pin-2"]);
   $pin_3 = validate::validateInt($conn, $_POST["pin-3"]);
   $pin_4 = validate::validateInt($conn, $_POST["pin-4"]);
   
   $pin_join = $pin_1.$pin_2.$pin_3.$pin_4;
   
   $checkPin = Control::checkPin($conn, $user_id, $pin_join);
   if($checkPin["status"] == false){
     echo $checkPin["msg"];
     exit();
   }
   
   $checkBalance = Control::checkBalance($conn, $user_id, $amount);
   if($checkBalance["status"] == false){
     echo $checkBalance["msg"];
     exit();
   }
   
   
   
   
   $generateId = Control::generateId("CD", 10);
   
   $buyAirtime = Api::buyCable($conn, $cable_type, $iuc_number, $cable_plan, $amount, $generateId);
   if($buyAirtime["status"] == false){
     echo $buyAirtime["msg"];
     exit();
   }
   
   $updateBalance = Control::updateBalance($conn, $user_id, "debit", $discount);
   if($updateBalance["status"] == false){
     echo "Please contact customer support";
   }
   
   $description = "Cable Tv purchase of ".number_format($amount)." for ".$iuc_number."(".$iuc_name.") at discount of ".$percent."(".$discount.")";
   
   $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Cable Tv", $iuc_number, $cable_type_name, "success", $user["bal"], $user["bal"] - $amount, $discount, $iuc_name, $description, date("D d-M-Y h:i a"));
   if($insertTransaction["status"] !== true){
     echo $insertTransaction["msg"];
     exit();
   }
   
   
   echo '
    <div class="finish">
      <div class="finish-box">
       <div class="finish-box-head">
         <img src="images/check.png" alt="success image">
         <h2>Success, Cable TV purchase successful</h2>
       </div>
       <table>
         <tr>
           <td>Type</td>
           <td>'.$cable_type_name.'</td>
         </tr>
         <tr>
           <td>Plan</td>
           <td>'.$cable_plan_name.'</td>
         </tr>
         <tr>
           <td>Cable Name</td>
           <td>'.$iuc_name.'</td>
         </tr>
         <tr>
           <td>IUC Number</td>
           <td>'.$iuc_number.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($discount, 2).'</td>
         </tr>
       </table>
       <div class="buttons">
         <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
         <button class="bg" onclick="window.location.reload()">BUY AGAIN</button>
       </div>
      </div>
    </div>
   ';
   exit();
 }
?>