<?php
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "api_call.php";
  require "mail.php";
 date_default_timezone_set("Africa/Lagos");
 if($_SERVER["REQUEST_METHOD"] === "POST"){
   $user_id = $_SESSION["user_id"];
   $user = Control::fetchDetail($conn, $user_id);
   if($user["status"] !== "VERIFIED"){
       echo "Your account is ".$user["status"]." you cant perform any action please contact customer care";
       unset($_SESSION["user_id"]);
       exit();
   }
  
   
   $sender = validate::validateString($conn, $_POST["sender"]);
   $type = validate::validateString($conn, $_POST["type"]);
   $phoneNumbers = validate::validateString($conn, $_POST["phone-numbers"]);
   $msg = $_POST["message"];
   $amount = validate::validateInt($conn, $_POST["amount"]);
   $count = validate::validateInt($conn, $_POST["count"]);
   
   
   $pin_1 = validate::validateInt($conn, $_POST["pin-1"]);
   $pin_2 = validate::validateInt($conn, $_POST["pin-2"]);
   $pin_3 = validate::validateInt($conn, $_POST["pin-3"]);
   $pin_4 = validate::validateInt($conn, $_POST["pin-4"]);
   
   $pin_join = $pin_1.$pin_2.$pin_3.$pin_4;
   
   $checkPin = Control::checkPin($conn, $user_id, $pin_join);
   if($checkPin["status"] == false){
     echo $checkPin["msg"];
     exit();
   }
   
   $checkBalance = Control::checkBalance($conn, $user_id, $amount);
   if($checkBalance["status"] == false){
     echo $checkBalance["msg"];
     exit();
   }
   
    
   
   $generateId = Control::generateId("CD", 20);
   
   $response = Api::buyBulkSms($conn, $sender, $phoneNumbers, $msg);
   if($response["status"] !== true){
       echo $response["msg"];
       exit;
   }
   
   $updateBalance = Control::updateBalance($conn, $user_id, "debit", $amount);
   if($updateBalance["status"] == false){
     echo "Err! Please contact customer support";
   }
   
   $description = "Bulk sms sent successfully to ".$count." phone numbers";
   
   $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Bulk Sms", $msg, $sender, "success", $user["bal"], $user["bal"] - $amount, $amount, $phoneNumbers, $description, date("D d-M-Y h:i a"));
   if($insertTransaction["status"] == false){
     echo $insertTransaction["msg"];
     exit();
   }
   
   echo '
    <div class="finish">
      <div class="finish-box">
       <div class="finish-box-head">
         <img src="images/check.png" alt="success image">
         <h2>SUCCESS</h2>
       </div>
       <table>
         <tr>
           <td>Sender</td>
           <td>'.$sender.'</td>
         </tr>
         <tr>
           <td>Message</td>
           <td>'.$msg.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($amount, 2).'</td>
         </tr>
       </table>
       <div class="buttons">
         <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
         <button class="bg" onclick="window.location.reload();">BUY AGAIN</button>
       </div>
      </div>
    </div>
   ';
   exit();
   $site = Control::site($conn);

$msg = '
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>Document</title>
  <link href="https://fonts.googleapis.com/css2?family=Mitr:wght@300;400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    *{
      box-sizing: border-box;
      font-family: "Mitr", Sans-Serif;
    }
    .head{
      background: linear-gradient(to left,#3333ff,#3333ff);
      height: 120px;
      color: #fff;
      display: grid;
      grid-template-column: repeat(1, 1fr);
      flex-direction: column;
      padding: 10px;
    }
    .head img{
      width: auto;
      height: 70px;
      object-fit:cover;
      display: block;
    }
    .head b{
      font-size: 22px;
      font-weight: 900;
      display: block;
      margin-top: 0px;
    }
    .bottom{
      background: linear-gradient(to left,#3333ff,#3333ff);;
      height: 50px;
      color: #fff;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .bottom i{
      margin-left: 10px;
      margin-right: 10px;
      font-size: 18px;
    }
    .body{
      padding: 15px;
      background: #0002;
    }
    .scam-alert{
      font-size: 12px;
      color: #555;
    }
    .greet{
      font-size: 16px;
      font-weight: 900;
      color: #000;
      margin-bottom: 20px;
      display: block;
    }
    table{
      margin: 0;
      margin-top: 15px;
      margin-bottom: 15px;
    }
    table tr{
      height: 25px;
      width: 100%;
      padding: 5px;
    }
    table tr td:nth-child(1){
      font-weight: 500;
      font-size: 13px;
      color: #000;
      width: 120px;
    }
    table tr td:nth-child(2){
      font-weight: 500;
      font-size: 13px;
      color: #777;
    }
  </style>
</head>
<body>
  <div class="head">
    <img src="https://'.$_SERVER["HTTP_HOST"].'/app/logos/logo.png" alt="logo">
    <b>NGN '.number_format($amount, 2).'</b>
  </div>
  <div class="body">
    <b class="greet">Hello, '.$user["fname"].'</b>
    
    <table>
      <tr>
        <td>Type</td>
        <td>Bulk sms</td>
      </tr>
      
        <td>Date</td>
        <td>'.date("D d-M-Y h:i a").'</td>
      </tr>
    </table>
    
    <div class="scam-alert">If this wasnt done by you <a href="https://'.$_SERVER["HTTP_HOST"].'/app/login.php">Login</a> to reset your password and also contact support for help at <a href="'.$site["support_email"].'">'.$site["support_email"].'</a>. Thank you for using '.$site["site_name"].'</div>
  </div>
  <div class="bottom">
    <i class="fab fa-facebook"></i>
    <i class="fab fa-whatsapp"></i>
    <i class="fab fa-instagram"></i>
  </div>
</body>
</html>
';

 sendOtpMail($conn, $user["unique_id"], $user["email"], "Transaction Alert", $msg, "Email notification send successfully");
 }
?>