<?php
session_start();
include_once "conn.php";
require "controller.php";
require "api_call.php";
 require "mail.php";
date_default_timezone_set("Africa/Lagos");

if($_SERVER["REQUEST_METHOD"] !== "POST"){
   echo "Invalid server request method";
   exit();
}

  $user_id = $_SESSION["user_id"];
  $user = Control::fetchDetail($conn, $user_id);
  if($user["status"] !== "VERIFIED"){
       echo "Your account is ".$user["status"]." you cant perform any action please contact customer care";
       unset($_SESSION["user_id"]);
       exit();
   }
  
  $provider = validate::validateInt($conn, $_POST["provider"]);
  $provider_name = validate::validateString($conn, $_POST["provider-name"]);
  
  $betting_no = validate::validateInt($conn, $_POST["betting-no"]);
  $betting_name = validate::validateString($conn, $_POST["betting-name"]);
  
  $amount = validate::validateInt($conn, $_POST["amount"]);
  
  $fetchDiscount = Control::fetchDiscount($conn, "Electricity");
  $percent = $fetchDiscount["discount"];
  $discount = Control::calculateDiscount($percent, $amount);
  
  
  $pin_1 = validate::validateInt($conn, $_POST["pin-1"]);
  $pin_2 = validate::validateInt($conn, $_POST["pin-2"]);
  $pin_3 = validate::validateInt($conn, $_POST["pin-3"]);
  $pin_4 = validate::validateInt($conn, $_POST["pin-4"]);
  
  $pin_join = $pin_1.$pin_2.$pin_3.$pin_4;
  
  $checkPin = Control::checkPin($conn, $user_id, $pin_join);
  if($checkPin["status"] == false){
    echo $checkPin["msg"];
    exit();
  }
  
  $checkBalance = Control::checkBalance($conn, $user_id, $amount);
  if($checkBalance["status"] == false){
    echo $checkBalance["msg"];
    exit();
  }
  
  
  
  $generateId = Control::generateId("CD", 10);

  $buyElectric = Api::fundBetting($conn, $provider, $betting_no, $amount, $generateId);
  if($buyElectric["status"] == false){
    echo $buyElectric["msg"];
    exit();
  }
  
  $updateBalance = Control::updateBalance($conn, $user_id, "debit", $discount);
  if($updateBalance["status"] == false){
    echo "Err! Please contact customer support";
  }
  
  $description = "Bet funding of NGN ".number_format($amount)." for ".$betting_name."(".$provider_name.")";
  
  $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Betting", $betting_no, $provider_name, "success", $user["bal"], $user["bal"] - $discount, $discount, $betting_name, $description, date("D d-M-Y h:i a"));
  if($insertTransaction["status"] == false){
    echo $insertTransaction["msg"];
    exit();
  }
  
   echo '<div class="finish">
     <div class="finish-box">
      <div class="finish-box-head">
        <img src="images/check.png" alt="success image">
        <h2>Success, Your bet funding was successful.</h2>
      </div>
      <table>
        <tr>
          <td>Provider</td>
          <td>'.$provider_name.'</td>
        </tr>
        <tr>
          <td>Betting Id</td>
          <td>'.$betting_no.'</td>
        </tr>
        <tr>
          <td>Name</td>
          <td>'.$betting_name.'</td>
        </tr>
          <td>Amount</td>
          <td>NGN '.number_format($discount, 2).'</td>
        </tr>
      </table>
      <div class="buttons">
        <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
        <button class="bg" onclick="window.location.reload()">BUY AGAIN</button>
      </div>
     </div>
   </div>
  ';
  exit();
  
?>