<?php
class Api{
  
  public static function getServiceApi($conn, $service_name){
    $response = array();
    $On = "On";
    $sql = "SELECT * FROM api WHERE service = ? AND status = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $service_name, $On);
    $stmt->execute();
    $query = $stmt->get_result();
    if($query->num_rows > 0){
      $row = $query->fetch_assoc();
      $row["status"] = true;
      $row["msg"] = "Api details fetched successfully";
      return $row;
    }else{ 
      $response["status"] = false;
      $response["msg"] = "Unable to perform request please try again later";
      return $response;
    }
  }
  
   public static function buyDatapin($conn, $networkId, $amountt, $quantity, $cardname, $transactionId){
    $response = array();
    
     $api_call = Api::getServiceApi($conn, "DATA_PIN");
    if($api_call["status"] !== true){
      $response["status"] = false;
      $response["msg"] = $api_call["msg"];
      return $response;
      exit();
    }
    
    $pb_key = $api_call["public_key"];
    $api_key = $api_call["secret_key"];
    $url = $api_call["url"];
    if(strstr($api_call["name"], "N3DATA") || strstr($api_call["name"], "n3data")){
      $get_api_key = self::getAccessToken("https://n3tdata.com/api/user", $api_call["public_key"], $api_call["secret_key"]);
      if($get_api_key["status"] == false){
        $response["status"] = false;
        $response["msg"] = $get_api_key["msg"];
        return $response;
        exit();
      }else{
        $api_key = $get_api_key["token"];
      }
    }
    
    $data = [
      "serviceID" => $networkId,
      "network" => $networkId,
      "quantity" => $quantity,
      "name_on_card" => $cardname,
      "request-id" => $transactionId,
      "request_id" => $transactionId,
      "datacard_plan" => "$amountt",
      ];
      
     $ch = curl_init();
     curl_setopt_array($ch, array( 
       CURLOPT_URL => $url,
       CURLOPT_RETURNTRANSFER => true,
       CURLOPT_ENCODING => '',
       CURLOPT_MAXREDIRS => 10,
       CURLOPT_TIMEOUT => 0,
       CURLOPT_FOLLOWLOCATION => true,
       CURLOPT_CUSTOMREQUEST => "POST",
       CURLOPT_POST => true,
       CURLOPT_POSTFIELDS => json_encode($data),
       CURLOPT_HTTPHEADER => array( 
         "Accept: application/json",
         "Content-Type: application/json",
         "trnx_pin: ".$pb_key."",
         "mobileization: ".$api_key."",
         ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Errors";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Unable to retrieve server response";
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
        $response["status"] = false;
        $response["msg"] = "Something went wrong try again later".$api_resp;
        return $response;
        exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Datacard purchase of 1quantity MTN GIFTING ";
         $response["pin"] = $api_decode["data"]["pin"];
         $response["serial_no"] = $api_decode["data"]["serial"];
         $response["load_pin"] = $api_decode["data"]["load_pin"];
         return $response;
         exit();
       }
  }
  
  public static function getAccessToken($url, $username, $password){
    $response = array();
    $uname = $username;
    $password = $password;
    $encode = base64_encode($uname.':'.$password);
    
    $ch = curl_init();
     curl_setopt_array($ch, array(
       CURLOPT_URL => $url,
       CURLOPT_RETURNTRANSFER => true,
       CURLOPT_CUSTOMREQUEST => "POST",
       CURLOPT_POST => 1,
       CURLOPT_HTTPHEADER => array( 
         "mobileization: Basic ".$encode,
         ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Unable to retrieve server response";
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
         $response["status"] = false;
         $response["msg"] = "Something went wrong try again later".json_encode($api_decode);
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Success, token generated successful";
         $response["token"] = $api_decode["AccessToken"];
         return $response;
         exit();
       }
  }
  
  
  public static function buyAirtime($conn, $networkId, $phoneNumber, $amount, $transitionId){
    $response = array();
    
    $api_call = Api::getServiceApi($conn, "AIRTIME");
    if($api_call["status"] !== true){
      $response["status"] = false;
      $response["msg"] = $api_call["msg"];
      return $response;
      exit();
    }
    
    $pb_key = $api_call["public_key"];
    $api_key = $api_call["secret_key"];
    $url = $api_call["url"];
    
    if(strstr($api_call["name"], "N3DATA") || strstr($api_call["name"], "n3data") || strstr($api_call["name"], "N3TDATA") || strstr($api_call["name"], "n3tdata")){
      $get_api_key = self::getAccessToken("https://n3tdata.com/api/user", $api_call["public_key"], $api_call["secret_key"]);
      if($get_api_key["status"] == false){
        $response["status"] = false;
        $response["msg"] = $get_api_key["msg"];
        return $response;
        exit();
      }else{
        $api_key = $get_api_key["token"];
      }
    }
    
    $data = [
      "serviceID" => $networkId,
      "network" => $networkId,
      
      "phone" => $phoneNumber,
      "phone_number" => $phoneNumber,
      "mobileNumber" => $phoneNumber,
      "mobile_number" => $phoneNumber,
      
      "country_code" => "NG",
      
      "plan-type" => "VTU",
      "plan_type" => "VTU",
      "airtime_type" => "VTU",
      
      "bypass" => true,
      "Ported_number" => true,
      
      "request-id" => $transitionId,
      "request_id" => $transitionId,
      
      "amount" => $amount,
      ];
      
     $ch = curl_init();
     curl_setopt_array($ch, array(
       CURLOPT_URL => $url,
       CURLOPT_RETURNTRANSFER => true,
       CURLOPT_ENCODING => '',
       CURLOPT_MAXREDIRS => 10,
       CURLOPT_TIMEOUT => 0,
       CURLOPT_FOLLOWLOCATION => true,
       CURLOPT_CUSTOMREQUEST => "POST",
       CURLOPT_POST => true,
       CURLOPT_POSTFIELDS => json_encode($data),
       CURLOPT_HTTPHEADER => array( 
         "Accept: application/json",
         "Content-Type: application/json",
         "trnx_pin: ".$pb_key."",
         "mobileization: ".$api_key."",
         ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"]) && !isset($api_decode["Status"])){
         $response["status"] = false;
         $response["msg"] = "Unable to retrieve server response".$api_resp;
         return $response;
         exit();
       }
       
       $status = (isset($api_decode["status"]) ? $api_decode["status"] : $api_decode["Status"]);
       
       if($status !== "success" && $status !== "successful"){
          $message = (isset($api_decode["msg"]) ? $api_decode["msg"] : $api_decode["message"]);
          if(strstr($message, "Insufficient")){
            $response["status"] = false;
            $response["msg"] = "Something went wrong try again later";
            return $response;
            exit();
          }else{
            $response["status"] = false;
            $response["msg"] = $message;
            return $response;
            exit();
          }
       }else{
         $response["status"] = true;
         $response["msg"] = "Airtime Purchase Successful, your airtime is on it's way to ".$phoneNumber."";
         return $response;
         exit();
       }
  }
  
  
  
  public static function buyAirtimePin($conn, $networkId, $amount, $quantity, $cardname, $transactionId){
    $response = array();
    
    $api_call = Api::getServiceApi($conn, "AIRTIME_PIN");
    if($api_call["status"] !== true){
      $response["status"] = false;
      $response["msg"] = $api_call["msg"];
      return $response;
      exit();
    }
    
    $pb_key = $api_call["public_key"];
    $api_key = $api_call["secret_key"];
    $url = $api_call["url"];
    if(strstr($api_call["name"], "N3DATA") || strstr($api_call["name"], "n3data")){
      $get_api_key = self::getAccessToken("https://n3tdata.com/api/user", $api_call["public_key"], $api_call["secret_key"]);
      if($get_api_key["status"] == false){
        $response["status"] = false;
        $response["msg"] = $get_api_key["msg"];
        return $response;
        exit();
      }else{
        $api_key = $get_api_key["token"];
      }
    }
    
    $data = [
      "serviceID" => $networkId,
      "network" => $networkId,
      "quantity" => $quantity,
      "name_on_card" => $cardname,
      "bypass" => true,
      "request-id" => $transactionId,
      "request_id" => $transactionId,
      "amount" => "100",
      ];
      
     $ch = curl_init();
     curl_setopt_array($ch, array( 
       CURLOPT_URL => $url,
       CURLOPT_RETURNTRANSFER => true,
       CURLOPT_ENCODING => '',
       CURLOPT_MAXREDIRS => 10,
       CURLOPT_TIMEOUT => 0,
       CURLOPT_FOLLOWLOCATION => true,
       CURLOPT_CUSTOMREQUEST => "POST",
       CURLOPT_POST => true,
       CURLOPT_POSTFIELDS => json_encode($data),
       CURLOPT_HTTPHEADER => array( 
         "Accept: application/json",
         "Content-Type: application/json",
         "trnx_pin: ".$pb_key."",
         "mobileization: ".$api_key."",
         ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Unable to retrieve server response";
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
        $response["status"] = false;
        $response["msg"] = "Something went wrong try again later".$api_resp;
        return $response;
        exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Airtime Pin Purchase Successful";
         $response["pin"] = $api_decode["data"]["pin"];
         $response["serial_no"] = $api_decode["data"]["serial"];
         $response["load_pin"] = $api_decode["data"]["load_pin"];
         return $response;
         exit();
       }
  }
  
  
  
  public static function buyData($conn, $networkId, $data_type, $data_plan, $phoneNumber, $amount, $transitionId){
    $response = array();
     
    $api_call = Api::getServiceApi($conn, "DATA");
    if($api_call["status"] !== true){
      $response["status"] = false;
      $response["msg"] = $api_call["msg"];
      return $response;
      exit();
    }
    
    $pb_key = $api_call["public_key"];
    $api_key = $api_call["secret_key"];
    $url = $api_call["url"];
    if(strstr($api_call["name"], "N3DATA") || strstr($api_call["name"], "n3data")){
      $get_api_key = self::getAccessToken("https://n3tdata.com/api/user", $api_call["public_key"], $api_call["secret_key"]);
      if($get_api_key["status"] == false){
        $response["status"] = false;
        $response["msg"] = $get_api_key["msg"];
        return $response;
        exit();
      }else{
        $api_key = $get_api_key["token"];
      }
    }
    
    $data = array(
      //network eg mtn, Airtel, glo, 9mobile...,...
     "network" => $networkId,
     //phone number
     "mobileNumber" => $phoneNumber,
     "phone" => $phoneNumber,
     "phone_number" => $phoneNumber,
     //country code
     "country_code" => "NG",
     //data plan
     "data-plan" => $data_plan,
     "serviceID" => $data_plan,
     "data_plan" => $data_plan,
     //data type
     "plan-type" => $data_type,
     "plan_type" => $data_type,
     //bypass default=True
     "bypass" => true,
     //request is = transaction reference
     "request-id" => $transitionId,
     "request_id" => $transitionId,
     //amount
     "amount" => $amount,
    );
    
    $ch = curl_init();
    curl_setopt_array($ch, array(
       CURLOPT_URL => $url,
       CURLOPT_RETURNTRANSFER => true,
       CURLOPT_ENCODING => '',
       CURLOPT_MAXREDIRS => 10,
       CURLOPT_TIMEOUT => 0,
       CURLOPT_FOLLOWLOCATION => true,
       CURLOPT_CUSTOMREQUEST => "POST",
       CURLOPT_POST => true,
       CURLOPT_POSTFIELDS => json_encode($data),
       CURLOPT_HTTPHEADER => array( 
         "Accept: application/json",
         "Content-Type: application/json",
         "trnx_pin: ".$pb_key."",
         "mobileization: ".$api_key."",
         ),
      ));
      
      $api_resp = curl_exec($ch);
      $api_decode = json_decode($api_resp, true);
      $err = curl_error($ch);
      
      if($err){
        $response["status"] = false;
        $response["msg"] = "Server or Network Error";
        return $response;
        exit();
      }
      
      if(!isset($api_decode["status"])){
        $response["status"] = false;
        $response["msg"] = "Unable to retrieve server response";
        return $response;
        exit();
      }
      
      if($api_decode["status"] !== "success"){
        $message = (isset($api_decode["msg"]) ? $api_decode["msg"] : $api_decode["message"]);

        $response["status"] = false;
        $response["msg"] = $message;
        return $response;
        exit();
      }else{
        $response["status"] = true;
        $response["msg"] = "Data Recharge Successful, Your data is on it's way to ".$phoneNumber."";
        return $response;
        exit();         
      }
  }
  
  
  public static function verify_paystack($conn, $reference){
    $response = array();
    $api_call = self::getServiceApi($conn, "VERIFY_PAYSTACK");
    if($api_call["status"] !== true){
      $response["status"] = false;
      $response["msg"] = $api_call["msg"];
      return $response;
      exit();
    }
    $api_key = $api_call["secret_key"];
    $url = $api_call["url"];
    
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url.$reference,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "GET", 
        CURLOPT_HTTPHEADER => array(
          "Content-Type: application/json",
          "mobileization: Bearer ".$api_key."",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       
       if(curl_error($ch)){
         $response["status"] = false;
         $response["status"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["data"]["status"])){
         $response["status"] = false;
         $response["status"] = "Invalid payment reference unmobileized your account maybe blocked";
         return $response;
         exit();
       }
       
       if($api_decode["data"]["status"] == "Success" || $api_decode["data"]["status"] == "success"){
         $response["status"] = true;
         $response["msg"] = "Transaction Successful";
         return $response;
         exit();
       }else if($api_decode["data"]["status"] == "failed"){
         $response["status"] = false;
         $response["status"] = "Transaction failed";
         return $response;
         exit();
       }
       
       curl_close($ch);
  }
  
  
  public static function verify_meter($conn, $provider, $meter_type, $meter_no){
    $response = array();
    
    $data = array(
      "provider" => $provider,
      "meter_id" => $provider,
      "meternumber" => $meter_no,
      "meter_number" => $meter_no,
      "metertype" => $meter_type,
      "meter_type" => $meter_type,
      );
      
     $api_call = self::getServiceApi($conn, "ELECTRICITY_VERIFY");
     if($api_call["status"] !== true){
      $response["status"] = false;
      $response["msg"] = $api_call["msg"];
      return $response;
      exit();
     }
    
     $pb_key = $api_call["public_key"];
     $api_key = $api_call["secret_key"];
     $url = $api_call["url"]."?meter_id=".$provider."&meter_number=".$meter_no."&meter_type=prepaid";
     
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "GET", 
        CURLOPT_HTTPHEADER => array(
          "Accept: application/json",
          "Content-Type: application/json",
          "trnx_pin: ".$pb_key."",
          "mobileization: ".$api_key."",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       
       if(curl_error($ch)){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Unable to perform request at this moment!!";
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
         $response["status"] = false;
         $response["msg"] = "Unable to perform request at this moment?".$api_resp;
         return $response;
         exit();
       }
       //$name = (isset($api_decode["name"]) ? $api_decode["name"] : $api_decode["data"]["name"]);
       $name = $api_decode["data"]["customer_name"];
       if($api_decode["status"] == "success" && strstr($name, "INVALID")){
         $response["status"] = false;
         $response["msg"] = "Invalid meter number no name found";
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Success name fetched successfully";
         $response["name"] = $name;
         return $response;
         exit();
       }
       curl_close($ch);
  }
  
  
  
  
public static function verify_cable($conn, $provider, $iuc_no){
    $response = array();
      
     $api_call = self::getServiceApi($conn, "CABLE_TV_VERIFY");
     if($api_call["status"] !== true){
      $response["status"] = false;
      $response["msg"] = $api_call["msg"];
      return $response;
      exit();
     }
    
     $pb_key = $api_call["public_key"];
     $api_key = $api_call["secret_key"];
     $url = $api_call["url"]."?cable_id=".$provider."&cable_number=".$iuc_no;
     
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "GET", 
        CURLOPT_HTTPHEADER => array(
          "Accept: application/json",
          "Content-Type: application/json",
          "trnx_pin: ".$pb_key."",
          "mobileization: ".$api_key."",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       
       if(curl_error($ch)){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Unable to perform request at this moment!!";
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
         $response["status"] = false;
         $response["msg"] = "Unable to perform request at this moment?".$api_resp;
         return $response;
         exit();
       }
       
       if($api_decode["status"] == "success" && strstr($name, "INVALID")){
         $response["status"] = false;
         $response["msg"] = "Invalid meter number no name found";
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Success name fetched successfully";
         $response["name"] = $api_decode["data"]["customer_name"];
         return $response;
         exit();
       }
       curl_close($ch);
  }
  
  
  
  
  //================================================================
  //================================================================
  public static function buyElectric($conn, $provider, $meter_type, $meter_no, $amount, $transitionId){
    $response = array();
    $meter_type = "prepaid";
    
    $data = [
      //provider for meter
      "disco" => $provider,
      "provider" => $provider,
      "meter_id" => $provider,
      "meter_provider" => $provider,
      "serviceID" => $provider,
      "service_id" => $provider,
      //meter type for electric
      "metertype" => $meter_type,
      "meter_type" => $meter_type,
      "meter-type" => $meter_type,
      //meter number for different types of api to match
      "meterNum" => $meter_no,
      "meternumber" => $meter_no,
      "meter_number" => $meter_no,
      "meter-number" => $meter_no,
      //amount
      "amount" => $amount,
      //bypass set to true
      "bypass" => true,
      //request-id as transaction reference
      "request-id" => $transitionId,
      "request_id" => $transitionId,
      ];
      
    $api_call = self::getServiceApi($conn, "ELECTRICITY");
    if($api_call["status"] !== true){
      $response["status"] = false;
      $response["msg"] = $api_call["msg"];
      return $response;
      exit();
    }
    
    $pb_key = $api_call["public_key"];
    $api_key = $api_call["secret_key"];
    $url = $api_call["url"];
    if(strstr($api_call["name"], "N3DATA") || strstr($api_call["name"], "n3data")){
      $get_api_key = self::getAccessToken("https://n3tdata.com/api/user", $api_call["public_key"], $api_call["secret_key"]);
      if($get_api_key["status"] == false){
        $response["status"] = false;
        $response["msg"] = $get_api_key["msg"];
        return $response;
        exit();
      }else{
        $api_key = $get_api_key["token"];
      }
    }
     
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "POST", 
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
          "Accept: application/json",
          "Content-Type: application/json",
          "trnx_pin: ".$pb_key."",
          "mobileization: ".$api_key."",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Something went wrong try again later";
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
         $message = (isset($api_decode["msg"]) ? $api_decode["msg"] : $api_decode["message"]);
         if(strstr($api_decode["msg"], "Insufficient")){
           $response["status"] = false;
           $response["msg"] = "Unable to perform request at this moment try again later!!";
           return $response;
           exit();
         }else{
           $response["status"] = false;
           $response["msg"] = "Unable to perform request at this moment try again later";
           return $response;
           exit();
         }
       }
       
       if($api_decode["status"] == "success"){
           $response["status"] = true;
           $response["msg"] = "Success, Electricity purchase was successful TOKEN: ". (isset($api_decode["token"]) ? $api_decode["token"] : $api_decode["data"]["token"]);
           $response["token"] = (isset($api_decode["token"]) ? $api_decode["token"] : $api_decode["data"]["token"]);
           $response["units"] = (isset($api_decode["units"]) ? $api_decode["units"] : "");
           return $response;
           exit();
       }
       
       curl_close($ch);
  }
  
  
  
public static function buyCable($conn, $provider, $iuc_number, $cable_plan, $amount, $transitionId){
    $response = array();
    
    $data = [
      //provider/service_id for cable
      "provider" => $provider,
      "cable" => $provider,
      "cable_id" => $provider,
      "serviceID" => $provider,
      "service_id" => $provider,
      //iuc number for different types of api to match
      "iuc" => $iuc_number,
      "iucNum" => $iuc_number,
      "iuc_number" => $iuc_number,
      "cable_number" => $iuc_number,
      //cable ppan
      "cable_plan" => $cable_plan,
      //amount
      "amount" => $amount,
      //bypass set to true
      "bypass" => true,
      //request-id as transaction reference
      "request-id" => $transitionId,
      "request_id" => $transitionId,
      ];
      
     $api_call = self::getServiceApi($conn, "CABLE_TV");
    
    $pb_key = $api_call["public_key"];
    $api_key = $api_call["secret_key"];
    $url = $api_call["url"];
    
    if(strstr($api_call["name"], "N3DATA") || strstr($api_call["name"], "n3data")){
      $get_api_key = self::getAccessToken("https://n3tdata.com/api/user", $api_call["public_key"], $api_call["secret_key"]);
      if($get_api_key["status"] == false){
        $response["status"] = false;
        $response["msg"] = $get_api_key["msg"];
        return $response;
        exit();
      }else{
        $api_key = $get_api_key["token"];
      }
    }
     
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "POST", 
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
          "Accept: application/json",
          "Content-Type: application/json",
          "trnx_pin: ".$pb_key."",
          "mobileization: ".$api_key."",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Something went wrong try again later";
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
         $message = (isset($api_decode["msg"]) ? $api_decode["msg"] : $api_decode["message"]);
         if(strstr($api_decode["msg"], "Insufficient")){
           $response["status"] = false;
           $response["msg"] = "Unable to perform request at this moment try again later!";
           return $response;
           exit();
         }else{
           $response["status"] = false;
           $response["msg"] = "Unable to perform request at this moment try again later?".$api_resp;
           return $response;
           exit();
         }
       }
       
       if($api_decode["status"] == "success"){
           $response["status"] = true;
           $response["msg"] = "Success, Cable Tv purchase successful";
           return $response;
           exit();
       }
       
       curl_close($ch);
  }
  
  
  
public static function buyExam($conn, $provider, $quantity, $transitionId){
    $response = array();
    
    $data = [
      //provider/service_id for cable
      "exam" => $provider,
      "exam_name" => $provider,
      "exam_type" => $provider,
      "exam_id" => $provider,
      "exam-name" => $provider,
      "exam-type" => $provider,
      //iuc number for different types of api to match
      "quantity" => $quantity,
      //bypass set to true
      "bypass" => true,
      //request-id as transaction reference
      "request-id" => $transitionId,
      "request_id" => $transitionId,
      ];
      
     $api_call = self::getServiceApi($conn, "EXAM_PIN");
    
    
    $pb_key = $api_call["public_key"];
    $api_key = $api_call["secret_key"];
    $url = $api_call["url"];
    
    if(strstr($api_call["name"], "N3DATA") || strstr($api_call["name"], "n3data")){
      $get_api_key = self::getAccessToken("https://n3tdata.com/api/user", $api_call["public_key"], $api_call["secret_key"]);
      if($get_api_key["status"] == false){
        $response["status"] = false;
        $response["msg"] = $get_api_key["msg"];
        return $response;
        exit();
      }else{
        $api_key = $get_api_key["token"];
      }
    }
     
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "POST", 
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
          "Accept: application/json",
          "Content-Type: application/json",
          "trnx_pin: ".$pb_key."",
          "mobileization: ".$api_key."",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Something went wrong try again later";
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
         $message = (isset($api_decode["msg"]) ? $api_decode["msg"] : $api_decode["message"]);
         if(strstr($api_decode["msg"], "Insufficient")){
           $response["status"] = false;
           $response["msg"] = "Unable to perform request at this moment try again later";
           return $response;
           exit();
         }else{
           $response["status"] = false;
           $response["msg"] = "Unable to perform request at this moment try again later??";
           return $response;
           exit();
         }
       }
       
       if($api_decode["status"] == "success"){
           
           $response["status"] = true;
           $response["msg"] = "Success, Exam Pin purchase successful";
           $response["pins"] = $api_decode["pin"];
           $response["serials"] = $api_decode["serial"];
           return $response;
           exit();
       }
       
       curl_close($ch);
  }
  
  
  
  public static function generate_strowallet($conn, $type, $name, $email, $phone){
    $response = array();
    
     $api_call = "";
     if($type == "Paga"){
       $api_call = self::getServiceApi($conn, "STROWALLET_GENERATE_PROVIDUS");
     }else if($type == "Safe-Haven"){
       $api_call = self::getServiceApi($conn, "STROWALLET_GENERATE_SAFE_HAVEN_MFB");
     }else if($type == "Bankly"){
       $api_call = self::getServiceApi($conn, "STROWALLET_GENERATE_BANKLY");
     }
     $pb_key = $api_call["public_key"];
     $url = $api_call["url"];
      
    $data = [
      "public_key" => $pb_key,
      "email" => $email,
      "account_name" => $name,
      "phone" => $phone,
      "webhook_url" => "https://".$_SERVER["HTTP_HOST"]."/mobile/weburls/strowallet.php",
      "mode" => "",
      ];
      
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "POST", 
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
          "content-type: application/json",
          "accept: application/json",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["success"])){
         $response["status"] = false;
         $response["msg"] = "Something went wrong try again later".$api_resp;
         return $response;
         exit();
       }
       
       if($api_decode["success"] !== true){
         $response["status"] = false;
         $response["msg"] = "Unable yo generate account try again later";
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Account generated successfully";
         $response["bank_name"] = $api_decode["bank_name"];
         $response["account_name"] = $api_decode["account_name"];
         $response["account_no"] = $api_decode["account_number"];
         return $response;
         exit();
       }
       curl_close($ch);
  }
  
  
  
  
 public static function generate_ncwallet($conn, $name, $email, $phone, $type, $bank_code,  $amount){
    $response = array();
$bvn = "22605692300";
     $api_call = self::getServiceApi($conn, "NCWALLET_CREATE_VIRTUAL_ACCOUNT");
     $pin = $api_call["public_key"];
     $api_key = $api_call["secret_key"];
     $url = $api_call["url"];
      
    $data = array(
      "bank_code" => $bank_code,
      "account_name" => $name,
      "email" => $email,
      "phone_number" => $phone,
      "account_type" => $type,
      "validation_type" => "BVN",
      "validation_number" => $bvn,
      "dynamic_amount" => $amount,
      );
      
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "POST", 
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
          "Content-Type: application/json",
          "Accept: application/json",
          "trnx_pin: ".$pin,
          "mobileization: ".$api_key,
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Something went wrong try again later".$api_resp;
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
         $response["status"] = false;
         $response["msg"] = "Unable yo generate account try again later".$api_resp;
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Account generated successfully";
         $response["bank_name"] = $api_decode["data"]["bank_name"];
         $response["account_name"] = $api_decode["data"]["account_name"];
         $response["account_no"] = $api_decode["data"]["account_number"];
         $response["reference"] = $api_decode["ref_id"];
         return $response;
         exit();
       }
       curl_close($ch);
  }
    
  
  
public static function make_transfer($conn, $amount, $bankCode, $accountNumber, $narration, $nameEnquiry) {
    $response = array();
    
    // Fetch the API details
    $api_call = self::getServiceApi($conn, "BANK_TRANSFER");
    if ($api_call["status"] === false) {
        $response["status"] = false;
        $response["msg"] = $api_call["msg"];
        return $response;
    }
     
    $pb_key = $api_call["public_key"];
    
    // Ensure that the narration and name enquiry reference are properly URL-encoded
    $encoded_narration = urlencode($narration);
    $encoded_nameEnquiry = urlencode($nameEnquiry);
    
    // Construct the API URL with encoded parameters
    $url = $api_call["url"] . "?public_key=" . $pb_key . "&amount=" . $amount . "&bank_code=" . $bankCode . "&account_number=" . $accountNumber . "&narration=" . $encoded_narration . "&name_enquiry_reference=" . $encoded_nameEnquiry;
     
    $ch = curl_init();
    curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_HTTPHEADER => array(
            "accept: application/json",
            "Content-Type: application/json",
        ),
    ));
    
    $api_resp = curl_exec($ch);
    $api_decode = json_decode($api_resp, true);
    $err = curl_error($ch);
    
    curl_close($ch);
    
    // Handle cURL error
    if ($err) {
        $response["status"] = false;
        $response["msg"] = "Server or Network Error: " . $err;
        return $response;
    }
    
    // Handle missing or unsuccessful response from API
    if (!isset($api_decode["success"])) {
        $response["status"] = false;
        $response["msg"] = "Something went wrong. Please try again later: " . $api_resp;
        return $response;
    }
    
    if ($api_decode["success"] !== true) {
        $response["status"] = false;
        $response["msg"] = "Unable to make transfer. Please try again: " . $api_resp;
        return $response;
    } else {
        $response["status"] = true;
        $response["msg"] = "Transfer successful";
        return $response;
    }
}




public static function make_user_transfer($conn, $amount, $user_id) {
    $response = array();
    
    $creditUser = Control::updateBalance($conn, $user_id, "credit", $amount);
    if($creditUser["status"] !== true){
        $response["status"] = false;
        $response["msg"] = "Unable to make transfer";
        return $response;
        exit();
    }else{
        $response["status"] = true;
        $response["msg"] = "Transfer successful";
        return $response;
    }
}



public static function create_card($conn, $fname, $lname, $email, $amount) {
    $response = array();
    
    // Fetch the API details
    $api_call = self::getServiceApi($conn, "STROWALLET_VIRTUAL_CARD");
    if ($api_call["status"] === false) {
        $response["status"] = false;
        $response["msg"] = $api_call["msg"];
        return $response;
    }
     
    $pb_key = $api_call["public_key"];
    
    $url = $api_call["url"];
    
    $data = array(
      "name_on_card" => $fname.''.$lname,
      "card_type" => "visa",
      "public_key" => $pb_key,
      "amount" => $amount,
      "customerEmail" => $email,
      "mode" => ""
    );
     
    $ch = curl_init();
    curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
            "accept: application/json",
            "Content-Type: application/json",
        ),
    ));
    
    $api_resp = curl_exec($ch);
    $api_decode = json_decode($api_resp, true);
    $err = curl_error($ch);
    
    curl_close($ch);
    
    // Handle cURL error
    if ($err) {
        $response["status"] = false;
        $response["msg"] = "Server or Network Error: " . $err;
        return $response;
    }
    
    // Handle missing or unsuccessful response from API
    if (!isset($api_decode["success"])) {
        $response["status"] = false;
        $response["msg"] = "Something went wrong. Please try again later".$api_resp;
        return $response;
    }
    
    if ($api_decode["success"] !== true) {
        $response["status"] = false;
        $response["msg"] = "Unable to create card. Please try again";
        return $response;
    } else {
        $response["status"] = true;
        $response["msg"] = "USD card creation successful";
        $response["card_name"] = $api_decode["response"]["name_on_card"];
        $response["reference"] = $api_decode["response"]["card_id"];
        $response["card_brand"] = $api_decode["response"]["name_on_card"];
        $response["card_status"] = $api_decode["response"]["card_status"];
        $response["others"] = $api_decode["response"];
        return $response;
    }
}



public static function verify_bvn($conn, $bvn, $firstname, $lastname, $dob, $phone) {
    $response = array();
    
    // Fetch the API details
    $api_call = self::getServiceApi($conn, "STROWALLET_VERIFY_BVN");
    if ($api_call["status"] === false) {
        $response["status"] = false;
        $response["msg"] = $api_call["msg"];
        return $response;
        exit();
    }
     
    $pb_key = $api_call["public_key"];
    
    // Ensure that the narration and name enquiry reference are properly URL-encoded
    
    // Construct the API URL with encoded parameters
    $url = $api_call["url"] . "?public_key=" . $pb_key . "&number=" . $bvn . "&firstName=" . $firstname . "&lastName=" . $lastname . "&dateOfBirth=" . $dob . "&phoneNumber=" . $phone;
     
    $ch = curl_init();
    curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_HTTPHEADER => array(
            "accept: application/json",
            "Content-Type: application/json",
        ),
    ));
    
    $api_resp = curl_exec($ch);
    $api_decode = json_decode($api_resp, true);
    $err = curl_error($ch);
    
    curl_close($ch);
    
    // Handle cURL error
    if ($err) {
        $response["status"] = false;
        $response["msg"] = "Server or Network Error: " . $err;
        return $response;
    }
    
    // Handle missing or unsuccessful response from API
    if (!isset($api_decode["status"])) {
        $response["status"] = false;
        $response["msg"] = "Something went wrong. Please try again later: " . $api_resp;
        return $response;
    }
    
    if ($api_decode["status"] !== true) {
        $response["status"] = false;
        $response["msg"] = "Unable to verify BVN. Please try again: " . $api_resp;
        return $response;
    } else {
        $response["status"] = true;
        $response["msg"] = "BVN verification successful";
        return $response;
    }
}



  
  
  public static function verify_bank_name($conn, $bankCode, $accountNumber){
    $response = array();
    
     $api_call = self::getServiceApi($conn, "BANK_TRANSFER_VERIFY");
     if($api_call["status"] === false){
       $response["status"] = false;
       $response["msg"] = $api_call["msg"];
       return $response;
       exit();
     }
     
     
     $pb_key = $api_call["public_key"];
     $url = $api_call["url"]."?public_key=".$pb_key."&bank_code=".$bankCode."&account_number=".$accountNumber;
      
      
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
          "accept: application/json",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["success"])){
         $response["status"] = false;
         $response["msg"] = "Something went wrong try again later".$api_resp;
         return $response;
         exit();
       }
       
       if($api_decode["success"] !== true){
         $response["status"] = false;
         $response["msg"] = "Unable to verify account";
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Account name got successfully";
         $response["account_name"] = $api_decode["data"]["account_name"];
         $response["session_id"] = $api_decode["data"]["sessionId"]; 
         return $response;
         exit();
       }
       curl_close($ch);
  }
  
  
  
  
  public static function generate_payvessel($conn, $bank_code, $type, $name, $email, $phone){
    $response = array();
    
     $api_call = self::getServiceApi($conn, "PAYVESSEL_GENERATE");
     if($api_call["status"] == false){
       $response["status"] = false;
       $response["msg"] = $api_call["msg"];
       return $response;
       exit();
     }
     
     $api_key = $api_call["public_key"];
     $srt_key = $api_call["secret_key"];
     $bs_id = $api_call["contract_code"];
     $url = $api_call["url"];
      
    $data = [
      "email" => $email,
      "name" => $name,
      "phoneNumber" => $phone,
      "bankcode" => ["120001"],
      "account_type" => "STATIC",
      "businessid" => $bs_id,
      "bvn" => "",
      ];
      
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 0,
        CURLOPT_CUSTOMREQUEST => "POST", 
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
          "api-key: ".$api_key."",
          "api-secret: Bearer ".$srt_key."",
          "Content-Type: application/json",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Something went wrong try again later".$api_resp;
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== true){
         $response["status"] = false;
         $response["msg"] = "Unable to generate account try again later".$api_resp;
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Account generated successfully";
         $response["bank_name"] = $api_decode["banks"][0]["bankName"];
         $response["account_name"] = $api_decode["banks"][0]["accountName"];
         $response["account_no"] = $api_decode["banks"][0]["accountNumber"];
         $response["reference"] = $api_decode["banks"][0]["trackingReference"];
         return $response;
         exit();
       }
       curl_close($ch);
  }
  
  
  
  public static function create_card_two($conn, $fname, $lname, $email, $cur, $address, $city, $state, $postal_code, $country, $dob, $phone, $gender, $amt){
      $response = array();
      
     $api_call = self::getServiceApi($conn, "FLUTTERWAVE_CREATE_CARD");
     if($api_call["status"] == false){
       $response["status"] = false;
       $response["msg"] = $api_call["msg"].$api_call["url"];
       return $response;
       exit();
     }
     
     $api_key = $api_call["secret_key"];
      
      $data = array(
        "currency" => $cur,
        "amount" => $amt,
        "debit_currency" => "NGN",
        "billing_name" => $fname.' '.$lname,
        "billing_address" => $address,
        "billing_city" => $city,
        "billing_state" => $state,
        "billing_postal_code" => $postal_code,
        "billing_country" => $country,
        "first_name" => $fname,
        "last_name" => $lname,
        "date_of_birth" => $dob,
        "email" => $email,
        "phone" => $phone,
        "title" => ($gender === "Male" ? "MR" : "MRS"),
        "gender" => ($gender === "Male" ? "M" : "F"),
        "callback_url" => "https://".$_SERVER["HTTP_HOST"]."/app/webhook/flw-card.php"
      );
      
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $api_call["url"],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 0,
        CURLOPT_CUSTOMREQUEST => "POST", 
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
          "Content-Type: application/json",
          "mobileization: Bearer $api_key",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Something went wrong try again later".$api_resp;
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
         $response["status"] = false;
         $response["msg"] = "Unable to create card try again later".$api_resp;
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Card created successfully";
         $response["card_name"] = $api_decode["data"]["name_on_card"];
         $response["card_brand"] = $api_decode["data"]["card_type"];
         $response["card_number"] = $api_decode["data"]["card_pan"];
         $response["card_cvv"] = $api_decode["data"]["cvv"];
         $response["card_expire"] = $api_decode["data"]["expiration"];
         $response["card_status"] = $api_decode["data"]["is_true"];
         $response["reference"] = $api_decode["data"]["id"];
         return $response;
         exit();
       }
       curl_close($ch);
  }
  
  
  
  
    public static function fund_card($conn, $cId, $amt){
      $response = array();
      
     $api_call = self::getServiceApi($conn, "FLUTTERWAVE_FUND_CARD");
     if($api_call["status"] == false){
       $response["status"] = false;
       $response["msg"] = $api_call["msg"];
       return $response;
       exit();
     }
     
     $api_key = $api_call["secret_key"];
      
      $data = array(
        "amount" => $amt,
        "debit_currency" => "NGN",
      );
      
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $api_call["url"].$cId.'/fund',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 0,
        CURLOPT_CUSTOMREQUEST => "POST", 
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
          "Content-Type: application/json",
          "mobileization: Bearer $api_key",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       $err = curl_error($ch);
       
       if($err){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Something went wrong try again later".$api_resp;
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
         $response["status"] = false;
         $response["msg"] = "Unable to fund card try again later".$api_resp;
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Card funded successful";
         return $response;
         exit();
       }
       curl_close($ch);
  }
  
  
  
  
    public static function verify_betting($conn, $provider, $betting_no){
    $response = array();
    
    $data = array(
      "betsite_id" => $provider,
      "provider" => $provider,
      "bettingnumber" => $betting_no,
      "betting_number" => $betting_no,
      );
      
     $api_call = self::getServiceApi($conn, "BETTING_VERIFY");
     if($api_call["status"] !== true){
      $response["status"] = false;
      $response["msg"] = $api_call["msg"];
      return $response;
      exit();
    }

     $pb_key = $api_call["public_key"];
     $api_key = $api_call["secret_key"];
     $url = $api_call["url"]."?betsite_id=".$provider."&betting_number=".$betting_no;
     
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "GET", 
        CURLOPT_HTTPHEADER => array(
          "Accept: application/json",
          "Content-Type: application/json",
          "trnx_pin: ".$pb_key."",
          "mobileization: ".$api_key."",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       
       if(curl_error($ch)){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Unable to perform request at this moment!!";
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
         $response["status"] = false;
         $response["msg"] = "Unable to perform request at this moment".$api_resp;
         return $response;
         exit();
       }
       $name = (isset($api_decode["name"]) ? $api_decode["name"] : $api_decode["data"]["customer_name"]);
       if($api_decode["status"] == "success" && strstr($name, "INVALID")){
         $response["status"] = false;
         $response["msg"] = "Invalid meter number no name found";
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Success name fetched successfully";
         $response["name"] = trim(str_replace("&amp;sq;", "'", $name));
         return $response;
         exit();
       }
       curl_close($ch);
  }
  
    public static function fundBetting($conn, $provider, $betting_no, $amount, $transactionId){
    $response = array();
    
    $data = array(
      "betsite_id" => $provider,
      "provider" => $provider,
      "bettingnumber" => $betting_no,
      "betting_number" => $betting_no,
      "amount" => $amount,
      "bypass" => true,
      "reference" => $transactionId,
      );
      
     $api_call = self::getServiceApi($conn, "BETTING");
     if($api_call["status"] !== true){
      $response["status"] = false;
      $response["msg"] = $api_call["msg"];
      return $response;
      exit();
    }

     $pb_key = $api_call["public_key"];
     $api_key = $api_call["secret_key"];
     $url = $api_call["url"];
     
     $ch = curl_init();
     curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "POST", 
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
          "Accept: application/json",
          "Content-Type: application/json",
          "trnx_pin: ".$pb_key."",
          "mobileization: ".$api_key."",
          ),
       ));
       $api_resp = curl_exec($ch);
       $api_decode = json_decode($api_resp, true);
       
       if(curl_error($ch)){
         $response["status"] = false;
         $response["msg"] = "Server or Network Error";
         return $response;
         exit();
       }
       
       if(!isset($api_decode["status"])){
         $response["status"] = false;
         $response["msg"] = "Unable to perform request at this moment!!";
         return $response;
         exit();
       }
       
       if($api_decode["status"] !== "success"){
         $response["status"] = false;
         $response["msg"] = "Unable to perform request at this moment??".$api_resp;
         return $response;
         exit();
       }else{
         $response["status"] = true;
         $response["msg"] = "Success, Your bet fund was successful";
         return $response;
         exit();
       }
       curl_close($ch);
  }
  
  

public static function buyBulkSms($conn, $sender, $phoneNumbers, $msg) {
    $response = array();
    $api_call = Api::getServiceApi($conn, "BULK_SMS");
    
    if ($api_call["status"] !== true) {
        $response["status"] = false;
        $response["msg"] = $api_call["msg"];
        return $response;
        exit();
    }
    
    $pb_key = $api_call["public_key"];
    $api_key = $api_call["secret_key"];
    $url = $api_call["url"];
    
    $data = array(
        "app" => $sender,
        "phone" => $phoneNumbers,
        "message" => $msg,
    );
    
    $ch = curl_init();
    curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => array(
            "Accept: application/json",
            "Content-Type: application/json",
            "APIKEY: " . $api_key . "",
        ),
    ));
    
    $api_resp = curl_exec($ch);
    $api_decode = json_decode($api_resp, true);
    $err = curl_error($ch);
    
    if ($err) {
        $response["status"] = false;
        $response["msg"] = "Server or Network Error";
        return $response;
        exit();
    }
    
    if ($api_decode["status"] !== true) {
        $message = (isset($api_decode["msg"]) ? $api_decode["msg"] : $api_decode["message"]);
        $response["status"] = false;
        $response["msg"] = $message;
        return $response;
        exit();
    } else {
        $response["status"] = true;
        $response["msg"] = "Bulk sms sent succesfully";
        return $response;
        exit();
    }
}
  
  
  
}
?>