<?php
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "api_call.php";
 require "mail.php";
 
 date_default_timezone_set("Africa/Lagos");
 if($_SERVER["REQUEST_METHOD"] === "POST"){
   $user_id = $_SESSION["user_id"];
   $user = Control::fetchDetail($conn, $user_id);
   
   if($user["status"] !== "VERIFIED"){
       echo "Your account is ".$user["status"]." you cant perform any action please contact customer care";
       unset($_SESSION["user_id"]);
       exit();
   }
  
   
   $networkId = validate::validateInt($conn, $_POST["network"]);
   $phone = validate::validateInt($conn, $_POST["phone"]);
   $amount = validate::validateInt($conn, $_POST["amount"]);
   $network_txt = validate::validateString($conn, $_POST["network-name"]);
   
   $fetchDiscount = Control::fetchDiscount($conn, "Airtime");
   $percent = $fetchDiscount["discount"];
   $discount = Control::calculateDiscount($percent, $amount);
   
   
   $pin_1 = validate::validateInt($conn, $_POST["pin-1"]);
   $pin_2 = validate::validateInt($conn, $_POST["pin-2"]);
   $pin_3 = validate::validateInt($conn, $_POST["pin-3"]);
   $pin_4 = validate::validateInt($conn, $_POST["pin-4"]);
   
   $pin_join = $pin_1.$pin_2.$pin_3.$pin_4;
   
   if(empty($networkId) || empty($phone) || empty($amount)){
     echo "Err! All fields are required";
     exit();
   }
   
   $checkPin = Control::checkPin($conn, $user_id, $pin_join);
   if($checkPin["status"] == false){
     echo $checkPin["msg"];
     exit();
   }
   $checkSql = $conn->prepare("SELECT * FROM contacts WHERE phone = ?");
$checkSql->bind_param("s", $phone);
$checkSql->execute();
$result = $checkSql->get_result();

if ($result->num_rows > 0) {

    
} else {
    $sql = $conn->prepare("INSERT INTO contacts (phone, unique_id) VALUES (?, ?)");
    $sql->bind_param("ss", $phone, $user_id);
    if ($sql->execute()) {
        
    } else {
    }
}
    
   $checkBalance = Control::checkBalance($conn, $user_id, $amount);
   if($checkBalance["status"] == false){
     echo $checkBalance["msg"];
     exit();
   }
   

   
   $generateId = Control::generateId("CD", 20);
   
   $buyAirtime = Api::buyAirtime($conn, $networkId, $phone, $amount, $generateId);
   if($buyAirtime["status"] == false){
     echo $buyAirtime["msg"];
     $description = "Airtime purchase of ".number_format($amount)." for ".$phone." Failed";
   
   $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Airtime", $phone, $network_txt, "failed", $user["bal"], $user["bal"], $discount, "", $description, date("D d-M-Y h:i a"));
   
   
   echo '
    <div class="finish">
      <div class="finish-box">
       <div class="finish-box-head">
         <img src="images/eror.png" alt="success image">
         <h2>Failed, Your airtime to "'.$phone.'" failed</h2>
       </div>
       <table>
         <tr>
           <td>Network</td>
           <td>'.$network_txt.'</td>
         </tr>
         <tr>
           <td>Phone Number</td>
           <td>'.$phone.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($amount, 2).'</td>
         </tr>
       </table>
       <div class="buttons">
         <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
         <button class="bg" onclick="window.location.reload()">TRY AGAIN</button>
       </div>
      </div>
    </div>
   ';
     exit();
   }
   
   $updateBalance = Control::updateBalance($conn, $user_id, "debit", $discount);
   if($updateBalance["status"] == false){
     echo "Err! Please contact customer support";
   }
   
   $description = "Airtime purchase of ".number_format($amount)." for ".$phone." at discount of ".$percent."(".$discount.")";
   
   $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Airtime", $phone, $network_txt, "success", $user["bal"], $user["bal"] - $amount, $discount, "", $description, date("D d-M-Y h:i a"));
   if($insertTransaction["status"] == false){
     echo $insertTransaction["msg"];
     exit();
   }
   
    $sender = "Teller";
    $bal = $user["bal"] - $amount;
    $phoneNumbers = $user["phone"];
    $amt = number_format($amount,2);
    $msg = "A debit transaction occured on your buypoint account if you noticed any unmobileized access kindly change your trx PIN\n";
    $msg .= "Phone: $phone";
    $msg .= "Amount: $phone";
    $msg .= "network: $network_txt";
    $msg .="Bal: $bal";
    

    $response = Api::buyBulkSms($conn, $sender, $phoneNumbers, $msg);
   if ($response["status"] === false) {
        error_log("Cannot send sms: " . $response);
        echo json_encode(["status" => false, "message" => "cannot send"]);
        http_response_code(400);
        exit();
    }
    
   echo '
    <div class="finish">
      <div class="finish-box">
       <div class="finish-box-head">
         <img src="images/welcome.png" alt="success image">
         <h2>Success, Your airtime is on its way to "'.$phone.'"</h2>
       </div>
       <table>
         <tr>
           <td>Network</td>
           <td>'.$network_txt.'</td>
         </tr>
         <tr>
           <td>Phone Number</td>
           <td>'.$phone.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($amount, 2).'</td>
         </tr>
       </table>
       <div class="buttons">
         <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
         <button class="bg" onclick="window.location.reload()">BUY AGAIN</button>
       </div>
      </div>
    </div>
   ';
  
   
$site = Control::site($conn);

$msg = '
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>Document</title>
  <link href="https://fonts.googleapis.com/css2?family=Mitr:wght@300;400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    *{
      box-sizing: border-box;
      font-family: "Mitr", Sans-Serif;
    }
    .head{
      background: linear-gradient(to left,#ff8000,#0000ff);
      height: 120px;
      color: #fff;
      display: grid;
      grid-template-column: repeat(1, 1fr);
      flex-direction: column;
      padding: 10px;
    }
    .head img{
      width: auto;
      height: 70px;
      object-fit:cover;
      display: block;
    }
    .head b{
      font-size: 22px;
      font-weight: 900;
      display: block;
      margin-top: 0px;
    }
    .bottom{
      background:linear-gradient(to left,#ff8000,#0000ff);
      height: 50px;
      color: #fff;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .bottom i{
      margin-left: 10px;
      margin-right: 10px;
      font-size: 18px;
    }
    .body{
      padding: 15px;
      background: #0002;
    }
    .scam-alert{
      font-size: 12px;
      color: #555;
    }
    .greet{
      font-size: 16px;
      font-weight: 900;
      color: #000;
      margin-bottom: 20px;
      display: block;
    }
    table{
      margin: 0;
      margin-top: 15px;
      margin-bottom: 15px;
    }
    table tr{
      height: 25px;
      width: 100%;
      padding: 5px;
    }
    table tr td:nth-child(1){
      font-weight: 500;
      font-size: 13px;
      color: #000;
      width: 90px;
    }
    table tr td:nth-child(2){
      font-weight: 500;
      font-size: 13px;
      color: #777;
    }
  </style>
</head>
<body>
  <div class="head">
    <img src="https://'.$_SERVER["HTTP_HOST"].'/app/logos/logo.png" alt="logo">
    <b>NGN '.number_format($amount, 2).'</b>
  </div>
  <div class="body">
    <b class="greet">Hello, '.$user["fname"].' You just bought NGN '.number_format($amount, 2).' of Airtime </b>
    
    <table>
      <tr>
        <td>Type</td>
        <td>Airtime</td>
      </tr>
      <tr>
        <td>Amount</td>
        <td>NGN'.$amount.'</td>
      </tr>
      <tr>
        <td>Network</td>
        <td>'.$network_txt.'</td>
      </tr>
      <tr>
        <td>Phone</td>
        <td>'.$phone.'</td>
      </tr>
      <tr>
        <td>Reference</td>
        <td>'.$generateId.'</td>
      </tr>
      <tr>
        <td>Date</td>
        <td>'.date("D d-M-Y h:i a").'</td>
      </tr>
    </table>
    
    <div class="scam-alert">If this wasnt done by you <a href="https://'.$_SERVER["HTTP_HOST"].'/app/login.php">Login</a> to reset your password and also contact support for help at <a href="'.$site["support_email"].'">'.$site["support_email"].'</a>. Thank you for using '.$site["site_name"].'</div>
  </div>
  <div class="bottom">
    <i class="fab fa-facebook"></i>
    <i class="fab fa-whatsapp"></i>
    <i class="fab fa-instagram"></i>
  </div>
</body>
</html>
';

 sendOtpMail($conn, $user["unique_id"], $user["email"], "Transaction Alert", $msg, "Email notification send successfully");
 }
?>