<?php
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "api_call.php";
 date_default_timezone_set("Africa/Lagos");
 
 if($_SERVER["REQUEST_METHOD"] !== "POST"){
     echo "Invalid server request method";
     exit();
 }
 
   $user_id = $_SESSION["user_id"];
   $user = Control::fetchDetail($conn, $user_id);
   if($user["status"] !== "VERIFIED"){
       echo "Your account is ".$user["status"]." you cant perform any action please contact customer care";
       unset($_SESSION["user_id"]);
       exit();
   }
  
   
   $networkId = validate::validateInt($conn, $_POST["network"]);
   $quantity = validate::validateInt($conn, $_POST["quantity"]);
   $amount = validate::validateInt($conn, $_POST["amount"]) * $quantity;
   $cardname = validate::validateString($conn, $_POST["nameoncard"]);
   $network_txt = validate::validateString($conn, $_POST["network-name"]);
   
   $percent = "1.5%";
   $discount = Control::calculateDiscount($percent, $amount);
   
   $pin_1 = validate::validateInt($conn, $_POST["pin-1"]);
   $pin_2 = validate::validateInt($conn, $_POST["pin-2"]);
   $pin_3 = validate::validateInt($conn, $_POST["pin-3"]);
   $pin_4 = validate::validateInt($conn, $_POST["pin-4"]);
   
   $pin_join = $pin_1.$pin_2.$pin_3.$pin_4;
   
   $checkPin = Control::checkPin($conn, $user_id, $pin_join);
   if($checkPin["status"] == false){
     echo $checkPin["msg"];
     exit();
   }
   
   $checkBalance = Control::checkBalance($conn, $user_id, $amount);
   if($checkBalance["status"] == false){
     echo $checkBalance["msg"];
     exit();
   }
   
   $generateId = Control::generateId("CD", 20);
   
   $buyAirtimePin = Api::buyAirtimePin($conn, $networkId, $amount / $quantity, $quantity, $cardname, $generateId);
   if($buyAirtimePin["status"] == false){
     echo $buyAirtimePin["msg"].$amount;
     exit();
   }
   
   $updateBalance = Control::updateBalance($conn, $user_id, "debit", $amount);
   if($updateBalance["status"] == false){
     echo "Err! Please contact customer support";
   }
   
   $description = "Airtime pin purchase of ".$network_txt." ".$quantity." quantity at amount of ".number_format($amount)." for ".$cardname;
   
   $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Airtime Pin", $network_txt, $buyAirtimePin["load_pin"]."||".$buyAirtimePin["serial_no"], "success", $user["bal"], $user["bal"] - $amount, $amount, $buyAirtimePin["pin"], $description, date("D d-M-Y h:i a"));
   if($insertTransaction["status"] == false){
     echo $insertTransaction["msg"];
     exit();
   }
   
   echo '
    <div class="finish">
      <div class="finish-box">
       <div class="finish-box-head">
         <img src="images/check.png" alt="success image">
         <h2>SUCCESS</h2>
       </div>
       <table>
         <tr>
           <td>Network</td>
           <td>'.$network_txt.'</td>
         </tr>
         <tr>
           <td>Name on card</td>
           <td>'.$cardname.'</td>
         </tr>
         <tr>
           <td>Quantity</td>
           <td>'.$quantity.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($amount, 2).'</td>
         </tr>
         
      <tr>
        <td>Pins</td>
        <td>View in Reciept</td>
      </tr>
      
       </table>
       <div class="buttons">
         <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
         <button class="bg" onclick="window.location.location.reload()">BUY AGAIN</button>
       </div>
      </div>
    </div>
   ';
   exit();
   
?>