<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Savings Dashboard</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 350px;
            text-align: center;
        }
        h2, h3 {
            color: #333;
        }
        .balance {
            font-size: 1.2em;
            margin-bottom: 20px;
        }
        label {
            font-weight: bold;
        }
        input, select, button {
            margin-top: 5px;
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 5px;
            width: 100%;
        }
        button {
            background-color: #28a745;
            color: white;
            border: none;
            cursor: pointer;
            margin-top: 10px;
        }
        button:hover {
            background-color: #218838;
        }
        .transactions {
            margin-top: 20px;
            text-align: left;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Savings Dashboard</h2>
        <div class="balance">
            <p>Wallet Balance: <span id="wallet-balance">$100.00</span></p>
            <p>Total Savings: <span id="savings-balance">$0.00</span></p>
        </div>
        
        <h3>Create Savings Plan</h3>
        <form id="savings-form">
            <label for="amount">Amount:</label>
            <input type="number" id="amount" required>
            
            <label for="schedule">Schedule:</label>
            <select id="schedule">
                <option value="manual">Manual</option>
                <option value="daily">Daily</option>
                <option value="weekly">Weekly</option>
                <option value="monthly">Monthly</option>
            </select>
            
            <label for="duration">Lock Duration (days):</label>
            <input type="number" id="duration" min="1" required>
            
            <button type="submit">Save</button>
        </form>
        
        <h3>Withdraw Funds</h3>
        <form id="withdrawal-form">
            <label for="withdraw-amount">Amount:</label>
            <input type="number" id="withdraw-amount" required>
            
            <button type="submit">Withdraw</button>
        </form>
        
        <div class="transactions">
            <h3>Transaction History</h3>
            <ul id="transaction-list"></ul>
        </div>
    </div>
    
    <script>
        let walletBalance = 100.00;
        let savingsBalance = 0.00;
        let savingsData = [];
        
        document.getElementById('savings-form').addEventListener('submit', function(event) {
            event.preventDefault();
            const amount = parseFloat(document.getElementById('amount').value);
            const duration = parseInt(document.getElementById('duration').value);
            const unlockDate = new Date();
            unlockDate.setDate(unlockDate.getDate() + duration);
            
            if (amount > walletBalance) {
                alert('Insufficient funds!');
                return;
            }
            
            walletBalance -= amount;
            savingsBalance += amount;
            savingsData.push({ amount, unlockDate });
            
            document.getElementById('wallet-balance').textContent = `$${walletBalance.toFixed(2)}`;
            document.getElementById('savings-balance').textContent = `$${savingsBalance.toFixed(2)}`;
            document.getElementById('transaction-list').innerHTML += `<li>Saved: $${amount} (Unlock on: ${unlockDate.toDateString()})</li>`;
        });
        
        document.getElementById('withdrawal-form').addEventListener('submit', function(event) {
            event.preventDefault();
            const amount = parseFloat(document.getElementById('withdraw-amount').value);
            const currentDate = new Date();
            
            if (amount > savingsBalance) {
                alert('Insufficient savings!');
                return;
            }
            
            const lockedFunds = savingsData.find(saving => saving.amount >= amount && saving.unlockDate > currentDate);
            if (lockedFunds) {
                alert(`Funds are locked until ${lockedFunds.unlockDate.toDateString()}`);
                return;
            }
            
            savingsBalance -= amount;
            walletBalance += amount;
            document.getElementById('wallet-balance').textContent = `$${walletBalance.toFixed(2)}`;
            document.getElementById('savings-balance').textContent = `$${savingsBalance.toFixed(2)}`;
            document.getElementById('transaction-list').innerHTML += `<li>Withdrawn: $${amount}</li>`;
        });
    </script>
</body>
</html>
