<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Airtime");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Account Settings</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    <?php include "css/animation.css"; ?>
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Account Settings</span>
    <a href="logout.php" style="text-decoration: none; color: #333"><i class="fas fa-sign-out"></i></a>
  </div>
  
  <div class="setting-box">
    
    <h2 class="h2">Account</h2>
    
    <a href="referral.php"><div class="setting" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-group-line"></i>
      <span>Referrals</span>
      <i class="fas fa-chevron-right"></i>
    </div></a>
    
    <a href="profile.php"><div class="setting" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-user-line"></i>
      <span>Profile</span>
      <i class="fas fa-chevron-right"></i>
    </div></a>
    
    <a href="account-verification.php"><div class="setting" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-check-line"></i>
      <span>Account Verification</span>
      <i class="fas fa-chevron-right"></i>
    </div></a>
    
    <div class="setting" onclick="showForm('c-statement', 'open', 'flex', '')" onmousemove="createRipple(event, true, 'black')" hidden>
      <i class="ri-bank-line"></i>
      <span>Account Statement</span>
      <i class="fas fa-chevron-right"></i>
    </div>
    
    <div class="setting" onclick="showForm('c-password', 'open', 'flex', '')" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-key-line"></i>
      <span>Change Password</span>
      <i class="fas fa-chevron-right"></i>
    </div>
    
    <div class="setting" onclick="showForm('c-pin', 'open', 'flex', '')" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-lock-line"></i>
      <span>Change Transaction PIN</span>
      <i class="fas fa-chevron-right"></i>
    </div>
    
    <div class="setting" onclick="showFormT('r-c-pin', 'open', 'flex', '')" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-lock-line"></i>
      <span>Reset Transaction PIN</span>
      <i class="fas fa-chevron-right"></i>
    </div>
    
    <div class="setting" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-sun-line"></i>
      <span>Toggle Mode</span>
      <div class="toggle">
        <span class="span <?php echo ($user["mode"] == "On" ? "active" : ""); ?>" id="mode-t" onclick="toggleMode('mode-t')"></span>
        <b class="b" onclick="toggleMode('mode-t')"></b>
      </div>
    </div>
    
    <div class="setting" onmousemove="createRipple(event, true, 'black')" hidden="true">
      <i class="ri-shield-line"></i>
      <span>Two Factor Authentication</span>
      <div class="toggle">
        <span class="span"></span>
        <b class="b"></b>
      </div>
    </div>
    
  </div>
  
  <?php include "includes/account-statement.php"; ?>
  <?php include "includes/change-password.php"; ?>
  <?php include "includes/change-pin.php"; ?>
  <?php include "includes/reset-pin.php"; ?>
  
  
  <script>
    <?php include "js/msg.js"; ?>
   function toggleMode(clickId){
     const click_id_gt = document.getElementById(clickId);
       fetch("server/update-mode.php")
       .then(response => response.text())
       .then(data => {
         if(data.includes("successfully")){
           click_id_gt.classList.toggle("active");
           document.body.classList.toggle("active");
         }
       });
   }
   <?php include "js/other.js"; ?>
  </script>
  </body>
</html>