<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Airtime");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Referrals</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    <?php include "css/animation.css"; ?>
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Referrals</span>
    <a href="logout.php" style="text-decoration: none; color: #333"><i class="fas fa-sign-out"></i></a>
  </div>
   <?php
    $countR = Control::countReferral($conn, $user_id);
   ?>
   <div class="ref-bx">
     <h2 class="tp">Your referral code</h2>
     <div class="code-copy">
       <span><?php echo $user["unique_id"]; ?></span>
       <i class="bi bi-copy" onclick="copyTxt('<?php echo $user["unique_id"]; ?>')"></i>
     </div>
     <button class="s-btn">SHARE REFERRAL LINK</button>
     <div class="earned-points">
       <span>Earned Points</span>
       <b>&#x20a6;<?php echo number_format($countR["total_amount"], 2); ?></b>
     </div>
   </div>
   <div class="ref-list">
     <span>Referral List</span>
     <b>Total Referrals: <?php echo $countR["total_ref"]; ?></b>
   </div>
   <?php
    
    $sql = "SELECT * FROM referral WHERE unique_id = ? ORDER BY id DESC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $query = $stmt->get_result();
    $all = array();
    if($query->num_rows > 0){
      while($row = $query->fetch_assoc()){
        $all[] = $row;
      }
    }else{
      $all = "No referral yet";
    }
    
    $all_t = 0;
    foreach ($all as $a){
     $all_t++;
     $fetchU = Control::fetchDetail($conn, $a["user_id"]);
     echo '
      <div class="each-user">
         <h4>'.$all_t.'.</h4>
         <div class="e-left">
           <b>'.strtoupper($fetchU["fname"]).'</b>
           <span>Joined: '.$a["date"].'</span>
         </div>
         <div class="e-right">
           <b class="clr">Active</b>
           <span>&#x20a6;'.$a["bonus"].'</span>
         </div>
      </div>
    ';
   } 
  ?>
     </table>
  <script>
    <?php include "js/msg.js"; ?>
  </script>
</body>
</html>