<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
if(!isset($_GET["user_id"]) && !isset($_SESSION["user_id"])){
  header("Location: login.php");
  exit();
}

$user_id = (isset($_GET["user_id"]) ? $_GET["user_id"] : $_SESSION["user_id"]);
$user = Control::fetchDetail($conn, $user_id);
$site = Control::site($conn);

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Transaction Receipt</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
      --poppins: "Poppins", Sans-serif;
      --mitr: "Mitr", Sans-serif;
    }
      body{
        display: flex;
        align-items: start;
        justify-content: center;
        font-family: var(--mitr);
      }
      span, h1, h2, h3, h4, h5, h6, div, button, table, p, b, i, section, form, em, input, textarea{
        font-family: var(--mitr);
      }
       .box-v{
         padding: 0px;
         background: hsl(0, 0%, 100%,  0.9);
         box-sizing: border-box;
         text-align: center;
         font-family: "Poppins", Sans-serif;
         margin-top: 1px;
         width: 325px;
       }
       .b-h{
         margin-bottom: 15px;
         display: flex;
         align-items: center;
         justify-content: center;
         flex-direction: column;
       }
       .b-h img{
         width: 100px;
         height: 45px;
       }
       .b-h h2{
         margin: 0;
         font-weight: 900;
         font-size: 15px;
         margin-top: 2px;
       }
       table{
         width: 100%;
         box-sizing: border-box;
         word-break: break-word;
       }
       table tr{
         font-size: 9px;
         text-align: left;
         height: 43px;
         box-sizing: border-box;
         width: 100%;
         box-shadow: 0px 2px 0px 0px  #0001;
         padding: 10px;
       }
       table tr td:nth-child(1){
         width: 75px;
         font-weight: 900;
         font-size: 11px;
         color: var(--site-clr);
         padding-right: 5px;
       }
       table tr td:nth-child(2) i{
         position: absolute;
         top: 7.5px;
         right: 8px;
         font-size: 14px;
         color: rgba(0%, 60%, 0%);
         padding: 4px;
         display: flex;
         justify-content: center;
         align-items: center;
         background: #1111;
         width: 25px;
         height: 20px;
         border-radius: 8px;
       }
       table tr td:nth-child(2){
         min-width: 80%;
         font-weight: 900;
         font-size: 11px;
         color: #000;
         position: relative;
       }
       .buttons{
         display: flex;
         align-items: center;
         justify-content: center;
         margin-top: 10px;
         position: fixed;
         bottom: 0;
         left: 0;
         right: 0;
         background: #fff;
         height: 60px;
       }
       button i{
         margin-right: 10px;
         font-size: 15px;
       }
       button{
         padding: 10px;
         border: 0.9px solid var(--site-clr);
         background: var(--site-clr);
         color: #fff;
         font-weight: 900;
         width: 150px;
         height: 45px;
         border-radius: 9px;
         font-family: var(--mitr);
         font-size: 11px;
         display: flex;
         align-items: center;
         justify-content: center;
         margin-left: 10px;
         margin-right: 10px;
       }
       button.full{
         width: 310px;
       }
       button.no{
         border: 1px solid var(--site-clr);
         background: #fff;
         font-weight: 900;
         color: var(--site-clr);
       }
       i[class="ri-checkbox-circle-line"]{
         color: rgba(0%, 70%, 0%);
         font-weight: 200;
       }
       i[class="ri-forbid-line"]{
         color: rgba(90%, 0%, 0%);
       }
       i[class="ri-close-circle-line"]{
         color: rgba(90%, 60%, 0%);
       }
       .txts a{
         text-decoration: none;
         color: var(--site-clr);
         font-weight: 900;
       }
       .txts{
         display: block;
         margin: 0;
         margin-bottom: 60px;
         margin-top: 9px;
         font-size: 10px;
         font-weight: 400;
         text-align: center;
       }
 
.alertErr,
.alertSuc{
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  z-index: 60;
  display: flex;
  align-items: center;
  justify-content: center;
  background: hsl(0, 0%, 10%, 0.4);
  transition: 0.25s;
  font-family: var(--poppins);
}
.alertErr .adiv,
.alertSuc .adiv{
  padding: 0px;
  border-radius: 16px;
  background: #fff;
  width: 290px;
  box-shadow: border-box;
  word-break: break-word;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  animation: zoomInMsg 0.2s;
  transition: 0.25s;
  overflow: hidden;
}
@keyframes zoomInMsg{
  from{
    transform: scale(0.9);
    opacity: 0.1;
  }
  to{
    transform: scale(1);
    opacity: 1;
  }
}
.alertErr .adiv i,
.alertSuc .adiv i{
  font-size: 50px;
  margin-bottom: 5px;
  margin-top: 20px;
}
.alertErr .adiv span,
.alertSuc .adiv span{
  font-size: 13px;
  font-weight: 400;
  color: #222;
  margin-top: 10px;
  margin-bottom: 18px;
  text-align: center;
  padding: 0px;
  padding-left: 13px;
  padding-right: 13px;
  font-family: var(--poppins);
}
.alertSuc .adiv i{
  color: rgba(0%, 50%, 0%);
}
.alertErr .adiv i{
  color: rgba(80%, 0%, 0%);
}
.alertErr .adiv .button,
.alertSuc .adiv .button{
  display: inline-flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  box-sizing: border-box;
  margin-bottom: 0;
  border-top: 1px solid hsl(0, 0%, 70%);
  padding-top: 0px;
}
.alertErr .adiv .button button,
.alertSuc .adiv .button button{
  padding: 10px;
  color: #fff;
  line-height: 0;
  display: flex;
  align-items: center;
  justify-content: center;
  outline: none;
  border-radius: 0px;
  height: 45px;
  width: 50%;
  font-size: 12px;
  font-family: var(--poppins);
  background: #fff;
  color: #666;
  border: none;
}
.alertErr .adiv .button button:hover,
.alertSuc .adiv .button button:hover,
.alertErr .adiv .button button:active,
.alertSuc .adiv .button button:active{
  background: hsl(0, 0%, 90%);
}
.alertSuc .adiv .button #cancelBtn,
.alertErr .adiv .button #cancelBtn{
  border-right: 0.8px solid hsl(0, 0%, 70%);
}
.alertErr .adiv .button #okBtn,
.alertSuc .adiv .button #okBtn{
  border-left: 0.8px solid hsl(0, 0%, 70%);
}
.spin{
  padding: 2px;
  height: 25px;
  width: 25px;
  box-sizing: border-box;
  border: 2.7px solid #fff;
  border-top: 2.7px solid #0003;
  background: transparent;
  border-radius: 50%;
  animation: infinitySpin 0.5s linear infinite;
  display: inline-block;
}
@keyframes infinitySpin{
  0%{
    transform: rotate(0deg);
  }
  100%{
    transform: rotate(360deg);
  }
}
  </style>
</head>
<body>
  <?php
function showBox($type, $table){
     global $site;
     return '
        <div class="box-v">
          <div class="b-h">
            <img src="logos/'.$site["site_logo"].'" alt="MBILLS Logo">
            <h2>Transaction Reciept</h2>
          </div>
          '.$table.'
          <div class="txts">
            Having any issue with this transactions<br>
            Reach out to us <a href="support.php">here</a>
          </div>
          <div class="buttons">
          '.(strstr($type, "</button>") ? $type : ""). '
            <button onclick="shareR(`PDF`, `print`)" class="'.(!strstr($type, "</button>") ? "full" : "").'"><i class="fas fa-download"></i>DOWNLOAD</button>
          </div>
        </div>
     ';
   }
  if($_SERVER["REQUEST_METHOD"] !== "GET"){
    echo "Reference must be sent to view transaction details";
     exit();
  }
  
  if(!isset($_GET["ref"])){
    echo "Reference must be sent to view transaction details";
     exit();
  }
  
  $mbRef = validate::validateString($conn, $_GET["ref"]);
  $fetchT = Control::fetchTransaction($conn, $user_id, $mbRef);
  if($fetchT["status"] !== true){
    echo "No such transaction with this reference exist";
    exit();
  }
  
  $type = $fetchT["details"][0]["type"];
  if($type === "Airtime"){
    echo showBox('<button onclick="window.history.back()" class="no" ><i class="bi bi-x"></i>CLOSE</button>', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"]).'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Type</td>
        <td>'.$fetchT["details"][0]["type"].'</td>
      </tr>
      <tr>
        <td>Provider</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
      <tr>
        <td>Phone Number</td>
        <td>'.$fetchT["details"][0]["phone"].'</td>
      </tr>
      <tr>
        <td>Previous Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["old_bal"], 2).'</td>
      </tr>
      <tr>
        <td>New Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["new_bal"], 2).'</td>
      </tr>
      <tr>
        <td>Amount Charged</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Our status</td>
        <td>'.$fetchT["details"][0]["status"].'</td>
      </tr>
      <tr>
        <td>Date/Time</td>
        <td>'.$fetchT["details"][0]["date"].'</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>'.$fetchT["details"][0]["description"].'</td>
      </tr>
    </table>
    ');
  }else if($type === "Data"){
    echo showBox('<button onclick="window.history.back()" class="no" ><i class="bi bi-x"></i>CLOSE</button>', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"]).'</td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Trans Type</td>
        <td>'.$fetchT["details"][0]["type"].'</td>
      </tr>
      <tr>
        <td>Provider</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
      <tr>
        <td>Phone Number</td>
        <td>'.$fetchT["details"][0]["phone"].'</td>
      </tr>
      <tr>
        <td>Previous Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["old_bal"]).'</td>
      </tr>
      <tr>
        <td>New Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["new_bal"]).'</td>
      </tr>
      <tr>
        <td>Amount Charged</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"]).'</td>
      </tr>
      <tr>
        <td>Our status</td>
        <td>'.$fetchT["details"][0]["status"].'</td>
      </tr>
      <tr>
        <td>Date/Time</td>
        <td>'.$fetchT["details"][0]["date"].'</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>'.$fetchT["details"][0]["description"].'</td>
      </tr>
    </table>
    ');
  }else if($type === "Transfer"){
    echo showBox('<button onclick="window.history.back()" class="no" ><i class="bi bi-x"></i>CLOSE</button>', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"]).'</td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Trans Type</td>
        <td>'.$fetchT["details"][0]["type"].'</td>
      </tr>
      <tr>
        <td>Recipent Acount Number</td>
        <td>'.$fetchT["details"][0]["phone"].'</td>
      </tr>
      <tr>
        <td>Recipent Name</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
      <tr>
        <td>Previous Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["old_bal"], 2).'</td>
      </tr>
      <tr>
        <td>New Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["new_bal"], 2).'</td>
      </tr>
      <tr>
        <td>Amount Charged</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Our status</td>
        <td>'.$fetchT["details"][0]["status"].'</td>
      </tr>
      <tr>
        <td>Date/Time</td>
        <td>'.$fetchT["details"][0]["date"].'</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>'.$fetchT["details"][0]["description"].'</td>
      </tr>
    </table>
    ');
  }else if($type === "Wallet Topup"){
    echo showBox('full', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Trans Type</td>
        <td>'.$fetchT["details"][0]["type"].'</td>
      </tr>
      <tr>
        <td>Provider</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
      <tr>
        <td>Phone Number</td>
        <td>'.$fetchT["details"][0]["phone"].'</td>
      </tr>
      <tr>
        <td>Previous Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["old_bal"], 2).'</td>
      </tr>
      <tr>
        <td>New Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["new_bal"], 2).'</td>
      </tr>
      <tr>
        <td>Amount Charged</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Our status</td>
        <td>'.$fetchT["details"][0]["status"].'</td>
      </tr>
      <tr>
        <td>Date/Time</td>
        <td>'.$fetchT["details"][0]["date"].'</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>'.$fetchT["details"][0]["description"].'</td>
      </tr>
    </table>
    ');
  }else if($type === "Betting"){
    echo showBox('full', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Provider</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
      <tr>
        <td>Betting Id</td>
        <td>'.$fetchT["details"][0]["phone"].'</td>
      </tr>
      <tr>
        <td>Betting Name</td>
        <td>'.$fetchT["details"][0]["no"].'</td>
      </tr>
      <tr>
        <td>Previous Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["old_bal"], 2).'</td>
      </tr>
      <tr>
        <td>New Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["new_bal"], 2).'</td>
      </tr>
      <tr>
        <td>Amount Charged</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Our status</td>
        <td>'.$fetchT["details"][0]["status"].'</td>
      </tr>
      <tr>
        <td>Date/Time</td>
        <td>'.$fetchT["details"][0]["date"].'</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>'.$fetchT["details"][0]["description"].'</td>
      </tr>
    </table>
    ');
  }else if($type === "Airtime Pin"){
    echo showBox('full', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Provider</td>
        <td>'.$fetchT["details"][0]["phone"].'</td>
      </tr>
      <tr>
        <td>Serial and Load Pin</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
      <tr>
        <td>Pins</td>
        <td>'.$fetchT["details"][0]["no"].'</td>
      </tr>
      <tr>
        <td>Previous Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["old_bal"], 2).'</td>
      </tr>
      <tr>
        <td>New Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["new_bal"], 2).'</td>
      </tr>
      <tr>
        <td>Amount Charged</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Our status</td>
        <td>'.$fetchT["details"][0]["status"].'</td>
      </tr>
      <tr>
        <td>Date/Time</td>
        <td>'.$fetchT["details"][0]["date"].'</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>'.$fetchT["details"][0]["description"].'</td>
      </tr>
    </table>
    ');
  }else if($type === "Data Card"){
    echo showBox('full', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Provider</td>
        <td>'.$fetchT["details"][0]["phone"].'</td>
      </tr>
      <tr>
        <td>Serial and Load Pin</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
      <tr>
        <td>Pins</td>
        <td>'.$fetchT["details"][0]["no"].'</td>
      </tr>
      <tr>
        <td>Previous Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["old_bal"], 2).'</td>
      </tr>
      <tr>
        <td>New Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["new_bal"], 2).'</td>
      </tr>
      <tr>
        <td>Amount Charged</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Our status</td>
        <td>'.$fetchT["details"][0]["status"].'</td>
      </tr>
      <tr>
        <td>Date/Time</td>
        <td>'.$fetchT["details"][0]["date"].'</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>'.$fetchT["details"][0]["description"].'</td>
      </tr>
    </table>
    ');
  }else if($type === "Electricity"){
    echo showBox('full', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Provider</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
      <tr>
        <td>Units</td>
        <td>'.$fetchT["details"][0]["phone"].'</td>
      </tr>
      <tr>
        <td>Token</td>
        <td>'.trim($fetchT["details"][0]["no"], 'Token: ').' <i class="bi bi-copy" onclick="copyTxt(`'.trim($fetchT["details"][0]["no"], 'Token: ').'`)"></i></td>
      </tr>
      <tr>
        <td>Previous Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["old_bal"], 2).'</td>
      </tr>
      <tr>
        <td>New Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["new_bal"], 2).'</td>
      </tr>
      <tr>
        <td>Amount Charged</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Our status</td>
        <td>'.$fetchT["details"][0]["status"].'</td>
      </tr>
      <tr>
        <td>Date/Time</td>
        <td>'.$fetchT["details"][0]["date"].'</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>'.$fetchT["details"][0]["description"].'</td>
      </tr>
    </table>
    ');
  }else if($type === "Exam Pin"){
    echo showBox('full', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Provider</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
      <tr>
        <td>Pin and serial</td>
        <td>'.$fetchT["details"][0]["no"].'</td>
      </tr>
      <tr>
        <td>Previous Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["old_bal"], 2).'</td>
      </tr>
      <tr>
        <td>New Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["new_bal"], 2).'</td>
      </tr>
      <tr>
        <td>Amount Charged</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Our status</td>
        <td>'.$fetchT["details"][0]["status"].'</td>
      </tr>
      <tr>
        <td>Date/Time</td>
        <td>'.$fetchT["details"][0]["date"].'</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>'.$fetchT["details"][0]["description"].'</td>
      </tr>
    </table>
    ');
  }else if($type === "Bulk Sms"){
    echo showBox('full', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
      <tr>
        <td>Message</td>
        <td>'.$fetchT["details"][0]["phone"].'</td>
      </tr>
      <tr>
        <td>Phone Numbers</td>
        <td>'.$fetchT["details"][0]["no"].'</td>
      </tr>
      <tr>
        <td>Previous Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["old_bal"], 2).'</td>
      </tr>
      <tr>
        <td>New Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["new_bal"], 2).'</td>
      </tr>
      <tr>
        <td>Amount Charged</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>Our status</td>
        <td>'.$fetchT["details"][0]["status"].'</td>
      </tr>
      <tr>
        <td>Date/Time</td>
        <td>'.$fetchT["details"][0]["date"].'</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>'.$fetchT["details"][0]["description"].'</td>
      </tr>
    </table>
    ');
  }else if($type === "FUNDS LOCK PAYOUT"){
    echo showBox('full', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
      </tr>
      <tr>
        <td>acc_name</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Liquidate Time</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
     
      
      
    ');
  }else if($type === "Cable Tv"){
    echo showBox('<button onclick="window.history.back()" class="no" ><i class="bi bi-x"></i>CLOSE</button>', '
    <table>
      <tr>
        <td>Amount</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"]).'</td>
      </tr>
      <tr>
        <td>Sender</td>
        <td>'.$user["fname"].' '.$user["lname"].'</td>
      </tr>
      <tr>
        <td>Trans Ref</td>
        <td>'.$fetchT["details"][0]["reference"].' <i class="bi bi-copy" onclick="copyTxt(`'.$fetchT["details"][0]["reference"].'`)"></i></td>
      </tr>
      <tr>
        <td>Trans Type</td>
        <td>'.$fetchT["details"][0]["type"].'</td>
      </tr>
      <tr>
        <td>Provider</td>
        <td>'.$fetchT["details"][0]["network"].'</td>
      </tr>
      <tr>
        <td>Cable Number</td>
        <td>'.$fetchT["details"][0]["phone"].'</td>
      </tr>
      <tr>
        <td>Cable Name</td>
        <td>'.$fetchT["details"][0]["no"].'</td>
      </tr>
      <tr>
        <td>Previous Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["old_bal"]).'</td>
      </tr>
      <tr>
        <td>New Balance</td>
        <td>NGN '.number_format($fetchT["details"][0]["new_bal"]).'</td>
      </tr>
      <tr>
        <td>Amount Charged</td>
        <td>NGN '.number_format($fetchT["details"][0]["amount"]).'</td>
      </tr>
      <tr>
        <td>Our status</td>
        <td>'.$fetchT["details"][0]["status"].'</td>
      </tr>
      <tr>
        <td>Date/Time</td>
        <td>'.$fetchT["details"][0]["date"].'</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>'.$fetchT["details"][0]["description"].'</td>
      </tr>
    </table>
    ');
  }
  ?>
  <script src="https://raw.githack.com/eKoopmans/html2pdf/master/dist/html2pdf.bundle.js"></script>
<script>
    function shareR() {
        const element = document.body; // Use the actual DOM element

        // Generate the PDF
        html2pdf()
            .from(element)
            .set({ 
                margin: 1,
                filename: 'fluterpay_transaction_reciept.pdf',
                html2canvas: { scale: 2 },
                jsPDF: { unit: 'in', format: 'letter', orientation: 'portrait' } 
            })
            .save() // Save the PDF locally
    }
</script>
</body>
</html>