<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";

if(!isset($_SESSION["pin_verify"])){
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION["pin_verify"];
$user = Control::fetchDetail($conn, $user_id);
if($user["status"] === false){
    echo $user["msg"];
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
    <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
    <title>Pin verification || Fluterpay</title>
    <style>
        @font-face {
            font-family: 'Mitr';
            src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
            font-weight: normal;
            font-style: normal;
        }
        * {
            box-sizing: border-box;
            font-family: "Mitr", Sans-Serif;
        }
        body {
            margin: 30px;
        }
        .pin-inputs {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 20px;
            margin-bottom: 20px;
        }
        .pin-inputs input {
            padding: 10px;
            border: 2px solid #3333ff;
            background: #fff;
            height: 50px;
            width: 50px;
            border-radius: 10px;
            margin-left: 12px;
            margin-right: 12px;
            text-align: center;
            font-weight: 900;
            color: #000;
            font-size: 20px;
        }
        .up-text {
            margin-bottom: 40px;
            margin-top: 60px;
        }
        .up-text b {
            display: block;
            font-size: 17px;
            font-weight: 900;
            color: #333;
            margin-bottom: 20px;
        }
        .up-text small {
            display: block;
            font-size: 13px;
            font-weight: 400;
            color: #777;
        }
        .fingerprint-auth {
            display: flex;
            justify-content: center;
            margin: 20px 0; 
        }
        #fingerprint-button {
            padding: 10px 20px; 
            border: none;
            border-radius: 5px;
            background-color: #3333ff;
            box-shadow: 0 1px 2px 0 #0003;
            font-size: 15px;
            font-weight: 900;
            cursor: pointer;
        }
        #fingerprint-button:hover {
            background-color: #ffc000; /* Change background on hover */
        }
        .pin-btns {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            padding: 12px;
            grid-column-gap: 10px;
            grid-row-gap: 10px;
        }
        .pin-btns button {
            border: none;
            outline: none;
            height: 45px;
            border-radius: 9px;
            background: #fff;
            box-shadow: 0 1px 2px 0 #3333ff;
            font-size: 15px;
            font-weight: 900;
        }
    </style>
</head>
<body>
    <div class="up-text">
        <b>Welcome Back!! <?php echo $user["fname"]; ?></b>
        <small>Authenticate Via User Pin or Fingerprint</small>
    </div>
     
    <div class="pin-inputs">
        <input type="password" name="pin-1" id="pin-1" maxlength="1">
        <input type="password" name="pin-2" id="pin-2" maxlength="1">
        <input type="password" name="pin-3" id="pin-3" maxlength="1">
        <input type="password" name="pin-4" id="pin-4" maxlength="1" oninput="submitPin()">
    </div>

<div class="fingerprint-auth">
        <button id="fingerprint-button">
            <i class="bi bi-fingerprint"></i> <i class="ri-fingerprint-line" onclick="fingerLogin()"></i>
        </button>
    </div>
<p style=" margin-right:140px; color:blue;font-size:15px"><i class="fa fa-shield"></i> Secure Keyboard active</p>
    </div>
    <div class="pin-btns">
        <button>1</button>
        <button>2</button>
        <button>3</button>
        <button>4</button>
        <button>5</button>
        <button>6</button>
        <button>7</button>
        <button>8</button>
        <button>9</button>
       <button class="no"></button>
        <button>0</button>
        <button>X</button>
    </div>

    <script>
        <?php include "js/msg.js"; ?>
        document.addEventListener('DOMContentLoaded', function () {
            const pinInputs = document.querySelectorAll('.pin-inputs input');
            let currentInputIndex = 0;

            // Enable the PIN input fields
            pinInputs.forEach(input => {
                input.disabled = false; // Remove disabled attribute
            });

            // Function to handle number button clicks
            function handleNumberClick(number) {
                if (currentInputIndex < pinInputs.length) {
                    pinInputs[currentInputIndex].value = number;
                    currentInputIndex++;
                    if(currentInputIndex === 4){
                        submitPin();
                    }
                }
            }

            // Function to handle the delete (X) button click
            function handleDeleteClick() {
                if (currentInputIndex > 0) {
                    currentInputIndex--;
                    pinInputs[currentInputIndex].value = '';
                }
            }

            // Add event listeners to number buttons
            document.querySelectorAll('.pin-btns button').forEach((button) => {
                const value = button.textContent.trim();

                if (value && value !== 'X') {
                    button.addEventListener('click', () => handleNumberClick(value));
                } else if (value === 'X') {
                    button.addEventListener('click', handleDeleteClick);
                }
            });

            function submitPin(){
                const pinValues = Array.from(pinInputs).map(input => input.value).join('');

                fetch("server/pin-login.php", {
                    method: "POST",
                    body: JSON.stringify({
                        'pins': pinValues,
                    }),
                    headers: {
                        'Content-Type': 'application/json',
                    },
                })
                .then(response => response.text())
                .then(data => {
                    if(data.includes("success")){
                        window.location.href = 'dashboard.php';
                    } else {
                        showMessage("bi bi-exclamation-circle", data, "err ");
                    }
                });
            }

            // Add event listener to the fingerprint button
            document.getElementById('fingerprint-button').addEventListener('click', () => {
                // Call the fingerprint authentication function
                authenticateWithFingerprint();
            });

            // Function to handle fingerprint authentication
            function authenticateWithFingerprint() {
                const fingerprintData = "userFingerprintData"; // Replace with actual fingerprint data

                fetch("fingerprint-login.php", {
                    method: "POST",
                    body: JSON.stringify({ 'fingerprint': fingerprintData }),
                    headers: {
                        'Content-Type': 'application/json',
                    },
                })
                .then(response => response.text())
                .then(data => {
                    if (data.includes("success")) {
                        window.location.href = 'dashboard.php'; // Redirect on success
                    } else {
                        showMessage("bi bi-exclamation-circle", data, "err "); // Display error message
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    showMessage("bi bi-exclamation-circle", "An error occurred during authentication.", "err ");
                });
            }
        function registerFingerprint() {
                // Register fingerprint logic goes here
                // You can use a fingerprint registration API or library to capture the user's fingerprint data
                // Then, store the captured data in the user's database record
                // For demonstration purposes, we'll assume the registration process is successful
                const fingerprintData = "newFingerprintData"; // Replace with actual fingerprint data
                fetch("update-fingerprint.php", {
                    method: "POST",
                    body: JSON.stringify({ 'fingerprint': fingerprintData }),
                    headers: {
                        'Content-Type': 'application/json',
                    },
                })
                .then(response => response.text())
                .then(data => {
                    if (data.includes("success")) {
                        showMessage("bi bi-check-circle", "Fingerprint registered successfully!", "success");
                    } else {
                        showMessage("bi bi-exclamation-circle", data, "err ");
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    showMessage("bi bi-exclamation-circle", "An error occurred during fingerprint registration.", "err ");
                });
            }
        });
    </script>
</body>
</html>