<?php
 session_start();
 include_once "server/conn.php";
 require "server/controller.php";
 if(!isset($_SESSION["pin_verify"])){
   header("Location: login.php");
   exit();
 }
 
 $user_id = $_SESSION["pin_verify"];
 $user = Control::fetchDetail($conn, $user_id);
 if($user["status"] === false){
   echo $user["msg"];
   exit();
 }
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Pin verification || Cidapay</title>
  <?php
   $site = Control::site($conn);
  ?>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
  *{
    box-sizing: border-box;
    font-family: "Mitr", Sans-Serif;
  }
  body{
    margin: 30px;
  }
    .pin-inputs{
      display: flex;
      justify-content: center;
      align-items: center;
      margin-top: 5px;
      margin-bottom: 15px;
    }
    .pin-inputs input{
      padding: 10px;
      border: 2px solid #0000ff;
      background: #fff;
      height: 50px;
      width: 50px;
      border-radius: 8px;
      margin-left: 12px;
      margin-right: 12px;
      text-align: center;
      font-weight: 900;
      color: #000;
      font-size: 20px;
    }
    .head{
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        background: transparent;
        height: 50px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 20px;
    }
    .head i{
        font-size: 16px;
        color: #222;
    }
    .head span{
        font-size: 10px;
        font-weight: 300;
        color: <?php echo $site["site_color"]; ?>;
    }
    .up-text{
      margin-bottom: 15px;
      margin-top: 60px;
      width: 320px;
      text-align: center;
    }
    .up-text b{
      display: block;
      font-size: 14px;
      font-weight: 00;
      color: #222;
      margin-bottom: 5px;
      margin-top: 10px;
    }
    .up-text small{
      display: block;
      font-size: 11px;
      font-weight: 300;
      color: #777;
    }
    .center{
        font-size: 12px;
        text-align: center;
        width: 100%;
        display: block;
        margin: 0;
        margin-bottom: 200px;
    }
    .center a{
        text-decoration: none;
        color:blue;
    }
    .center a:visited{
        color:;
    }
    .pin-btns{
      position: fixed;
      bottom: 25px;
      left: 6%;
      right: 6%;
      background: #fff;
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      padding: 5px;
      grid-column-gap: 10px;
      grid-row-gap: 10px;
    }
    .pin-btns button.no{
      background: transparent;
      box-shadow: none;
    }
    .pin-btns button{
      border: none; 
      outline: none;
      height: 70px;
      border-radius: 9px; 
      background: transparent;
      font-size: 18px;
      font-weight: 900;
      font-family: "";
    }
    .pin-btns button i{
        color: #777;
    }
    .pin-btns button i.clr{
        padding: 10px;
        border-radius: 50%;
        height: 55px;
        width: 55px;
        color: #fff;
        display: flex;
        justify-content: center;
        align-items: center;
        background: <?php echo $site["site_color"]; ?>;
    }
    .smaller-txt{
        display: block;
        margin: 0;
        color: #0005;
    }
.alertErr,
.alertSuc{
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  z-index: 60;
  display: flex;
  align-items: center;
  justify-content: center;
  background: hsl(0, 0%, 10%, 0.4);
  transition: 0.25s;
}
.alertErr .adiv,
.alertSuc .adiv{
  padding: 26px;
  border-radius: 15px;
  background: #fff;
  width: 260px;
  box-shadow: border-box;
  word-break: break-word;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  animation: zoomInMsg 0.2s;
  transition: 0.25s;
}
@keyframes zoomInMsg{
  from{
    transform: scale(0.7);
    opacity: 0.1;
  }
  to{
    transform: scale(1);
    opacity: 1;
  }
}
.alertErr,
.alertSuc{
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  z-index: 60;
  display: flex;
  align-items: center;
  justify-content: center;
  background: hsl(0, 0%, 10%, 0.4);
  transition: 0.25s;
}
.alertErr .adiv,
.alertSuc .adiv{
  padding: 0px;
  border-radius: 16px;
  background: #fff;
  width: 290px;
  box-shadow: border-box;
  word-break: break-word;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  animation: zoomInMsg 0.2s;
  transition: 0.25s;
  overflow: hidden;
}
@keyframes zoomInMsg{
  from{
    transform: scale(0.9);
    opacity: 0.1;
  }
  to{
    transform: scale(1);
    opacity: 1;
  }
}
.alertErr .adiv i,
.alertSuc .adiv i{
  font-size: 50px;
  margin-bottom: 5px;
  margin-top: 20px;
}
.alertErr .adiv span,
.alertSuc .adiv span{
  font-size: 13px;
  font-weight: 400;
  color: #222;
  margin-top: 10px;
  margin-bottom: 18px;
  text-align: center;
  padding: 0px;
  padding-left: 13px;
  padding-right: 13px;
}
.alertSuc .adiv i{
  color: rgba(0%, 50%, 0%);
}
.alertErr .adiv i{
  color: rgba(80%, 0%, 0%);
}
.alertErr .adiv .button,
.alertSuc .adiv .button{
  display: inline-flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  box-sizing: border-box;
  margin-bottom: 0;
  border-top: 1px solid hsl(0, 0%, 70%);
  padding-top: 0px;
}
.alertErr .adiv .button button,
.alertSuc .adiv .button button{
  padding: 10px;
  color: #fff;
  line-height: 0;
  display: flex;
  align-items: center;
  justify-content: center;
  outline: none;
  border-radius: 0px;
  height: 45px;
  width: 50%;
  font-size: 12px;
  font-family: var(--mitr);
  background: #fff;
  color: #666;
  border: none;
}
.alertErr .adiv .button button:hover,
.alertSuc .adiv .button button:hover,
.alertErr .adiv .button button:active,
.alertSuc .adiv .button button:active{
  background: hsl(0, 0%, 90%);
}
.alertSuc .adiv .button #cancelBtn,
.alertErr .adiv .button #cancelBtn{
  border-right: 0.8px solid hsl(0, 0%, 70%);
}
.alertErr .adiv .button #okBtn,
.alertSuc .adiv .button #okBtn{
  border-left: 0.8px solid hsl(0, 0%, 70%);
}
.spin{
  padding: 2px;
  height: 25px;
  width: 25px;
  border: 2.7px solid #fff;
  border-top: 2.7px solid #0003;
  background: transparent;
  border-radius: 50%;
  animation: infinitySpin 0.5s linear infinite;
  display: inline-block;
  box-sizing: border-box;
}
@keyframes infinitySpin{
  0%{
    transform: rotate(0deg);
  }
  100%{
    transform: rotate(360deg);
  }
}
.finger{
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 5px;
}
.finger i{
    font-size: 29px;
    padding: 5px;
    width: 45px;
    height: 45px;
    box-sizing: border-box;
    display: flex;
    align-items: center;
    justify-content: center;
    border: none;
    color: #555;
}
  </style>
</head>
<body>
    <div class="head">
        <i class="fas fa-arrow-left" onclick="goBack()"></i>
        <span><?php echo substr_replace($user["phone"], '****', 3, 4); ?></span>
    </div>
  <div class="up-text">
    <img src="Uploads/<?php echo $user["img"]; ?>" alt="User Avatar" style="width: 50px; height: 50p; border-radius: 50%;">
    <b>Welcome <?php echo $user["fname"]; ?></b>
    <small>Please enter your 4 digits PIN</small>
  </div>
  <div class="pin-inputs">
    <input type="password" name="pin-1" id="pin-1" maxlength="1" disabled>
    <input type="password" name="pin-2" id="pin-2" maxlength="1" disabled>
    <input type="password" name="pin-3" id="pin-3" maxlength="1" disabled>
    <input type="password" name="pin-4" id="pin-4" maxlength="1" oninput="submitPin()" disabled>
  </div>
  <div class="finger">
      <i class="ri-fingerprint-line" onclick="fingerLogin()"></i>
  </div>
  <div class="center">Not <?php echo  $user["fname"] ?> <a href="login.php?login">Sign Out</a></div>
  
  <div class="pin-btns">
    <button>1</button>
    <button>2</button>
    <button>3</button>
    <button>4</button>
    <button>5</button>
    <button>6</button>
    <button>7</button>
    <button>8</button>
    <button>9</button>
    <button><i class="fas fa-backspace" style="color:blue"></i></button>
    <button>0</button>
    <button><i class="fas fa-arrow-right clr"></i></button>
  </div>
<script>
<?php include "js/msg.js"; ?>
  document.addEventListener('DOMContentLoaded', function () {
    fingerLogin();
    const pinInputs = document.querySelectorAll('.pin-inputs input');
    let currentInputIndex = 0;

    // Function to handle number button clicks
    function handleNumberClick(number) {
      if (currentInputIndex < pinInputs.length) {
        pinInputs[currentInputIndex].value = number;
        currentInputIndex++;
        if(currentInputIndex === 4){
          submitPin();
        }
      }
    }

    // Function to handle the delete (X) button click
    function handleDeleteClick() {
      if (currentInputIndex > 0) {
        currentInputIndex--;
        pinInputs[currentInputIndex].value = '';
      }
    }

    // Add event listeners to number buttons
    document.querySelectorAll('.pin-btns button').forEach((button) => {
      const value = button.innerHTML.trim();
      const pinValues = Array.from(pinInputs).map(input => input.value).join('');
      
        
        if (button.querySelector('i.fa-backspace')) {
          button.addEventListener('click', handleDeleteClick);
        } else if (button.querySelector('i.fa-arrow-right')) {
          button.addEventListener('click', submitPin);
        } else {
          button.addEventListener('click', () => handleNumberClick(value));
        }
        
    });
  
  function submitPin(){
    const pinValues = Array.from(pinInputs).map(input => input.value).join('');

    fetch("server/pin-login.php", {
      method: "POST",
      body: JSON.stringify({
        'pins': pinValues,
        'type': 'pin-login',
      }),
      headers: {
        'Content-Type': 'application/json',
      },
    })
    .then(response => response.text())
    .then(data => {
      if(data.includes("success")){
        window.location.href = 'dashboard.php';
      }else{
        showMessage("bi bi-exclamation-circle", data, "err");
      }
    });
  }
  });
  
  
        function setCookie(name, value, days) {
            let expires = "";
            if (days) {
                const date = new Date();
                date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                expires = "; expires=" + date.toUTCString();
            }
            document.cookie = name + "=" + (value || "") + expires + "; path=/";
        }

        function getCookie(name) {
            const nameEQ = name + "=";
            const ca = document.cookie.split(';');
            for (let i = 0; i < ca.length; i++) {
                let c = ca[i];
                while (c.charAt(0) === ' ') c = c.substring(1, c.length);
                if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
            }
            return null;
        }

        function base64ToUint8Array(base64) {
            const binaryString = atob(base64);
            const len = binaryString.length;
            const bytes = new Uint8Array(len);
            for (let i = 0; i < len; i++) {
                bytes[i] = binaryString.charCodeAt(i);
            }
            return bytes;
        }

  
  
          async function register(){
              try {
                const publicKeyCredentialCreationOptions = {
                    challenge: Uint8Array.from(window.crypto.getRandomValues(new Uint8Array(32))),
                    rp: {
                        name: "Buypoint"
                    },
                    user: {
                        id: Uint8Array.from(window.crypto.getRandomValues(new Uint8Array(16))),
                        name: "",
                        displayName: ""
                    },
                    pubKeyCredParams: [{ alg: -7, type: "public-key" }],
                    authenticatorSelection: {
                        userVerification: "preferred"
                    },
                    timeout: 60000,
                    attestation: "direct"
                };

                // Create new credentials (register passkey)
                const credential = await navigator.credentials.create({ publicKey: publicKeyCredentialCreationOptions });

                if (credential) {
                    const rawId = new Uint8Array(credential.rawId);
                    setCookie('credentialId', btoa(String.fromCharCode(...rawId)), 30);
                    showMessage("bi bi-check-circle", "Fingerprint regstration successfully", "suc");
                }
            } catch (error) {
                showMessage("bi bi-info-circle", "Unable to register fingerprint", "err");
            }
          }
  
  
          async function fingerLogin(){
              try {
                const storedCredentialId = getCookie('credentialId');

                if (!storedCredentialId) {
                    register();
                    return;
                }

                const publicKeyCredentialRequestOptions = {
                    challenge: Uint8Array.from(window.crypto.getRandomValues(new Uint8Array(32))),
                    allowCredentials: [{
                        id: base64ToUint8Array(storedCredentialId),  // Convert Base64 back to Uint8Array
                        type: "public-key"
                    }],
                    timeout: 60000,
                    userVerification: "preferred"
                };

                // Authenticate with the registered passkey
                const assertion = await navigator.credentials.get({ publicKey: publicKeyCredentialRequestOptions });

                if (assertion) {
                    fetch("server/pin-login.php", {
                      method: "POST",
                      body: JSON.stringify({
                        'pins': '',
                        'type': 'fingerprint',
                      }),
                      headers: {
                        'Content-Type': 'application/json',
                      },
                    })
                    .then(response => response.text())
                    .then(data => {
                      if(data.includes("success")){
                        window.location.href = 'dashboard.php';
                      }else{
                        showMessage("bi bi-exclamation-circle", data, "err");
                      }
                    });
                }
            } catch (error) {
                showMessage("bi bi-info-circle", "Unable to verify fingerprint", "err");
            }
          }
</script>

</body>
</html>