<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <title>Login</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Payment Link</span>
    <a href="logout.php" style="text-decoration: none; color: #3333ff"><i class="fas fa-sign-out"></i></a>
  </div>
  
  <div class="pay-h-txt">
    <h2>Get paid via link</h2>
    <span>Share your payment link to get paid by anyone</span>
  </div>
  
  <div class="p-pay-box">
    <div class="p-letter"><?php echo substr($user["fname"], 0, 1); ?></div>
    <div class="p-name">
      <b><?php echo $user["fname"]." ".$user["lname"]; ?></b>
      <span>@<?php echo $user["fname"]; ?></span>
    </div>
    <div class="p-link-b">
      <span>https://<?php echo $_SERVER["HTTP_HOST"] ?>/app/pay-me.php?user=<?php echo $user["unique_id"]; ?></span>
      <i class="bi bi-copy" onclick="copyTxt('https://<?php echo $_SERVER["HTTP_HOST"] ?>/mobile/pay-me.php?user=<?php echo $user["unique_id"]; ?>')"></i>
    </div>
  </div>
  
  <div class="p-button"><button>SHARE LINK</button></div>
  <script>
   <?php include "js/msg.js"; ?>
   
  </script>
  </body>
</html>