<?php
include_once "server/conn.php";
require "server/controller.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>Document</title>
  <link rel="stylesheet" href="css/pay-me.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Pay Me || Buypoint #everything payment</title>
  <style>
    @font-face {
      font-family: 'Poppins';
      src: url('css/poppins/Poppins-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    .alertErr,
.alertSuc{
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  z-index: 60;
  display: flex;
  align-items: center;
  justify-content: center;
  background: hsl(0, 0%, 10%, 0.4);
  transition: 0.25s;
}
.alertErr .adiv,
.alertSuc .adiv{
  padding: 0px;
  border-radius: 16px;
  background: #fff;
  width: 290px;
  box-shadow: border-box;
  word-break: break-word;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  animation: zoomInMsg 0.2s;
  transition: 0.25s;
  overflow: hidden;
}
@keyframes zoomInMsg{
  from{
    transform: scale(0.9);
    opacity: 0.1;
  }
  to{
    transform: scale(1);
    opacity: 1;
  }
}
.alertErr .adiv i,
.alertSuc .adiv i{
  font-size: 50px;
  margin-bottom: 5px;
  margin-top: 20px;
}
.alertErr .adiv span,
.alertSuc .adiv span{
  font-size: 13px;
  font-weight: 400;
  color: #222;
  margin-top: 10px;
  margin-bottom: 18px;
  text-align: center;
  padding: 0px;
  padding-left: 13px;
  padding-right: 13px;
}
.alertSuc .adiv i{
  color: rgba(0%, 50%, 0%);
}
.alertErr .adiv i{
  color: rgba(80%, 0%, 0%);
}
.alertErr .adiv .button,
.alertSuc .adiv .button{
  display: inline-flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  box-sizing: border-box;
  margin-bottom: 0;
  border-top: 1px solid hsl(0, 0%, 70%);
  padding-top: 0px;
}
.alertErr .adiv .button button,
.alertSuc .adiv .button button{
  padding: 10px;
  color: #fff;
  line-height: 0;
  display: flex;
  align-items: center;
  justify-content: center;
  outline: none;
  border-radius: 0px;
  height: 45px;
  width: 50%;
  font-size: 12px;
  font-family: var(--mitr);
  background: #fff;
  color: #666;
  border: none;
}
.alertErr .adiv .button button:hover,
.alertSuc .adiv .button button:hover,
.alertErr .adiv .button button:active,
.alertSuc .adiv .button button:active{
  background: hsl(0, 0%, 90%);
}
.alertSuc .adiv .button #cancelBtn,
.alertErr .adiv .button #cancelBtn{
  border-right: 0.8px solid hsl(0, 0%, 70%);
}
.alertErr .adiv .button #okBtn,
.alertSuc .adiv .button #okBtn{
  border-left: 0.8px solid hsl(0, 0%, 70%);
}
.spin{
  padding: 3px;
  height: 25px;
  width: 25px;
  border: 2.7px solid #3333ff;
  border-top: 2.7px solid #3333ff;
  background: transparent;
  border-radius: 50%;
  animation: infinitySpin 0.5s linear infinite;
  display: inline-block;
  box-sizing: border-box;
}
@keyframes infinitySpin{
  0%{
    transform: rotate(0deg);
  }
  100%{
    transform: rotate(360deg);
  }
}
  </style>
</head>
<body>
<?php


$result = "";
if(!isset($_GET["user"])){
 ?>
   <div class="no-exist">
     <i class="bi bi-x-circle"></i>
     <h2>UNmobileIZED!!</h2>
     <span>Unmobileized View Of page User identification is required to make funds</span>
   </div>
<?php
exit();
}

$user_id = validate::validateString($conn, $_GET["user"]);
$user = Control::fetchDetail($conn, $user_id);

if($user["status"] == false){
  $result = "false";
}else{
?>
  <div class="img">
   <img src="logos/logo2.png" alt="Logo">
  </div>
  <form class="box" id="form">
    <div class="head">
      <span>SEND SOME FUNDS TO:</span>
     <h2 class="h2"><?php echo$user["fname"]." ".$user["lname"]; ?></h2>
    </div>
    
    <div class="inputs"id="amount:inputs">
      <span>How much do you want to send?</span>
      <input type="tel" name="amount" id="amount" oninput="checkValue('amount', 'amount-err', 100, 'value', 'Invalid amount minimum(NGN 100)', '')" placeholder="1000" value="">
      <b id="amount-err"></b>
    </div>
    
    <div class="inputs"id="name:inputs">
      <span>What's your name?</span>
      <input type="text" name="name" id="name" oninput="checkValue('name', 'name-err', '', 'empty', 'Empty field detected', '')" placeholder="Jhon Doe" value="">
      <b id="name-err"></b>
    </div>
    
    <div class="inputs"id="email:inputs">
      <span>What's your email address?</span>
      <input type="email" name="email" id="email" oninput="checkValue('email', 'email-err', '', 'email', 'Invalid email address', '')" placeholder="jhondoe@gmail.com" value="">
      <b id="email-err"></b>
    </div>
    
    <div class="inputs" id="phone:inputs">
      <span>What's your phone number?</span>
      <input type="tel" name="phone" id="phone" oninput="checkValue('phone', 'phone-err', 11, 'length', 'Invalid phone number', '')" placeholder="08012345678" value="">
      <b id="phone-err"></b>
    </div>
    
    <div class="inputs">
      <span>Description(Optional)</span>
      <textarea type="text" name="additional" id="additional" placeholder="(OPTIONAL)"></textarea>
    </div>
    <button type="button" class="proceed" onclick="showMethod()">PROCEED <i class="fas fa-arrow-right"></i></button>
    
    <!--=================================================================
    //select payment method beginning
    <!--=================================================================-->
    <div class="method" id="method">
      <div class="method-other">
        <div class="top">
          <img src="Uploads/<?php echo $user["img"]; ?>" alt="Profile Image">
          <div class="t-inn">
            <b><?php echo $user["fname"]." ".$user["lname"]; ?></b>
            <b id="innAmt"></b>
          </div>
        </div>
        <div class="innCode" id="innCode">
          
        </div>
        <div class="c-new">or choose a new payment method?</div>
        <div class="mth-b">
          <img src="logos/<?php echo $site["site_logo"]; ?>" alt="MBILLS LOGO" width="65" height="28" class="o">
          <button type="button" class="sel-btn" id="p-b" onclick="selectMethod(this, 'transfer')"><i class="bi bi-bank"></i> Transfer</button>
        </div>
      </div>
      <button class="cancel-btn" type="button" onclick="removeM();"><i class="bi bi-x-circle"></i>Cancel Payment</button>


    </div>
    <!--=================================================================
    //select payment method end
    <!--=================================================================-->
    
    
  </form>
<?php
}
?>
  <script>
    <?php include "js/msg.js"; ?>
    function getEId(theIdname){
      const theGet = document.getElementById(theIdname);
      return theGet;
    }
    const payForm = getEId("form");
    const amount = getEId("amount");
    const name = getEId("name");
    const email = getEId("email");
    const phone = getEId("phone");
    const method = getEId("method");
    function showMethod(){
      if(amount.value == "" || amount.value < 100 || name.value == "" || email.value == "" || phone.value == "" || phone.value.length < 11){
        amount.dispatchEvent(new Event("input"));
        name.dispatchEvent(new Event("input"));
        email.dispatchEvent(new Event("input"));
        phone.dispatchEvent(new Event("input"));
      }else{
        getEId("innAmt").innerHTML = "pay NGN " + parseFloat(amount.value).toLocaleString() + ".00";
        method.style.display = "flex";
        selectMethod(document.getElementById("p-b"), "transfer");
      }
    }
    
    const codeInn = document.createElement("div");
    codeInn.setAttribute("style", "width: 100%; padding: 10px; display: flex; align-items: center; justify-content: center; flex-direction: column;");
    codeInn.innerHTML = `<button class="pay-btn" type="button" onclick="generateAccount(this)">Click here to generate account <i class="fas fa-chevron-right"></i></button>`;
    
    function doRemove(){
      const methodDiv = method.querySelector(".method-other");
      methodDiv.style.transform = "translateY(-30%)";
      methodDiv.style.opacity = "0";
      setTimeout(()=> {
        methodDiv.style.transform = "translateY(0%)";
        methodDiv.style.opacity = "1";
        method.style.display = "none";
      }, 450);
    }
    function removeM(){
      doRemove();
    }
    const selBtns = document.querySelectorAll(".sel-btn");
    const innCode = getEId("innCode");
    function selectMethod(thisBtn, type){
      selBtns.forEach(thisSel => {
        thisSel.classList.remove("active");
      });
      
      thisBtn.classList.add("active");
      
      if(type == "paystack"){
        innCode.innerHTML = `
          <button class="pay-btn" type="button" onclick="payPaystack(this)">Click here to continue with paystack <i class="fas fa-chevron-right"></i></button>
        `;
      }else{
        innCode.innerHTML = "";
        innCode.appendChild(codeInn);
      }
    }
    
    function generateAccount(thisBtn){
        const formData  = new FormData();
        formData.append("user_id", "<?php echo $user["unique_id"]; ?>");
        formData.append("amount", amount.value);
        
        showP(thisBtn);
        fetch("server/generate-tempoary-account.php", {
            method: "POST",
            body: formData,
        })
        .then(response => response.text())
        .then(data => {
            removeP(thisBtn, "Click here to generate account <i class='fas fa-chevron-right'></i>");
            if(data.includes("</div>")){
                codeInn.innerHTML = data;
                innCode.appendChild(codeInn);
                codeInn.innerHTML = data;
            }else{
                showMessage("fas fa-times-circle", data, "err");
            }
        });
    }
    
    function verifyFund(thisBtn, ref){
        const formData  = new FormData();
        formData.append("user_id", "<?php echo $user["unique_id"]; ?>");
        formData.append("ref", ref);
        formData.append("amount", amount.value);
        
        showP(thisBtn);
        fetch("server/verify-tempoary-funding.php", {
            method: "POST",
            body: formData,
        })
        .then(response => response.text())
        .then(data => {
            removeP(thisBtn, "I have sent the money");
            if(data.includes("success")){
               showMessage("fas fa-check-circle", data, "suc");
               window.location.reload();
            }else{
                showMessage("fas fa-times-circle", data, "err");
            }
        });
    }
  </script>
</body>
</html>