<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$verification = Control::fetchVerification($conn, $user_id);


if(!empty($verification["nin"]) && !strstr($verification["nin"], "_verifying") && !strstr($verification["nin"], "_rejected")){
     header("Location: account-verification.php");
     exit(); 
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>NIN Verification</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    .vr-bx{
        width: 320px;
        padding: 16px;
        margin-bottom: 20px;
        border-radius: 7px;
        border: 2px solid rgba(0%, 70%, 0%, 20%);
        background: rgba(0%, 70%, 0%, 10%);
        font-size: 11px;
        font-weight: 300;
        color: rgba(0%, 70%, 0%);
    }
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>NIN Verification</span>
  </div>
  
  <form class="form-box" id="nin-form">
    <?php
    $disabled = "";
    $op = "";
     if(strstr($verification["nin"], "_verifying")){
         $disabled = "disabled";
         $op = "opacity: 0.4";
         echo '
         <div class="vr-bx">Your NIN verification is undergoing review please wait for our verification team to complete your verification.</div>
         ';
     }
    ?>
    <div class="f-head">Kindly enter NIN to verify</div>
    
    <div class="s-txt"></div>
    
    <div class="inputs">
      <span>Enter NIN</span>
      <input type="tel" name="nin" id="nin" maxLength="11" placeholder="01234567890" value="<?php echo trim(str_replace(["_verifying", "_rejected"], "", $verification["nin"])); ?>" oninput="checkValue('nin', 'nin-err', 11, 'length', 'Invalid nin', '')" <?php echo $disabled; ?>>
      <b id="nin-err"></b>
    </div>
    <button type="button" style="<?php echo $op; ?>" class="button" onclick="submitNin(this)" <?php echo $disabled; ?>>SUBMIT</button>
    
  </form>
  
    
  <div class="why-need-box" id="why-need-box">
    <div class="w-n-head" onclick="toggAuto(document.getElementById('why-need-box'))">
      <i class="ri-information-line"></i>
      <span>Why do we need your NIN?</span>
      <i class="fas fa-chevron-down"></i>
    </div>
    
    <div class="w-other">
      <h3>We only have access to your:</h3>
      
      <div class="w-b-other">
        <i class="fas fa-check"></i>
        <span>Real Name</span>
      </div>
      
      <div class="w-b-other">
        <i class="fas fa-check"></i>
        <span>Phone Number</span>
      </div>
      
      <div class="w-b-other">
        <i class="fas fa-check"></i>
        <span>Date Of Birth</span>
      </div>
      
      <div class="w-txt">
        This does noy give us access to your bank information or balance
        <pre></pre>
        We use your details only for identity verification purposes, and we do not share your details with third parties.
      </div>
    </div>
  </div>
  
  
  <div class="more-txt">
    For more information on what we do with and why we need your data. Please read our
    <a href="terms-and-condition.php">Terms & Services.</a>
  </div>
  
  <script>
    <?php include "js/msg.js"; ?>
    function resendOtp(thisInn){
        startCount(30, "resend", "Resend OTP");
    }
    
    function getId(idName){
        return document.getElementById(idName);
    }
    
    function toggAuto(thisT){
      thisT.classList.toggle("active");
    }    
    const ninForm = getId("nin-form");
    function submitNin(thisBtn){
        const nin = getId("nin");
        if(nin.value.length < 11){
            nin.dispatchEvent(new Event("input"));
        }else{
            let formerTxt = thisBtn.innerText;
            showP(thisBtn);
            fetch("server/verify-nin.php", {
                method: "POST",
                body: new FormData(ninForm),
            })
            .then(response => response.text())
            .then(data => {
                removeP(thisBtn, formerTxt);
                if(data.includes("success")){
                  showMessage("bi bi-check2-circle", data, "suc");
                  window.location.reload();
                }else{
                  showMessage("bi bi-exclamation-circle", data, "err");
                }
            });
        }
    }
  </script>
  </body>
</html>