<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Animated Button</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        .total-outstanding {
            padding: 20px;
        }

        .repay-btn {
            padding: 10px 20px;
            background-color: #ffffff;
            color: white;
            font-size: 1em;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: transform 0.3s ease-in-out, background-color 0.3s ease;
        }

        /* Hover effect to scale up the button */
        .repay-btn:hover {
            transform: scale(1.1); /* Zoom in effect */
            background-color: #ffffff; /* Change to a darker green on hover */
        }

        /* Animation when page loads */
        @keyframes buttonAnimation {
            0% {
                transform: scale(0.9); /* Start smaller */
                opacity: 0;
            }
            50% {
                transform: scale(1.1); /* Grow larger */
                opacity: 1;
            }
            100% {
                transform: scale(1); /* End at normal size */
            }
        }

        .repay-btn {
            animation: buttonAnimation 1s ease-out; /* Apply animation on load */
        }
    </style>
</head>
<body>
    <div class="total-outstanding">
        <h2><i class="bi bi-shield-fill-check"></i> Available Balance  <i class="ri-eye-line" onclick="toggleEye(this, 'balance')"></i></h2>
        <div class="amount">
            <span id="balance" data-visible="true"><?php echo $user["format_balance"]; ?></span>
        </div>

        <a class="details" style="color:white;font-size:0.7em" href="transactions.php">Transaction History <i class="fas fa-chevron-right"></i></a>
        
        <button onclick="window.location.href='generate-account.php';" class="repay-btn">
            <i class="bi bi-plus"></i> Accounts
        </button>
    </div>
</body>
</html>
