<?php
session_start();
include_once "server/conn.php";
include "server/controller.php";

if (!isset($_GET["login"])) {
    if (isset($_COOKIE["user_id"])) {
        $_SESSION["pin_verify"] = $_COOKIE["user_id"];
        header("Location: pin.php");
        exit();
    }
}



$site = Control::site($conn);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/log-sign.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="manifest.json"> 
  <title>Login</title>
  <script src="app.js"></script>
  <style>
    @font-face {
      font-family: 'Poppins', sans-serif;
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    .container {
    text-align: center;
}
:root{
  --poppins: "Poppins", Sans-Serif;
  --mitr: "Poppins", Sans-Serif;
      --site-clr: linear-gradient(to left,#5e1d3d,#5e1d3d);
      --bg: hsl(0, 0%, 99%);
    }

    @font-face {
      font-family: 'Poppins', sans-serif;
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
    }
       
  #password:inputs {
  position: relative;
}

#toggle-password-visibility {
  position: absolute;
  right: 10px;
  top: 50%;
  transform: translateY(-50%);
  cursor: pointer;
  z-index: 1;
}


.password-container {
  position: relative;
}

#password {
  width: 100%;
  padding-right: 25px; /* add padding for icon */
  box-sizing: border-box;
}


body{
  font-family: 'Poppins', sans-serif;
  display: flex;
  align-items: center;
  justify-content: center;
  min-height: 92vh;
 background: #ffffff;
  background-size: cover;
  letter-spacing: 0px;
  flex-direction: column;
  user-select: none;
}
span, h1, h2, h3, h4, h5, h6, div, button, table, p, b, i, section, form, em, input, textarea{
  font-family: 'Poppins', sans-serif;
}
a{
  text-decoration: none;
}
button{  
  letter-spacing: 0px;
}
.box{
  padding: 20px;
  border-radius: 5px;
  width: 335px;
  box-sizing: border-box;
  margin-bottom: 20px;
  margin-top: 15px;
  box-shadow: none;
  background: transparent;
  /*box-shadow: 0 4px 7px 2px #0001;*/
}
.head-two{
  margin-bottom: 3px;
  text-align: center;
}
.head-two img{
  width: 100px;
  height: 50px;
  margin-bottom: 3px;
  margin-top: 3px;
  font-weight: 900;
 
}
.box .head{
  margin-bottom: 22px;
  text-align: center;
}
.box .head img{
  width: 100%;
  height: 100PX;
  object-fit:cover;
  margin-bottom: 10px;
  margin-top: 5px;
 font-weight: 900;
}
.box .head h2{
  font-size: 17px;
  margin-top: 0;
  margin-bottom: 6px;
  text-align: left;
  font-weight: 800;
  color:blue;
  text-align:center;
}
.box .inputs #check{
  color: #000000;
  font-size: 15px;
  position: absolute;
  top: 41px;
  right: 7px;
  padding: 1px;
  background: #fff;
  border-radius: 50%;
}

.box .inputs #checkErr{
  color: #000000;
  font-size: 15px;
  position: absolute;
  top: 41px;
  right: 7px;
  padding: 1px;
  background: #fff;
  border-radius: 50%;
  font-weight: bold;
}
.box .head span{
  font-size: 13px;
  display: block;
  line-height: 17px;
  text-align: center;
  color: #777;
}
.box .inputs{
  margin-bottom: 5px;
  margin-top: 5px;
  position: relative;
 
}
.box .inputs span{
  font-size: 12px;
  color: #5e1d3d;
  font-weight: 600;
  letter-spacing: 0px;
}
.box .inputs .err i,
.box .inputs .suc i{
  font-size: 13px;
  margin-right: 7px;
}
.box .inputs .err,
.box .inputs .suc{
  padding: 2px;
  border-radius: 6px;
  font-size: 10px;
  font-weight: 00;
  display: flex;
  width: 100%;
  box-sizing: border-box;
  margin-top: 4px;
  align-items: center;
  font-weight: bold;
}
.box .inputs .err{
  color: #000000;
}
.box .inputs .suc{
  color: #000000;
}
.box .inpSep{
  display: flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  box-sizing: border-box;
}
.box .inpSep .inputs{
  width: 48%;
}
.box .inputs input[type="password"]{
  font-size: 15px;
}
.box .inputs select,
.box .inputs input{
  padding: 10px;
  height: 38px;
  border:none;
  width: 100%;
  box-sizing: border-box;
  border-bottom: 5px solid #5e1d3d;
  font-size: 15px;
  font-weight: 500;
  outline: none;
  font-family: 'Poppins', sans-serif;
  background: transparent;
  border-radius: 15px;
}
.box .inputs input:focus{
    border-bottom-color:blue;
}
@keyframes over{
  from{
    transform: translateY(-7px);
    opacity: 0;
  }
  to{
    transform: translateY(0px);
    opacity: 1;
  }
}
@keyframes overUp{
  from{
    transform: translateY(0px);
    opacity: 1;
  }
  to{
    transform: translateY(-6px);
    opacity: 0;
  }
}
.box .inputs input::placeholder{
  font-weight: 500;
  color: #0003;
  font-size: 11px;
}

.box button.b{
  margin-top: 10px;
}
.box button{
  padding: 10px;
  height: 48px;
  border: none;
  outline: none;
  background: var(--site-clr);
  color: #fff;
  line-height: 0;
  border-radius: 15px;
  width: 100%;
  margin-top: 25px;
  font-family: 'Poppins', sans-serif;
  font-size: 11px;
  font-weight: 900;
}
.box button i{
  margin-left: 7px;
}
.box .sep{
  display: flex;
  justify-content: start;
  align-items: center;
  margin-bottom: 20px;
  margin-top: 10px;
}
.box .sep input{
  width: 11px;
  height: 11px;
}
.box .sep.t-c{
  text-align: center;
  margin-bottom: 0;
  margin-top: 35px;
  display: flex;
  justify-content: center;
}
.box .sep.t-c input{
  margin-right: 10px;
  width: 15px;
  height: 15px;
}
.box .sep.t-c label{
  font-size: 10px;
  font-weight: 600;
  font-family: 'Poppins', sans-serif;
}
.box .sep label{
  font-size: 10px;
  font-weight: 500;
  color: #333;
}
.box .link{
  text-align: center;
  font-size: 12px;
  font-weight: 500;
  color: #000;
}
.box .link a{
  color: #0000ff;
  font-weight: 600;
}
.box .link span{
  display: block;
  margin-top: 13px;
  margin-bottom: 10px;
  letter-spacing: 0.6px;
  font-size: 10px;
}
.b-b{
  display: flex;
  align-items: end;
  justify-content: flex-end;
  margin-top: 10px;
  width: 320px;
  box-sizing: border-box;
}
.b-b button{
  padding: 20px;
  height: 30px;
  background: var(--site-clr);
  color: #fff;
  font-weight: 700;
  font-size: 10px;
  line-height: 0;
  border-radius: 20px;
  border: none;
  outline: none;
  letter-spacing: 0.6px;
  font-family: 'Poppins', sans-serif;
}
.box button.resend-btn{
  border: none;
  background: transparent;
  color: var(--site-clr);
  font-size: 12px;
  font-weight: 500;
  margin-top: 10px;
  width: auto;
  padding: 0;
}
.alertErr,
.alertSuc{
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  z-index: 60;
  display: flex;
  align-items: center;
  justify-content: center;
  background: hsl(0, 0%, 10%, 0.4);
  transition: 0.25s;
}
.alertErr .adiv,
.alertSuc .adiv{
  padding: 26px;
  border-radius: 15px;
  background: #fff;
  width: 260px;
  box-shadow: border-box;
  word-break: break-word;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  animation: zoomInMsg 0.2s;
  transition: 0.25s;
}
@keyframes zoomInMsg{
  from{
    transform: scale(0.7);
    opacity: 0.1;
  }
  to{
    transform: scale(1);
    opacity: 1;
  }
}
.alertErr,
.alertSuc{
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  z-index: 60;
  display: flex;
  align-items: center;
  justify-content: center;
  background: hsl(0, 0%, 10%, 0.4);
  transition: 0.25s;
}
.alertErr .adiv,
.alertSuc .adiv{
  padding: 0px;
  border-radius: 16px;
  background: #fff;
  width: 290px;
  box-shadow: border-box;
  word-break: break-word;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  animation: zoomInMsg 0.2s;
  transition: 0.25s;
  overflow: hidden;
}
@keyframes zoomInMsg{
  from{
    transform: scale(0.9);
    opacity: 0.1;
  }
  to{
    transform: scale(1);
    opacity: 1;
  }
}
.alertErr .adiv i,
.alertSuc .adiv i{
  font-size: 50px;
  margin-bottom: 5px;
  margin-top: 20px;
}
.alertErr .adiv span,
.alertSuc .adiv span{
  font-size: 13px;
  font-weight: 400;
  color: #222;
  margin-top: 10px;
  margin-bottom: 18px;
  text-align: center;
  padding: 0px;
  padding-left: 13px;
  padding-right: 13px;
}
.alertSuc .adiv i{
  color: rgba(0%, 50%, 0%);
}
.alertErr .adiv i{
  color: rgba(80%, 0%, 0%);
}
.alertErr .adiv .button,
.alertSuc .adiv .button{
  display: inline-flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  box-sizing: border-box;
  margin-bottom: 0;
  border-top: 1px solid hsl(0, 0%, 70%);
  padding-top: 0px;
}
.alertErr .adiv .button button,
.alertSuc .adiv .button button{
  padding: 10px;
  color: #fff;
  line-height: 0;
  display: flex;
  align-items: center;
  justify-content: center;
  outline: none;
  border-radius: 0px;
  height: 45px;
  width: 50%;
  font-size: 12px;
  font-family: 'Poppins', sans-serif;
  background: #fff;
  color: #666;
  border: none;
}
.alertErr .adiv .button button:hover,
.alertSuc .adiv .button button:hover,
.alertErr .adiv .button button:active,
.alertSuc .adiv .button button:active{
  background: hsl(0, 0%, 90%);
}
.alertSuc .adiv .button #cancelBtn,
.alertErr .adiv .button #cancelBtn{
  border-right: 0.8px solid hsl(0, 0%, 70%);
}
.alertErr .adiv .button #okBtn,
.alertSuc .adiv .button #okBtn{
  border-left: 0.8px solid hsl(0, 0%, 70%);
}
.spin{
  padding: 2px;
  height: 25px;
  width: 25px;
  border: 2.7px solid #fff;
  border-top: 2.7px solid #0003;
  background: transparent;
  border-radius: 50%;
  animation: infinitySpin 0.5s linear infinite;
  display: inline-block;
  box-sizing: border-box;
}
@keyframes infinitySpin{
  0%{
    transform: rotate(0deg);
  }
font-family: Arial, sans-serif;
font-weight: bold;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #f4f4f4;
            margin: 0;
        }
        .container {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 300px;
            text-align: center;
        }
        input {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        button {
            width: 100%;
            padding: 10px;
            background: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .whatsapp-icon {
            position: fixed;
            bottom: 200px;
            right: 20px;
            width: 50px;
            height: 50px;
            background: #25D366;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
            cursor: pointer;
        }
        .whatsapp-icon img {
            width: 30px;
            height: 30px;
        }
  </style>
</head>
<body>
    
  <form class="box" id="log-in-form">
   
    </div>

    <div class="head">
        <h2 class="welcome-text" style="color: #5e1d3d; transition: color 0.3s ease-in-out;" 
    onmouseover="this.style.color='black';" 
    onmouseout="this.style.color='#5e1d3d';">
    Welcome back
</h2>
        <span>Securely login to your <?php echo $site["site_name"]; ?> account</span>
    </div>
    
    <div class="inputs" id="emailOrphone:inputs">
        <span>Email Or Phone Number</span>
        <input type="text" placeholder="youremail@gmail.com" name="emailOrphone" id="emailOrphone" oninput="checkValue('emailOrphone', 'email-err', '', 'email or phone', 'Invalid email or phone number', '')">
        <b id="email-err"></b>
    </div>

    <div class="inputs" id="password:inputs"> 
        <span>Password</span>
        <div class="password-container">
            <input type="password" placeholder="********" name="password" id="password" oninput="checkValue('password', 'password-err', '', 'empty', 'Empty field detected', '')">
            <i class="ri-eye-close-line" id="toggle-password-visibility"></i>
        </div>
        <b id="password-err"></b>
    <!-- WhatsApp Floating Icon -->
    <a href="https://wa.me/08158301646" target="_blank" class="whatsapp-icon">
        <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp">
    </a>

<script>
    const passwordInput = document.getElementById('password');
const togglePasswordVisibilityIcon = document.getElementById('toggle-password-visibility');

togglePasswordVisibilityIcon.addEventListener('click', () => {
  if (passwordInput.type === 'password') {
    passwordInput.type = 'text';
    togglePasswordVisibilityIcon.className = 'ri-eye-line';
  } else {
    passwordInput.type = 'password';
    togglePasswordVisibilityIcon.className = 'ri-eye-close-line';
  }
});


</script>

    
    <div class="link">
      <span style="text-align: right;"><a href="forgot-password.php"style="color: #5e1d3d; text-decoration: none;">forgot password?</a></span>
    </div>
    
    <button type="submit" id="submitBtn">LOG IN <i class="fas fa-chevron-right"></i></button>
    <div class="link">
      <span>Don't have an account <a href="signup.php"style="color: #5e1d3d; text-decoration: none;">Signup?</a></span>
    </div><br>
     <div class="link">
     <span style="text-align: right; color: #333;">
    <a href="#" style="color: #5e1d3d; text-decoration: none; transition: color 0.3s ease-in-out;" 
       onmouseover="this.style.color='black';" 
       onmouseout="this.style.color='#5e1d3d';">
       Create Business Account
    </a>
</span>
    </div>
  </form>
  
  
  
  <script>
  <?php include "js/msg.js"; ?>
    const logInForm = document.getElementById("log-in-form");
    const submitBtn = document.getElementById("submitBtn");
    
    const email_or_phone = document.getElementById("emailOrphone");
    const password = document.getElementById("password");
    logInForm.addEventListener("submit", (e)=> {
      e.preventDefault();
      if(email_or_phone.value == "" || password.value == ""){
        email_or_phone.dispatchEvent(new Event("input"));
        password.dispatchEvent(new Event("input"));
        showMessage("bi bi-exclamation-circle", "All fields are required", "err");
      }else{
        showP(submitBtn);
        fetch("server/login.php", {
          method: "POST",
          body: new FormData(logInForm),
        })
        .then(response => response.json())
        .then(data => {
          removeP(submitBtn, 'Login');
          if(data.status == true){
            showMessage("ri-checkbox-circle-line", "Login successful", "suc");
            setTimeout(()=> {
              window.location = "pin.php";
            }, 2000);
          }else if(data.status == "authentication"){
            showMessage("ri-checkbox-circle-line", data.message, "suc");
            setTimeout(()=> {
              window.location = "authentication.php";
            }, 2000);
          }else{
            showMessage("ri-close-circle-line", data.message, "err");
          }
        })
      }
    });
    function toggPass(thisId){
      if(thisId.checked){
        password.type = "text";
        confirmPassword.type = "text";
      }else{
        password.type = "password";
        confirmPassword.type = "password";
      }
    }
  </script>
  <script>
        if ('serviceWorker' in navigator) {
          window.addEventListener('load', function() {
            navigator.serviceWorker.register('service-worker.js').then(function(registration) {
              console.log('ServiceWorker registration successful with scope: ', registration.scope);
              //showMessage("bi bi-check-circle", "Service worker regstration successful", "suc");
            }, function(err) {
              console.log('ServiceWorker registration failed: ', err);
              showMessage("bi bi-info-circle", "Service worker regstration failed", "err");
            });
          });
        }
        
        let deferredPrompt;
        window.addEventListener('beforeinstallprompt', (e) => {
          e.preventDefault();
          deferredPrompt = e;
          showMessage("bi bi-check-circle", "Do you want to install our app", "suc", "", doInstall);
        });
        
        function doInstall(){
          deferredPrompt.prompt();
          deferredPrompt.userChoice.then((choiceResult) => {
            if (choiceResult.outcome === 'accepted') {
              console.log('User accepted the PWA installation');
              //showMessage("bi bi-check-circle", "User accepted the PWA installation", "suc");
            } else {
              console.log('User dismissed the PWA installation');
              //showMessage("bi bi-info-circle", "User dismissed the PWA installation", "err");
            }
            deferredPrompt = null;
          });
        }
        
        function askNotificationPermission() {
          if ('Notification' in window) {
            Notification.requestPermission().then(permission => {
              if (permission === 'granted') {
                console.log('Notification permission granted.');
              } else {
                console.log('Notification permission denied.');
              }
            });
          }
        }
        askNotificationPermission()
  </script>
 </body>
</html>

