  <div class="form-f no" id="r-c-pin" onclick="showForm('r-c-pin', 'close', 'none', 250)">
    <form class="form" id="reset-form" onclick="event.stopPropagation()">
      <div class="f-head">
        <button type="button" onclick="showForm('r-c-pin', 'close', 'none', 250)"><i class="fas fa-times"></i> close</button>
        <span>Reset Transaction PIN</span>
      </div>
      
      <div class="f-txt green" id="put-msg"></div>
      
      <input type="text" name="type" value="pin" hidden>
      
      <input type="email" name="email" value="<?php echo $user["email"]; ?>" hidden>
      
      <div class="inputs">
        <span>Enter OTP Code</span>
        <input type="tel" class="i-input" name="otp-code" id="otp-code" placeholder="123478" maxlength="6" oninput="checkValue('otp-code', 'otp-code-err', 6, 'length', 'Invalid OTP code required(4 Digits)', '')">
        <b id="otp-code-err"></b>
      </div>
      
      <div class="inputs">
        <span>New PIN</span>
        <input type="tel" class="normal-i" name="r-new-pin" id="r-new-pin" placeholder="1234" maxlength="4" oninput="checkValue('r-new-pin', 'r-new-pin-err', 4, 'length', 'Invalid PIN required(4 Digits)', '')">
        <b id="r-new-pin-err"></b>
      </div>
      
      <div class="inputs">
        <span>Confirm PIN</span>
        <input type="tel" class="normal-i" name="r-confirm-pin" id="r-confirm-pin" placeholder="1234" maxlength="4" oninput="checkValue('r-confirm-pin', 'r-confirm-pin-err', document.getElementById('r-new-pin').value, 'not equal', 'Comfirm pin does not match new pin', '')">
        <b id="r-confirm-pin-err"></b>
      </div>
      
      <button type="button" class="f-s-btn" onclick="resetPin(this)">SUBMIT</button>
    </form>
  </div>
  <script>
    const otp_code = document.getElementById("otp-code");
    const r_new_pin = document.getElementById("r-new-pin");
    const c_new_pin = document.getElementById("r-confirm-pin");
    const reset_form = document.getElementById("reset-form");
    let sent = false;
    
    function resetPin(thisB){
      let formerTxt = thisB.innerHTML;
      if(otp_code.value.length < 6 || r_new_pin.value.length < 4 || r_new_pin.value.length > 4 || c_new_pin.value !== r_new_pin.value){
        otp_code.dispatchEvent(new Event("input"));
        r_new_pin.dispatchEvent(new Event("input"));
        c_new_pin.dispatchEvent(new Event("input"));
      }else{
        showP(thisB);
        fetch("server/reset-pin.php", {
          method: "POST",
          body: new FormData(reset_form),
        })
        .then(response => response.text())
        .then(data => {
          removeP(thisB, formerTxt);
          if(data.includes("success")){
            showMessage("bi bi-check2-circle", data, "suc");
            showForm('r-c-pin', 'close', 'none', 250)
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        })
      }
    }
    
        function sendMail(){
            fetch("server/send-reset-otp.php", {
                method: "POST",
                body: new FormData(reset_form),
            })
            .then(response => response.text())
            .then(data => {
              showMessage("bi bi-check-circle", data, "err");
              const pMsg = getId("put-msg");
              if(data.includes("INBOX")){
                  pMsg.innerHTML = data;
                  pMsg.classList.remove("red");
                  pMsg.classList.add("green");
              }else{
                  pMsg.innerHTML = data;
                  pMsg.classList.remove("green");
                  pMsg.classList.add("red");
              }
            })
        }
  </script>