import React, { useState, useEffect } from 'react'
import { Link, Navigate } from 'react-router-dom'
import showMessage from './showMessage'
import '../css/home.css'


function Home(){
  const user_get = sessionStorage.getItem("user");
  const user = JSON.parse(user_get);
  const [trans, setTrans] = useState([]);
  
 useEffect(() => {
  const transactions = sessionStorage.getItem("transactions");
  if(!transactions){
    fetch("http://localhost:7070/vtu-app/src/server/transactions.php", {
      method: "POST",
      body: JSON.stringify({
        user_id: user.unique_id,
        limit: 3,
      }),
      headers: {
        "Content-Type": "application/json",
      },
    })
    .then(response => response.json())
    .then(data => {
      if(data.status == true){
        setTrans(data.transactions);
        sessionStorage.setItem("transactions", JSON.stringify(data.transactions));
      }else{
        showMessage("error", data.msg);
      }
    })
    .catch(err => showMessage("error", "Unable to fetch transactions"));
  }else{
    setTrans(JSON.parse(transactions));
  }
 }, [user.unique_id]);
  
  const handleEye = () => {
    const eye = document.getElementById("eye");
    const balance = document.getElementById("balance");
    
    if(eye.className == "bi bi-eye"){
      eye.className = "bi bi-eye-slash";
      balance.innerText = "NGN XXXXXXX";
    }else{
      eye.className = "bi bi-eye";
      balance.innerText = user.format_balance;
    }
  }
  
 useEffect(() => {
    const slider = document.querySelector(".slider");
    const slides = document.querySelectorAll(".slider .slide");
    let currentIndex = 0;

    const slideInterval = setInterval(() => {
      currentIndex = (currentIndex + 1) % slides.length;
      slider.scrollTo({
        left: slides[currentIndex].offsetLeft,
        behavior: 'smooth'
      });
    }, 5000);

    return () => clearInterval(slideInterval);
  }, []);
  
  
  return (
    <>
    <div className="topic">
      <span>Good Evening, {user.fname}</span>
      <button>NGN <i className="bi bi-chevron-down no"></i></button>
    </div>
    
    <div className="dashboard">
      <div className="d-left">
        <span>Wallet Balance <i className="bi bi-eye" id="eye" onClick={handleEye}></i></span>
        <b id="balance">{user.format_balance}</b>
      </div>
      <Link to="/dashboard/fund-wallet"><div className="d-right">
        <i className="bi bi-plus-circle-fill"></i>
        <span>Add Money</span>
      </div></Link>
      
      <div className="acc seperate">
        9Payment Service Bank || 0055504790
        <i className="bi bi-copy no"></i>
      </div>
    </div>
    
    <div className="slider">
       <div className="slide">
         <b>Get Airtime at 1% Off</b>
         <Link to="/airtime"><button>Buy Now</button></Link>
       </div>
       <div className="slide">
         <b>Not yet complete account verification</b>
         <Link to="/account-verification"><button>Complete</button></Link>
       </div>
       <div className="slide">
         <b>Need access to settings</b>
         <Link to="/settings"><button>Open Here</button></Link>
       </div>
       <div className="slide">
         <b>Having problem finding all services</b>
         <Link to="/dashboard/services"><button>View Here</button></Link>
       </div>
    </div>
    
    <div className="grids">
      
      <div className="service plus">
        <b className="s-topic">Quick Action</b>
        
        <div className="s-grid">
          <Link to="/airtime">
          <div className="s-service-box">
            <i className="ri ri-phone-line blue"></i>
            <span>Airtime</span>
          </div>
          </Link>
          <Link to="/data">
          <div className="s-service-box">
            <i className="ri ri-smartphone-line orange"></i>
            <span>Data</span>
          </div>
          </Link>
          <Link to="/cable-tv">
          <div className="s-service-box">
            <i className="ri ri-tv-line"></i>
            <span>Cable Tv</span>
          </div>
          </Link>
          <Link to="/referral">
          <div className="s-service-box">
            <i className="ri ri-group-line"></i>
            <span>Referrals</span>
          </div>
          </Link>
          <Link to="/dashboard/services">
          <div className="s-service-box">
            <i className="bi bi-grid green"></i>
            <span>All Services</span>
          </div>
          </Link>
        </div>
      </div>
      
      
      <div className="transaction">
        <div className="t-topic">Recent Transactions <button>see all</button></div>
        {trans.length > 0 ? (
        trans.slice(-4).map(newT => {
            let iconClass = "";
            if(newT.type.includes("Airtime")){
              iconClass = "bi bi-telephone";
            }else if(newT.type.includes("Data")){
              iconClass = "bi bi-phone";
            }else if(newT.type.includes("Wallet Topup")){
              iconClass = "bi bi-bank";
            }else if(newT.type.includes("Cable Tv")){
              iconClass = "bi bi-tv";
            }else if(newT.type.includes("Electricity")){
              iconClass = "bi bi-bulb";
            }
        
            return (
             <Link to={`/receipt?ref=${newT.reference}`}><div key={newT.id} className="transaction-box">
               <i className={iconClass}></i>
               <div className="t-left">
                 <span>{newT.type}</span>
                 <b>{newT.description}</b>
               </div>
               <div className="t-right">
                 <b className={newT.status}>{newT.status}</b>
                 <span>NGN {parseInt(newT.amount).toLocaleString()}</span>
                 <small>{newT.date}</small>
               </div>
             </div></Link>
            );
          })
        ) : (
         <div className="empty-box">
           <i className="bi bi-info-circle"></i>
           <span>No transaction made yet make a transaction to be able to view transactions</span>
         </div>
        )}
      </div>
    </div>
    </>
  );
}

export default Home;