<?php
session_start();
include_once "conn.php";
require "controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$site = Control::site($conn, $user_id);

// Fetch only Paga account
$sql = $conn->prepare("SELECT * FROM account WHERE unique_id = ? AND bank_name = 'PAGA' ORDER BY id DESC LIMIT 1");
$sql->bind_param("s", $user_id);
$sql->execute();
$result = $sql->get_result();
$paga_account = $result->fetch_assoc();
?>


<head>
    <style>
    <?php include "css/home.css"; ?>
    </div>

<head>
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
    <style>
        /* General Styles */
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f7fa;
            overflow-x: hidden;
        }
        .total-outstanding {
            transition: all 0.3s ease-in-out;
            padding: 17px;
            border-radius: 15px;
            background: #5e1d3d;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
        }
        

        /* Cards and Hover Effects */
        .services-body {
            transition: all 0.3s ease-in-out;
            padding: 17px;
            border-radius: 15px;
            background: #ffffff;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
        }
        .advert {
            transition: all 0.3s ease-in-out;
            padding: 15px;
            border-radius: 15px;
            background: #ffffff;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
            
        }

        .total-outstanding:hover, .services-body:hover, .advert:hover {
            transform: translateY(-5px);
            box-shadow: 0px 6px 12px rgba(0, 0, 0, 0.2);
        }

        /* Button Hover Effects */
        .repay-btn, .service {
            transition: 0.3s ease-in-out;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 15px;
            border-radius: 8px;
            font-weight: bold;
            cursor: pointer;
            border: none;
        }

        .repay-btn:hover {
            background-color: #5e1d3d;
            color: white;
        }

        .repay-btn:hover {
            transform: scale(1.05);
            background-color: #ffc000;
        }

        /* Icon Animations */
        .services-body i {
            font-size: 24px;
            transition: 0.3s;
        }

        .services-body i:hover {
            transform: scale(1.2);
        }

        /* Account Balance Animation */
        #balance {
            display: inline-block;
            animation: bounce 2s infinite;
        }

        @keyframes bounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        /* Advert Image Styling */
        .advert img {
            width: 90px;
            height: 115px;
            border-radius: 15px;
            cursor: pointer;
            transition: transform 0.3s;
            margin-top: 0px;
        }

        .advert img:hover {
            transform: scale(1.05);
        }
      
        .advert img:hover {
            transform: scale(1.05);
        }

        /* Service Buttons */
        .service {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            padding: 10px;
            background-color: #f4f7fa;
            border-radius: 8px;
            color: #5e1d3d;
            text-decoration: none;
            font-size: 10px;
           
        }

        .service:hover {
            background-color: #ffc000;
            color: white;
        }

        /* Transaction History Link */
        .details {
            display: block;
            font-size: 0.8em;
            color: white;
            margin-top: 10px;
            text-decoration: none;
        }

        /* Slider Animation */
        .advert.slider {
            position: relative;
            width: 100%;
            max-width: 600px;
            overflow: hidden;
        }

        .advert.slider img {
            width: 110%;
            display: flex;
            animation: slide 5s infinite;
        }

        @keyframes slide {
            0% { transform: translateX(0); }
            25% { transform: translateX(-100%); }
            50% { transform: translateX(-100%); }
            75% { transform: translateX(0); }
            100% { transform: translateX(0); }
        }
        
        .service-card {
    background: #f4f7fa;
    border-radius: 15px;
    padding: 10px;
    box-shadow: 0 1px 5px rgba(0, 0, 0, 0.1);
    display: flex;
    flex-direction: column;
    align-items: center;
}
.user-topic {
    width: 100%;
    text-align: center;
    margin-bottom: 10px;
}

@keyframes bounce {
    0%, 100% {
        transform: translateY(0);
    }
    50% {
        transform: translateY(-5px);
    }
}

.details {
    display: inline-flex;
    align-items: center;
    text-decoration: none;
    font-size: 12px; /* Small text */
    font-weight: bold; /* Bold text */
    color: #fff !important; /* White text */
    padding: 3px 0;
    transition: color 0.3s ease-in-out;
    animation: bounce 1s infinite ease-in-out; /* Continuous bouncing */
}

.details:hover {
    color: #ddd !important; /* Slightly dimmed white on hover */
}

.details i {
    margin-left: 5px; /* Adjust spacing for smaller size */
    font-size: 10px; /* Make icon smaller */
    transition: transform 0.3s ease-in-out;
}

.details:hover i {
    transform: translateX(3px); /* Slight movement on hover */
}

@keyframes fadeSlideIn {
  from {
    opacity: 0;
    transform: translateY(20px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

.services-body {
  animation: fadeSlideIn 0.8s ease-out;
}
.button-container {
    display: flex;
    justify-content: space-between; /* Spreads buttons evenly */
    gap: 15px; /* Space between buttons */
    margin-top: 15px; /* Space above the buttons */
}

.repay-btn {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 15px;
    font-size: 16px;
    cursor: pointer;
    border-radius: 5px;
    display: flex;
    align-items: center;
    gap: 8px; /* Space between icon and text */
    flex: 1; /* Makes all buttons equal width */
    text-align: center;
    justify-content: center;
}

.repay-btn i {
    font-size: 18px;
}

.repay-btn:hover {
    background-color: #0056b3;
}

.whatsapp-button {
    position: fixed;
    top: 405px; /* Adjust as needed */
    right: 20px;
    background-color: #5e1d3d;
    color: white;
    font-size: 24px;
    width: 50px;
    height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
    text-decoration: none;
    transition: transform 0.2s ease-in-out;
}

.whatsapp-button:hover {
    transform: scale(1.1);
}

.whatsapp-button i {
    font-size: 28px;
}
.dashboard-card {
    background: #5e1d3d;
    border-radius: 20px;
    padding: 5px;
    box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
    text-align: center;
    width: 100%;
    max-width: 400px;
    height: 140px; /* Fixed height */
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    align-items: center;
    overflow: hidden;
}

/* Header Styling */
.card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 12px;
    font-weight: bold;
    color: white;
    width: 100%;
    padding: 0 10px;
}

/* Balance Amount */
.balance-amount {
    font-size: 20px;
    font-weight: bold;
    color: #ffffff;
    margin-top: -40px;
    
}

/* Transaction Link */
.transaction-link {
    color: #ffffff;
    text-decoration: none;
    font-size: 10px;
    
    font-weight: bold;
   
}

.transaction-link:hover {
    text-decoration: underline;
}

/* Button Container */
.button-container {
    display: flex;
    justify-content: center;
    align-items: center;
    width: 90%;
    gap: 10px; /* Reduce space between buttons */,
    
    
}



/* Action Buttons */
.action-btn {
    background: #007bff;
    color: #5e1d3d;
    border: none;
    padding: 4px 6px;
    border-radius: 15px;
    font-size: 11px;
    font-weight: bold;
    cursor: pointer;
    transition: 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 2px;
    flex: 1; /* Makes buttons equal width */
    margin-top: -70px;
    max-width: 50%;
    height: 40px; /* Adjust heighth */
}

/* Button Icon */
.action-btn i {
    font-size: 15px;
    font-weight: bold;
}

/* Different Button Colors */
.fund-btn {
    background: #f4f7fa; /* Green */
}

.withdraw-btn {
    background: #f4f7fa; /* Red */
}

.Add-btn {
    background: #f4f7fa; /* Red */
}

.action-btn:hover {
    opacity: 5;
}

.add-account-btn {
    background: #f4f7fa; /* Orange */
    color: #5e1d3d;
}

.add-account-btn:hover {
    opacity: 0.8;
}
/* Center Balance Header & Eye Icon */
/* Center Balance Header */

/* Eye Icon */
.toggle-eye {
    cursor: pointer;
    font-size: 22px;
    color: #fffff; /* White color */
    transition: 0.3s;
}

.toggle-eye:hover {
    color: #ffffff;
}
.action-btn {
    font-family: 'Poppins', sans-serif;
    font-size: 10px;
    font-weight: bold;
}
.span {
    font-family: 'Poppins', sans-serif;
    font-size: 10px;
    font-weight: bold;
   margin-bottom: 55px;
}

.service span {
    font-family: 'Poppins', sans-serif;
    font-size: 10px;
    font-weight: bold;
  
}

.wallet-box {      
        width: 100%;      
        max-width: 350px;      
        background: #5e1d3d;      
        color: #5e1d3d;      
        border-radius: 20px;      
        padding: 20px;      
        box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);      
        display: flex;      
        flex-direction: column;      
        align-items: center;      
        margin-bottom: 15px;
        height: 130px;
    }      
  
    .balance-section {      
        width: 100%;      
        display: flex;      
        justify-content: space-between;      
        align-items: center;      
        margin-bottom: 15px;      
    }      
  
    .balance-text {      
        font-size: clamp(11px, 2.5vw, 13px);      
        font-weight: bold;      
        display: flex;      
        align-items: center;      
        color: #f4f7fa;   
         font-family: 'Poppins', sans-serif;  
    }      
  
    .eye-icon {    
      
        cursor: pointer;      
        font-size: clamp(10px, 2.5vw, 13px);      
        margin-left: 5px;      
        color: #f4f7fa;      
    }      
  
    .balance-amount {      
        font-size: clamp(20px, 3vw, 16px);      
        font-weight: bold;      
        margin-top: 7px;      
        color: #f4f7fa;
       font-family: Arial, Helvetica, sans-serif;
    }      
  
    .bank-status {      
        text-align: right;      
        color: white;      
        font-size: clamp(12px, 2.5vw, 14px);
    }      
  
    .bank-status span {      
        font-size: clamp(12px, 2.5vw, 14px);      
        color: red;      
    }      
  
    .button-group {      
        width: 100%;      
        display: flex;      
        justify-content: space-between;      
        margin-top: -8px;      
        gap: 10px;
    }      
  
    .button {      
        width: 33.33%;      
        background: #ffffff;      
        border-radius: 14px;     
        padding: 12px 8px;      
        text-align: center;      
        color: #5e1d3d;      
        font-size: clamp(10px, 1.8vw, 10px); 
        cursor: pointer;      
        display: flex;      
        align-items: center;      
        justify-content: center;      
        box-shadow: 0px 2px 5px rgba(255, 255, 255, 0.1);      
        text-decoration: none;
        font-weight: 900;
        font-family: 'Poppins', sans-serif;
        height: 35px;
    }      
  
    .button i {      
        font-size: clamp(12px, 2.5vw, 14px);      
        color: #5e1d3d;      
        margin-right: 5px;  
            font-family: 'Poppins', sans-serif;
    }

    .account-info {
        width: 100%;
        background: #333;
        border-radius: 8px;
        padding: 10px;
        margin-top: 15px;
        color: white;
    }

    .account-info .acc-detail {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .account-info .a-d-icon {
        font-size: clamp(16px, 3.5vw, 20px);
        color: #5e1d3d;
    }

    .account-info .a-d-bank {
        display: block;
        font-size: clamp(12px, 2.5vw, 14px);
    }

    .account-info .a-d-no {
        display: block;
        font-size: clamp(10px, 2.2vw, 12px);
        color: #ffc000;
    }

    .account-info .a-d-no-small {
        display: block;
        font-size: clamp(9px, 2vw, 10px);
        color: #999;
    }
   .home-grid {
        width: 100%;
        max-width: 350px;
    }


    .user-topic {
        margin-bottom: 15px;
        font-weight: bold;
        font-size: clamp(12px, 2.5vw, 14px);
    }

    .v-all {
        text-align: center;
        margin-top: 15px;
    }

    .v-all button {
        background: #000;
        color: #5e1d3d;
        border: none;
        padding: clamp(6px, 1.8vw, 8px) clamp(15px, 3vw, 20px);
        border-radius: 5px;
        cursor: pointer;
        font-size: clamp(11px, 2.3vw, 13px);
    }

    /* Ripple animation */
    .ripple {
        position: absolute;
        border-radius: 50%;
        transform: scale(0);
        animation: ripple 0.6s linear;
        background-color: rgba(255, 255, 255, 0.7);
    }

    @keyframes ripple {
        to {
            transform: scale(4);
            opacity: 0;
        }
    }

    /* Make sure icons stay properly sized */
    .bi, .fa, .fas {
        font-size: inherit;
    }
    
    .generate-btn {
    display: inline-block;
    padding: 8px 16px;
    background-color: #ffffff;
    color: #5e1d3d;
    text-decoration: none;
    border-radius: 20px;
    margin-top: 8px;
    font-size: 14px;
}

.paga-account {
        text-align: right;
        font-size: clamp(11px, 2.2vw, 12px);
        color: #ffffff;
        display: flex;
        flex-direction: column;
        align-items: flex-end;
        font-size: 10px;
    }

    .paga-account .acc-no {
    font-size: clamp(12px, 20vw, 12px);
        color: #ffffff;
        margin-top: 2px;
        display: flex;
        align-items: center;
        gap: 5px;
        font-family: 'Poppins', sans-serif;
        font-weight: 900;
    }

    .paga-account .copy-icon {
        cursor: pointer;
        font-size: clamp(20px, 20vw, 20px);
        color: #ffffff;
    }
    /* Slider Styles */
    

.generate-btn:hover {
    background-color: #ffffff;
}

    /* Ensure proper spacing in very small screens */
    @media (max-width: 280px) {
        body {
            padding: 5px;
        }

        .wallet-box {
            padding: 15px;
        }

        .button-group {
            gap: 5px;
        }

        .button {
            padding: 8px 4px;
        }
        .user-topic {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px;
    background-color: #5e1d3d;
    border-radius: 16px;
}

.user-topic span {
    width: 10px;
    height: 10px;
    background-color: #5e1d3d; /* Change to desired color */
    border-radius: 50%;
}

        
    </style>
</head>
<body>

<div class="wallet-box pt-0">      
        <div class="balance-section"> 
            <div>      
                <span class="balance-text">      
                    Total Balance <i class="fa fa-eye eye-icon" onclick="toggleEye(this, 'balance')"></i>      
                </span>      
                <div class="balance-amount" id="balance"><?php echo $user["format_balance"]; ?></div>      
            </div>     
             
            <?php if ($paga_account): ?>
            <div class="paga-account">      
            
                <?php echo $paga_account[""]; ?>Paga Bank
                <div class="acc-no">
                    <?php echo $paga_account["acc_no"]; ?>
                    
                    <i class="bi bi-copy copy-icon" onclick="copyTxt('<?php echo $paga_account["acc_no"]; ?>')"></i>
                </div>
            </div>
            
            <?php else: ?>
            <div class="paga-account">Paga Bank
                
                <a href="generate-account.php" class="generate-btn">Generate Account</a>
            </div>
            <?php endif; ?>     
        </div>      

        <div class="button-group">      
            <a href="user2user.php" class="button">      
                <i class="bi bi-person-circle"></i>To User    
            </a>      
            <a href="setting.php" class="button">      
                <i class="bi bi-gear"></i>setting      
            </a>            
            <a href="transactions.php" class="button">      
                <i class="bi bi-wallet2"></i>Transaction      
            </a>      
        </div>
    </div> 


  <a href="https://wa.me/08158301646" target="_blank" class="whatsapp-button">
  <i class="ri-whatsapp-fill"></i>
</a>

<div class="services-body">
    <a href="airtime.php" class="service">
        <i class="fa fa-mobile-alt"style="background-color: #5e1d3d;"></i>
        <span>Airtime</span>
    </a>
    <a href="airtime-pin.php" class="service">
        <i class="fas fa-print"style="background-color: #5e1d3d;"></i>
        <span>Recherge</span>
    </a>
    <a href="data.php" class="service">
        <i class="fa fa-wifi"style="background-color: #5e1d3d;"></i>
        <span>Data</span>
    </a>
    <a href="cable.php" class="service">
        <i class="bi bi-tv-fill"style="background-color: #5e1d3d;"></i>
        <span>CableTV</span>
    </a>
</div>
<div class="services-body">
    
    <a href="bulk-sms.php" class="service">
        <i class="bi bi-chat-dots"style="background-color: #5e1d3d;"></i>
        <span>BulkSms</span>
    </a>
    <a href="betting.php" class="service">
        <i class="fa fa-gamepad"style="background-color: #5e1d3d;"></i>
        <span>Betting</span>
    </a>
    <a href="electricity.php" class="service">
        <i class="fa fa-plug"style="background-color: #5e1d3d;"></i>
        <span>Electricity</span>
    </a>
    <a href="service.php" class="service">
        <i class="fa fa-qrcode"style="background-color: #5e1d3d;"></i>
        <span>More</span>
    </a>
</div>


<div class="advert slider">
    <img onclick="window.location.href='service.php';" src="logos/121.jpg">
    </a>
    <img onclick="window.location.href='betting.php';" src="logos/122.jpg">
</div>

<!-- JavaScript for Eye Toggle -->
<script>
    function toggleEye(icon, type) {
        const balance = document.getElementById(type);

        icon.classList.toggle('ri-eye-line');
        icon.classList.toggle('ri-eye-close-line');

        balance.style.visibility = balance.getAttribute('data-visible') === 'false' ? 'visible' : 'hidden';
        balance.setAttribute('data-visible', balance.style.visibility === 'visible');
    }
     // Hide Loader After Page Loads
        document.addEventListener("DOMContentLoaded", function() {
            setTimeout(() => {
                document.getElementById("loader").style.display = "none";
            }, 1000);
        });

        
</script>

 <div class="user-topic">
      <span></span>
    </div>
    <?php 
     $limit = "LIMIT 4";
     include "transaction-show.php";
    ?>
</div>
  
<br><br><br>