<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
   <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Bank Accounts</title>
  <style>
     @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    .acc-detail{
        display: flex; 
        align-items: center; 
        min-height: 70px; 
        background: #fff; 
        border-radius: 5px;
        box-sizing: border-box;
        width: 100%; 
        padding: 10px;
        margin: 0;
        margin-top: 10px;
        box-shadow: 0 1px 1px 0 #0002;
    }
    .a-d-icon{
        display: flex;
        height: 30px;
        width: 30px;
        background: transparent; 
        border-radius: 50%; 
        border: none; 
        justify-content: center; 
        align-items: center; 
        color: var(--site-clr);
        margin-right: 10px;
        box-sizing: border-box;
    }
    .a-d-bank{
        display: block;
        font-size: 10px;
        font-weight: 300;
        margin: 0;
        color: #555;
        margin-bottom: 6px;
        line-height: 13px;
    }
    .a-d-bank b{
        font-weight: 900;
        color: #000;
    }
    .a-d-no{
        display:block; 
        font-size: 11px;
        font-weight: 900;
        color: #000;
        margin: 0;
        margin-bottom: 6px;
        letter-spacing: 0.4px;
    }
    .a-d-no i{
        font-size: 14px;
        color: var(--site-clr);
        margin-left: 12px;
    }
    .a-d-no-small{
        display:block; 
        font-size: 7px;
        font-weight: 300;
        margin: 0;
        letter-spacing: 0.4;
    }
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Bank Accounts</span>
    <a href="dashboard.php" style="text-decoration: none; color: #333"><i class="ri-home-smile-2-line"></i></a>
  </div>
  <pre>
  </pre>
      <?php
        $sql = $conn->prepare("SELECT * FROM account WHERE unique_id = ? ORDER BY id DESC");
        $sql->bind_param("s", $user_id);
        $sql->execute();
        $res = $sql->get_result();
        $count = 0; 
        if($res->num_rows > 0){
            while($row = $res->fetch_assoc()){
                $count++;
                echo '
                   <div class="acc-detail"> 
                         <i class="bi bi-bank a-d-icon"></i>
                         <div>
                           <b class="a-d-bank">'.$row["bank_name"].' - <b>'.$row["acc_name"].'</b></b>
                           <span class="a-d-no">'.$row["acc_no"].' <i class="bi bi-copy" onclick="copyTxt('.$row["acc_no"].')"></i></span>
                           <span class="a-d-no-small">'.$row["bank_name"].' charges 0.5% on every deposit</span>
                         </div>
                   </div>
                ';
            }
        }else{
            echo '
              <div class="empty">
                <i class="bi bi-info-circle"></i>
                <b>No account generated yet</b>
              </di>
            ';
        }
      ?>
  
  
  <div class="g-box">
    <button onclick="showGenerate('show')">GENERATE ACCOUNT</button>
  </div>
  
  <div class="acc-bx" id="acc-bx">
    <form id="acc-form">
      <div class="topic">
        <button type="button" onclick="showGenerate('close')">
          <i class="fas fa-times"></i>
          close
        </button>
        <span>Generate Account</span>
      </div>
      
      <select name="account" id="account" onchange="checkValue('account', 'account-err', '', 'empty', 'Select bank', '')" hidden>
        <option value="">Select Account</option>
        <option value="000023">Providus Bank</option>
        <option value="120001" disabled>9 Payment Service Bank</option>
        <option value="090529">Bakly Bank</option>
        <option value="100003">Paga Bank</option>
        <option value="090286">Safe Haven MFB</option>
      </select>
      
      <div class="inputs" id="account:inputs">
        <span>Select Account</span>
        <div class="drop-btn" id="account:1" onclick="addActive(this, 'account-detail')"> 
         <span>-- Select Account --</span>
         <i class="fas fa-chevron-down" id="i"></i>
        </div>
        
        <div class="drop-detail three" id="account-detail">
           <div class="drop-detail-divs account" onclick="removeDrop('account', '120001', this, 'drop-detail-divs.account', 'account:1')" style="display: none;">
             <i class="fas fa-university"></i>
             <span>9 Payment Service Bank</span>
         
           
           
            
           
            </div>
           <div class="drop-detail-divs account" onclick="removeDrop('account', '090529', this, 'drop-detail-divs.account', 'account:1')">
             <i class="fas fa-university"></i>
             <span>Nombank MFB</span>
           </div>
           <div class="drop-detail-divs account" onclick="removeDrop('account', '100003', this, 'drop-detail-divs.account', 'account:1')">
             <i class="fas fa-university"></i>
             <span>Paga Bank</span>
           
             
           
        </div>
        <b id="account-err"></b>
    </div>
      
      <button type="button" class="button" onclick="generate(this)">GENERATE</button>
    </form>
  </div>
  <script>
    <?php include "js/msg.js"; ?>
    const acc_bx = document.getElementById("acc-bx");
    function showGenerate(typeOf){
        acc_bx.classList.toggle("show");
    }
    
    const form = document.getElementById("acc-form");
    const account = document.getElementById("account");
    function generate(thisBtn){
      let formerTxt = thisBtn.innerText;
      if(account.value == ""){
        account.dispatchEvent(new Event("change"));
      }else{
        showP(thisBtn);
        fetch("server/generate-account.php", {
          method: "POST",
          body: new FormData(form),
        })
        .then(response => response.text())
        .then(data => {
          removeP(thisBtn, formerTxt);
          if(data.includes("success")){
              showMessage("bi bi-check-circle", data, "suc");
              showGenerate('close');
              window.location.reload();
          }else{
              showMessage("bi bi-exclamation-circle", data, "err");
          }
        })
      }
    }
  </script>
</body>
</html>