<?php
session_start();
include_once "conn.php";
require "controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
?>
<style>
    .fund-btn active{
        display: flex; 
        align-items: center; 
        min-height: 70px; 
        background: #fff; 
        border-radius: 5px;
        box-sizing: border-box;
        width: 100%; 
        padding: 10px;
        margin: 0;
        margin-top: 10px;
        box-shadow: 0 1px 1px 0 #3333ff;
    }
    .a-d-icon{
        display: flex;
        height: 30px;
        width: 30px;
        background: transparent;  
        border-radius: 50%; 
        border: none; 
        justify-content: center; 
        align-items: center;
        color: var(--site-clr);
        margin-right: 10px;
        box-sizing: border-box;
    }
    .a-d-bank{ 
        display: block;
        font-size: 10px;
        font-weight: 300;
        margin: 0;
        color: #3333ff;
        margin-bottom: 6px;
        line-height: 13px;
    }
    .a-d-bank b{
        font-weight: 900;
        color: #3333ff;
    }
    .a-d-no{
        display:block; 
        font-size: 11px;
        font-weight: 900;
        color: #3333ff;
        margin: 0;
        margin-bottom: 6px;
        letter-spacing: 0.4px;
    }
    .a-d-no i{
        font-size: 14px;
        color: var(--site-clr);
        margin-left: 12px;
    }
    .a-d-no-small{
        display:block; 
        font-size: 7px;
        font-weight: 300;
        margin: 0;
        letter-spacing: 0.4;
    }
</style>

<div class="fund">
  
  
  <div class="fund-methods">
    <h2 class="top-txt">Select payment method to fund your account with</h2>
    <div class="fund-buttons">
      <button class="fund-btn active" onclick="toggleFund(this, 'paystack', '.fund-form', '.fund-btn',)">Manual Funding</button>
      <button class="fund-btn" onclick="toggleFund(this, 'generated', '.fund-form', '.fund-btn')">Automated Funding</button>
      <button class="fund-btn" onclick="toggleFund(this, 'link', '.fund-form', '.fund-btn')">Other Methods</button>
    </div>
    
    <div class="how">
      <div class="h-sep">
        <div>
          <b>Available Balance</b>
          <span><?php echo $user["format_balance"]; ?></span>
        </div>
        <div>
        
          <b>Ledger Balance</b>
          <span><?php echo $user["format_balance"]; ?></span>
        </div>
      </div>
      <h2 class="h-t">How would you like to add money to your account</h2>
    </div>
    <div class="fund-form sep" id="paystack">
      <button onclick="showForm('fxd-fm', 'open', 'flex')">
        FUND ONLINE
      </button>
      
      <div class="fixed-fund" id="fxd-fm">
        <form id="fund-form-amt">
          <div class="f-txt">
            <span>Fund Wallet</span>
            <i class="fas fa-times" id="cl-fm" onclick="showForm('fxd-fm', 'close', 'none')"></i>
          </div>
          <div class="inputs">
            <span>Amount</span>
            <input type="tel" name="amount" id="amount" placeholder="1000" oninput="checkValue('amount', 'amount-error', 100, 'value', 'Invalid amount minimum(NGN 100)', '')">
            <b id="amount-error"></b>
          </div>
          <button type="button" class="button" style="border: none; color: #fff;" onclick="fundPay(this, 'fund-form-amt')" onmousemove="createRipple(event, true, '')">FUND WALLET</button>
        </form>
      </div>
      
      <a href="generate-account.php"><button>
        CONNECTED BANKS
      </button></a>
      <a href="payment-link.php"><button>
        PAYMENT LINK
      </button></a>
    </div>
    
    <div class="fund-form no" id="generated" style="display: none; padding: 10px;">
      <?php
        $sql = $conn->prepare("SELECT * FROM account WHERE unique_id = ? ORDER BY id DESC");
        $sql->bind_param("s", $user_id);
        $sql->execute();
        $res = $sql->get_result();
        $count = 0; 
        if($res->num_rows > 0){
            while($row = $res->fetch_assoc()){
                $count++;
                echo '
                   <div class="acc-detail"> 
                         <i class="bi bi-bank a-d-icon"></i>
                         <div>
                           <b class="a-d-bank">'.$row["bank_name"].' - <b>'.$row["acc_name"].'</b></b>
                           <span class="a-d-no">'.$row["acc_no"].' <i class="bi bi-copy" onclick="copyTxt('.$row["acc_no"].')"></i></span>
                           <span class="a-d-no-small">'.$row["bank_name"].' charges 0.5% on every deposit</span>
                         </div>
                   </div>
                ';
            }
        }else{
            echo '
              <div class="empty">
                <i class="bi bi-info-circle"></i>
                <b>No account generated yet</b>
              </di>
            ';
        }
      ?>
    </div>
    
    <div class="help" id="nav:4">
      <i class="fas fa-question-circle" id="nav:4"></i>
      Need Help? Click Here
    </div>
  </div>
  
  
  
  
  <div class="fund-other">
    <div class="fund-option">
      <b>Reserved Account</b>
      <span>fund your account automatically with you generate bank name and account number.</span>
      <a href="generate-account.php"><button>View Accounts <i class="fas fa-share"></i></button></a>
    </div>
    
    <div class="fund-option">
      <b>Fund Manually</b>
      <span>fund your account manually with payment methods eg, paystack, flutter wave, monnify  .e.t.c.</span>
      <button onclick="showForm('fxd-fm', 'open', 'flex')">Fund Online <i class="fas fa-share"></i></button>
    </div>
    
    <div class="fund-option">
      <b>Payment Link</b>
      <span>Share your mBills payment link to others directly send money to you.</span>
      <a href="http://<?php echo $_SERVER["HTTP_HOST"]; ?>/app/pay-me.php?user=<?php echo $user["unique_id"]; ?>"><button>View Page <i class="fas fa-share"></i></button></a>
    </div>
    
    <div class="fund-option">
      <b>Bank Card Payment</b>
      <span>Fund your mBills wallet with your bank card using a payment method.</span>
      <button>Try It <i class="fas fa-share"></i></button>
      <div class="n-av">
        <i class="fas fa-question-circle"></i>
        Not available you will be notified when available we are working on it.
      </div>
    </div>
  </div>
  
<div class="fund-payment-link-body">
    <h2>Payment Link</h2>
    <div>
      <span><?php echo $_SERVER["HTTP_HOST"]; ?>/app/pay-me.php?user=<?php echo $user["unique_id"]; ?></span>
      <button onclick="copyTxt('<?php echo $_SERVER["HTTP_HOST"]; ?>/app/pay-me.php?user=<?php echo $user["unique_id"]; ?>')">copy link <i class="fas fa-copy"></i></button>
    </div>
  </div>
  
  <div class="recent-transaction">
    <div class="user-topic">
      <span>Recent Transactions</span>
      <a href="transactions.php"><button>view all</button></a>
    </div>
    <?php $limit = "LIMIT 3"; include "transaction-show.php"; ?>
    <div class="v-all">
      <a href="transactions.php"><button>view all <i class="fas fa-backspace"></i></button></a>
    </div>
  </div>
</div>