<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Airtime");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Login</title>
  <style>
    @font-face {
      font-family: 'Poppins';
      src: url('css/poppins/Poppins-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Fund Lock</span>
    <a href="logout.php" style="text-decoration: none; color: #333"><i class="fas fa-sign-out"></i></a>
  </div>
  
 <form class="lock-form" id="form">
  <div class="fund-lock-b" id="first-one">
    <div class="get-started">
      <h2>Get Started!</h2>
      <span>What are you saving for?</span>
    </div>
    
    <div class="inputs">
      <span>Lock name</span>
      <input type="text" name="lock-name" id="lock-name" oninput="checkValue('lock-name', 'lock-name-err', 3, 'length', 'Invalid lock name', '')">
      <div class="txts">Make this fun & creative (Eg: Detty December, Mum's Birthday, Girls Day Out)</div>
      <b id="lock-name-err"></b>
    </div>
    <div class="inputs">
      <span>Lock description(optional)</span>
      <input type="text" name="lock-desc" id="lock-desc">
      <div class="txts">A descriptive name make your plan memorable</div>
      <b id="lock-desc-err"></b>
    </div>
    
    <button class="smtBtn" type="button" onclick="checkV()">CONTINUE</button>
  </div>
  
  <div class="fund-lock-b none" id="second-one">
    <div class="moveB" onclick="moveR('second-one', 'first-one')">
      <i class="fas fa-chevron-left"></i>
      Back to previous
    </div>
    <div class="get-started">
      <h2>Good one!</h2>
      <span>Withdraw at any time, No time or goal restriction is applicable</span>
    </div>
    
    <div class="start-amt">
      <h2>Start Amount. (NGN)</h2>
      <span>You can add more later</span>
    </div>
    
    <div class="amt-btns">
      <button type="button" onclick="addValue('5000')">5,000</button>
      <button type="button" onclick="addValue('10000')">10,000</button>
      <button type="button" onclick="addValue('20000')">20,000</button>
      <button type="button" onclick="addValue('30000')">30,000</button>
      <button type="button" onclick="addValue('50000')">50,000</button>
      <button type="button" onclick="addValue('100000')">100,000</button>
    </div>
    
    <div class="inputs">
      <span>Amount</span>
      <input type="tel" name="amount" id="amount" oninput="checkValue('amount', 'amount-err', 500, 'value', 'Invalid amount minimum(NGN 500)', '')">
      <b id="amount-err"></b>
    </div>
    
    <button class="smtBtn" type="button" onclick="createLock(this)">CREATE LOCK</button>
  </div>
 </form>
 
 <script>
   <?php include "js/msg.js"; ?>
   function moveL(toL, toShow){
     document.getElementById(toL).classList.remove("show")
     document.getElementById(toL).classList.add("none")
     
     document.getElementById(toShow).classList.remove("none")
     document.getElementById(toShow).classList.add("show")
   }
   function moveR(toL, toShow){
     document.getElementById(toL).classList.remove("show")
     document.getElementById(toL).classList.add("none")
     
     document.getElementById(toShow).classList.remove("nome")
     document.getElementById(toShow).classList.add("show")
   }
   function addValue(valueAdd){
     document.getElementById("amount").value = valueAdd;
     document.getElementById("amount").dispatchEvent(new Event("input"));
   }
   
   const lock_name = document.getElementById("lock-name");
   const lock_desc = document.getElementById("lock-desc");
   const amount = document.getElementById("amount");
   
   const form = document.getElementById("form");
   
   function checkV(){
     if(lock_name.value.length < 3){
       lock_name.dispatchEvent(new Event("input"));
     }else{
       moveL('first-one', 'second-one');
     }
   }
   
   function createLock(thisBtn){
     let formerTxt = thisBtn.innerHTML;
     if(amount.value < 500){
       amount.dispatchEvent(new Event("input"));
     }else{
       showP(thisBtn);
       fetch("server/create-lock.php", {
         method: "POST",
         body: new FormData(form),
       })
       .then(response => response.text())
       .then(data => {
         alert(data);
         removeP(thisBtn, formerTxt)
       })
     }
   }
 </script>
 </body>
 </head>