<?php
session_start();
 include_once "server/conn.php";
 include "server/controller.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/log-sign.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Forgot Password</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    #toggle-password-visibility {
  position: absolute;
  right: 10px;
  top: 50%;
  transform: translateY(-50%);
  cursor: pointer;
  z-index: 1;
}


.password-container {
  position: relative;
}

#password {
  width: 100%;
  padding-right: 25px; /* add padding for icon */
  box-sizing: border-box;
}


body{
  font-family: 'Poppins', sans-serif;
  display: flex;
  align-items: center;
  justify-content: center;
  min-height: 92vh;
 background: #ffffff;
  background-size: cover;
  letter-spacing: 0px;
  flex-direction: column;
  user-select: none;
}
span, h1, h2, h3, h4, h5, h6, div, button, table, p, b, i, section, form, em, input, textarea{
  font-family: 'Poppins', sans-serif;
}
a{
  text-decoration: none;
}
button{  
  letter-spacing: 0px;
}
.box{
  padding: 20px;
  border-radius: 5px;
  width: 335px;
  box-sizing: border-box;
  margin-bottom: 20px;
  margin-top: 15px;
  box-shadow: none;
  background: transparent;
  /*box-shadow: 0 4px 7px 2px #0001;*/
}
.head-two{
  margin-bottom: 3px;
  text-align: center;
}
.head-two img{
  width: 100px;
  height: 50px;
  margin-bottom: 3px;
  margin-top: 3px;
 
}
.box .head{
  margin-bottom: 22px;
  text-align: center;
}
.box .head img{
  width: 100%;
  height: 100PX;
  object-fit:cover;
  margin-bottom: 10px;
  margin-top: 5px;
 
}
.box .head h2{
  font-size: 17px;
  margin-top: 0;
  margin-bottom: 6px;
  text-align: left;
  font-weight: 800;
  color:blue;
  text-align:center;
}
.box .inputs #check{
  color: rgba(0%, 70%, 0%);
  font-size: 15px;
  position: absolute;
  top: 41px;
  right: 7px;
  padding: 1px;
  background: #fff;
  border-radius: 50%;
}

.box .inputs #checkErr{
  color: rgba(70%, 0%, 0%);
  font-size: 15px;
  position: absolute;
  top: 41px;
  right: 7px;
  padding: 1px;
  background: #fff;
  border-radius: 50%;
}
.box .head span{
  font-size: 13px;
  display: block;
  line-height: 17px;
  text-align: center;
  color: #777;
}
.box .inputs{
  margin-bottom: 5px;
  margin-top: 5px;
  position: relative;
 
}
.box .inputs span{
  font-size: 12px;
  color: #5e1d3d;
  font-weight: 600;
  letter-spacing: 0px;
  font-weight;
}
.box .inputs .err i,
.box .inputs .suc i{
  font-size: 13px;
  margin-right: 7px;
}
.box .inputs .err,
.box .inputs .suc{
  padding: 2px;
  border-radius: 6px;
  font-size: 10px;
  font-weight: 00;
  display: flex;
  width: 100%;
  box-sizing: border-box;
  margin-top: 4px;
  align-items: center;
}
.box .inputs .err{
  color: rgba(80%, 0%, 0%);
}
.box .inputs .suc{
  color: rgba(0%, 60%, 0%);
}
.box .inpSep{
  display: flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  box-sizing: border-box;
}
.box .inpSep .inputs{
  width: 48%;
}
.box .inputs input[type="password"]{
  font-size: 15px;
}
.box .inputs select,
.box .inputs input{
  padding: 10px;
  height: 38px;
  border:none;
  width: 100%;
  box-sizing: border-box;
  border-bottom: 5px solid #5e1d3d;
  font-size: 15px;
  font-weight: 500;
  outline: none;
  font-family: 'Poppins', sans-serif;
  background: transparent;
  border-radius: 15px;
}
.box .inputs input:focus{
    border-bottom-color:blue;
}
@keyframes over{
  from{
    transform: translateY(-7px);
    opacity: 0;
  }
  to{
    transform: translateY(0px);
    opacity: 1;
  }
}
@keyframes overUp{
  from{
    transform: translateY(0px);
    opacity: 1;
  }
  to{
    transform: translateY(-6px);
    opacity: 0;
  }
}
.box .inputs input::placeholder{
  font-weight: 500;
  color: #0003;
  font-size: 11px;
}

.box button.b{
  margin-top: 10px;
}
.box button{
  padding: 10px;
  height: 48px;
  border: none;
  outline: none;
  background: var(--site-clr);
  color: #fff;
  line-height: 0;
  border-radius: 15px;
  width: 100%;
  margin-top: 25px;
  font-family: 'Poppins', sans-serif;
  font-size: 11px;
  font-weight: 900;
}
.box button i{
  margin-left: 7px;
}
.box .sep{
  display: flex;
  justify-content: start;
  align-items: center;
  margin-bottom: 20px;
  margin-top: 10px;
}
.box .sep input{
  width: 11px;
  height: 11px;
}
.box .sep.t-c{
  text-align: center;
  margin-bottom: 0;
  margin-top: 35px;
  display: flex;
  justify-content: center;
}
.box .sep.t-c input{
  margin-right: 10px;
  width: 15px;
  height: 15px;
}
.box .sep.t-c label{
  font-size: 10px;
  font-weight: 600;
  font-family: 'Poppins', sans-serif;
}
.box .sep label{
  font-size: 10px;
  font-weight: 500;
  color: #333;
}
.box .link{
  text-align: center;
  font-size: 12px;
  font-weight: 500;
  color: #000;
}
.box .link a{
  color: #0000ff;
  font-weight: 600;
}
.box .link span{
  display: block;
  margin-top: 13px;
  margin-bottom: 10px;
  letter-spacing: 0.6px;
  font-size: 10px;
}
.b-b{
  display: flex;
  align-items: end;
  justify-content: flex-end;
  margin-top: 10px;
  width: 320px;
  box-sizing: border-box;
}
.b-b button{
  padding: 20px;
  height: 30px;
  background: var(--site-clr);
  color: #fff;
  font-weight: 700;
  font-size: 10px;
  line-height: 0;
  border-radius: 20px;
  border: none;
  outline: none;
  letter-spacing: 0.6px;
  font-family: 'Poppins', sans-serif;
}
.box button.resend-btn{
  border: none;
  background: transparent;
  color: var(--site-clr);
  font-size: 12px;
  font-weight: 500;
  margin-top: 10px;
  width: auto;
  padding: 0;
}
.alertErr,
.alertSuc{
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  z-index: 60;
  display: flex;
  align-items: center;
  justify-content: center;
  background: hsl(0, 0%, 10%, 0.4);
  transition: 0.25s;
}
.alertErr .adiv,
.alertSuc .adiv{
  padding: 26px;
  border-radius: 15px;
  background: #fff;
  width: 260px;
  box-shadow: border-box;
  word-break: break-word;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  animation: zoomInMsg 0.2s;
  transition: 0.25s;
}
@keyframes zoomInMsg{
  from{
    transform: scale(0.7);
    opacity: 0.1;
  }
  to{
    transform: scale(1);
    opacity: 1;
  }
}
.alertErr,
.alertSuc{
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  z-index: 60;
  display: flex;
  align-items: center;
  justify-content: center;
  background: hsl(0, 0%, 10%, 0.4);
  transition: 0.25s;
}
.alertErr .adiv,
.alertSuc .adiv{
  padding: 0px;
  border-radius: 16px;
  background: #fff;
  width: 290px;
  box-shadow: border-box;
  word-break: break-word;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  animation: zoomInMsg 0.2s;
  transition: 0.25s;
  overflow: hidden;
}
@keyframes zoomInMsg{
  from{
    transform: scale(0.9);
    opacity: 0.1;
  }
  to{
    transform: scale(1);
    opacity: 1;
  }
}
.alertErr .adiv i,
.alertSuc .adiv i{
  font-size: 50px;
  margin-bottom: 5px;
  margin-top: 20px;
}
.alertErr .adiv span,
.alertSuc .adiv span{
  font-size: 13px;
  font-weight: 400;
  color: #222;
  margin-top: 10px;
  margin-bottom: 18px;
  text-align: center;
  padding: 0px;
  padding-left: 13px;
  padding-right: 13px;
}
.alertSuc .adiv i{
  color: rgba(0%, 50%, 0%);
}
.alertErr .adiv i{
  color: rgba(80%, 0%, 0%);
}
.alertErr .adiv .button,
.alertSuc .adiv .button{
  display: inline-flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  box-sizing: border-box;
  margin-bottom: 0;
  border-top: 1px solid hsl(0, 0%, 70%);
  padding-top: 0px;
}
.alertErr .adiv .button button,
.alertSuc .adiv .button button{
  padding: 10px;
  color: #fff;
  line-height: 0;
  display: flex;
  align-items: center;
  justify-content: center;
  outline: none;
  border-radius: 0px;
  height: 45px;
  width: 50%;
  font-size: 12px;
  font-family: 'Poppins', sans-serif;
  background: #fff;
  color: #666;
  border: none;
}
.alertErr .adiv .button button:hover,
.alertSuc .adiv .button button:hover,
.alertErr .adiv .button button:active,
.alertSuc .adiv .button button:active{
  background: hsl(0, 0%, 90%);
}
.alertSuc .adiv .button #cancelBtn,
.alertErr .adiv .button #cancelBtn{
  border-right: 0.8px solid hsl(0, 0%, 70%);
}
.alertErr .adiv .button #okBtn,
.alertSuc .adiv .button #okBtn{
  border-left: 0.8px solid hsl(0, 0%, 70%);
}
.spin{
  padding: 2px;
  height: 25px;
  width: 25px;
  border: 2.7px solid #fff;
  border-top: 2.7px solid #0003;
  background: transparent;
  border-radius: 50%;
  animation: infinitySpin 0.5s linear infinite;
  display: inline-block;
  box-sizing: border-box;
}

  </style>
</head>
<body>
   <div class="head-two">
      <img src="logos/logo.png" alt="Buypoint  logo">
  </div>
  <form class="box" id="reset-form">
    <div class="head">
    <h2 class="welcome-text" style="color: #5e1d3d; transition: color 0.3s ease-in-out;" 
    onmouseover="this.style.color='black';" 
    onmouseout="this.style.color='#5e1d3d';">
   Forgot Password
</h2>
      
      <span>Securely reset your <?php echo $site["site_name"]; ?>  account password</span>
    </div>
    <div class="inputs" id="emailOrphone:inputs">
      <span>Email</span>
      <input type="text" placeholder="spencer@gmail.com" name="email" id="email" oninput="checkValue('email', 'email-err', '', 'email', 'Invalid email', '')">
      <b id="email-err"></b>
    </div>
    <div class="inputs" id="code:inputs">
      <span>OTP(One Time Passcode) code</span>
      <input type="tel" placeholder="123456" name="code" id="code" oninput="checkValue('code', 'code-err', 4, 'length', 'Invalid code', '')">
      <b id="code-err"></b>
    </div>
    <script>
        document.getElementById('code').addEventListener('input', function() {
  const maxLength = 6;
  if (this.value.length > maxLength) {
    this.value = this.value.slice(0, maxLength);
  }
});

    </script>
    <div class="inputs" id="code:inputs">
      <span>New Password</span>
      <input type="text" placeholder="********" name="password" id="password" oninput="checkValue('password', 'password-err', 8, 'length', 'Invalid password required (8 digits)', '')">
      <b id="password-err"></b>
    </div>
    
    <button type="submit" id="submitBtn">SUBMIT <i class="fas fa-chevron-right"></i></button>
    <div class="link">
      <span>I have rememberd my password<a href="login.php"style="color: #5e1d3d; text-decoration: none;"> Login</a></span>
    </div><br>
    <button class="resend-btn" id="resend-btn-r" onclick="resendCode()" type="button">Send OTP Code</button>
  </form>
  
  
  
  <script>
  <?php include "js/msg.js"; ?>
function isEmail(input) {
  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  return emailRegex.test(input)
}
  
    const resetForm = document.getElementById("reset-form");
    const submitBtn = document.getElementById("submitBtn");
    let formerTxt = submitBtn.innerHTML;
    let codeStatus = false;
    
    const email = document.getElementById("email");
    const code = document.getElementById("code");
    const password = document.getElementById("password");
    
    resetForm.addEventListener("submit", (e) => {
      e.preventDefault();
      if(codeStatus){
        showMessage("bi bi-exclamation-circle", "Otp code not sent send otp code to be able to verify code and reset password", "err");
      }else{
        if(isEmail(email.value) !== true || code.value.length< 4 || password.value.length < 8){
          email.dispatchEvent(new Event("input"));
          code.dispatchEvent(new Event("input"));
          password.dispatchEvent(new Event("input"));
        }else{
          showP(submitBtn);
          fetch("server/reset-password.php", {
            method: "POST",
            body: new FormData(resetForm),
          })
          .then(response => response.text())
          .then(data => {
            removeP(submitBtn, formerTxt);
            if(data.includes("success")){
              showMessage("bi bi-check-circle", data, "suc");
              setTimeout(()=> {
                window.location.href = "login.php";
              }, 2000);
            }else{
              showMessage("bi bi-exclamation-circle", data, "err");
            }
          });
        }
      }
    });
    
    function resendCode(thsBtn){
      
      fetch("server/send-otp-code.php", {
        method: "POST",
        body: new FormData(resetForm),
      })
      .then(response => response.text())
      .then(data => {
        if(data.includes("INBOX")){
          startCount(30, "resend-btn-r", "Resend OTP code");
          showMessage("bi bi-check-circle", data, "suc");
        }else{
          showMessage("bi bi-exclamation-circle", data, "err");
        }
      })
    }
  </script>
</body>
</html>