<?php
session_start();
include_once "server/conn.php"; // Include your database connection

// Function to authenticate fingerprint
function authenticateFingerprint($conn, $user_id, $fingerprintData) {
    // Prepare the SQL statement to fetch the stored fingerprint data for the user
    $stmt = $conn->prepare("SELECT fingerprints_data FROM regtable WHERE id = ?");
    if (!$stmt) {
        return false; // Statement preparation failed
    }

    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        $storedFingerprint = $user['fingerprint_data'];

        // Compare the stored fingerprint with the provided fingerprint data
        if ($storedFingerprint === $fingerprintData) {
            return true; // Match found
        }
    }
    return false; // No match found
}

// Read the JSON input
$data = json_decode(file_get_contents("php://input"), true);
$fingerprintData = $data['fingerprint'] ?? '';
$user_id = $_SESSION["pin_verify"] ?? null; // Get the user ID from session

if ($user_id && !empty($fingerprintData)) {
    // Authenticate the fingerprint
    if (authenticateFingerprint($conn, $user_id, $fingerprintData)) {
        echo json_encode(["status" => "success"]); // Respond with success
        exit();
    } else {
        echo json_encode(["status" => "error", "message" => "Fingerprint authentication failed."]); // Respond with failure
        exit();
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request."]); // Respond with error
    exit();
}
?>