<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Airtime");

function getPrice($name){
  global $conn;
   $stats = "On";
   $ser = "Exam_pin";
   $sql = "SELECT * FROM service_details WHERE service = ? AND status = ? AND name = ?";
   $stmt = $conn->prepare($sql);
   $stmt->bind_param("sss", $ser, $stats, $name);
   $stmt->execute();
   $query = $stmt->get_result();
   
   if($query->num_rows > 0){
     $row = $query->fetch_assoc();
     
     return $row["amount"];
   }
 }
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/service.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Login || mBills</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    <?php include "css/animation.css"; ?>
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Exam PIN</span>
    <?php include "includes/user.php"; ?>
  </div>
  
  <form class="serviceBox" id="exam-form">
    
    <div class="inputs" hidden>
      <span>Select Exam Type</span>
      <select name="provider" id="provider" onchange="checkValue('provider', 'provider-err', '', 'empty', 'Select Provider', '')">
        <option value="">-- Select Exam Type --</option>
        <option value="1">WAEC</option>
        <option value="2">NECO</option>
        <option value="3">NABTEB</option>
      </select>
    </div>
    
    
    <div class="selectBtns">
      <span class="span">Select Exam Type</span>
      
      <div class="selectBtns-body">
        <!--------------------------------------------------->
         <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'provider', '1', 0, 'WAEC')">
           <img src="images/waec.jpeg" alt="service providers images">
           <span>WAEC</span>
         </div>
        <!--------------------------------------------------->
         <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'provider', '2', 1, 'NECO')">
           <img src="images/neco.png" alt="service providers images">
           <span>NECO</span>
         </div>
        <!--------------------------------------------------->
         <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'provider', '3', 2, 'NABTEB')">
           <img src="images/nabteb.jpeg" alt="service providers images">
           <span>NABTEB</span>
         </div>
      </div>
    </div>
    
    
    <div class="inputs">
      <span>Quantity</span>
      <input type="tel" name="quantity" id="quantity" placeholder="5" oninput="checkValue('quantity', 'quantity-err', 1, 'value', 'Invalid quantity minimum (1 quantity)', '')">
      <b id="quantity-err"></b>
    </div>
    
    <input type="text" name="provider-name" id="provider-name" placeholder="0" hidden>
    <input type="number" name="amount" id="amount" placeholder="0" hidden>
    
    <div class="inputs">
      <span>Amount To Pay</span>
      <input type="tel" class="disabled" name="amount-topay" id="amount-topay" placeholder="0" disabled>
      <b id="amount-topay-err"></b>
    </div>
    
    <?php include "includes/select-method.php"; ?>
    <?php include "includes/exam.php"; ?>
     <div class="link">
    <span style="text-align: right;"><a href="https://buypoint.com.ng/app/dashboard.php">Dashboard</a></span>
    </div>
    <button type="button" class="showPin" onclick="showPin()">PROCEED <i class="fas fa-arrow-right"></i></button>
  </form>
  
  <?php include "includes/reset-pin.php"; ?>
  
  <script>
   <?php include "js/msg.js"; ?>
   <?php include "js/other.js"; ?>
   
   const exam_form = document.getElementById("exam-form");
   const provider = document.getElementById("provider");
   const quantity = document.getElementById("quantity");
   const amount = document.getElementById("amount");
   const amount_pay = document.getElementById("amount-topay");
   let waec = <?php echo getPrice("waec"); ?>;
   let neco = <?php echo getPrice("neco"); ?>;
   let nabteb = <?php echo getPrice("nabteb"); ?>;
   
   provider.addEventListener("change", ()=> {
    quantity.dispatchEvent(new Event("input"));
   });
   
   quantity.addEventListener("input", ()=> {
     let qty = parseInt(quantity.value, 10);
     if(quantity.value < 1){
       quantity.dispatchEvent(new Event("input"));
       amount_pay.value = "";
       amount.value = "";
     }else{
       if(provider.value == 1){
         amount_pay.value = (waec * qty).toLocaleString();
         amount.value = waec * qty;
       }else if(provider.value == 2){
         amount_pay.value = (neco * qty).toLocaleString();
         amount.value = neco * qty;
       }else if(provider.value == 3){
         amount_pay.value = (nabteb * qty).toLocaleString();
         amount.value = nabteb * qty;
       }else{
         amount_pay.value = "";
         amount.value = "";
       }
     }
   });
   
   function showPin(){
     if(provider.value == ""){
       showMessage("bi bi-exclamation-circle", "Please select exam type", "err")
     }else if(quantity.value < 1){
       showMessage("bi bi-exclamation-circle", "Please enter a valid quantity minimum (1 quantity)", "err")
     }else if(amount.value == ""){
       showMessage("bi bi-exclamation-circle", "Please enter a valid amount", "err")
     }else{
       if(!isNaN(amount.value)){
         document.getElementById("input-t").innerText = provider.options[provider.selectedIndex].text;
         document.getElementById("input-q").innerText = quantity.value;
         document.getElementById("input-a").innerText = "NGN " + parseFloat(amount.value).toLocaleString();
         //-----------------------------------------------
         // seperate from others
         document.getElementById("provider-name").value = provider.options[provider.selectedIndex].text;
         //-----------------------------------------------
         document.querySelector(".pin-body").style.display = "flex";
       }else{
         showMessage("bi bi-exclamation-circle", "Amount must be in number/numeric format", "err")
       }
     }
   }
   
   
  function payExam(payB){
    let formerTxt = payB.innerText;
    showP(payB);
    fetch("server/auto.php?i=BuyExam", {
      method: "POST",
      body: new FormData(exam_form),
    })
    .then(response => response.text())
    .then(data => {
      if(data.includes("<table>")){
        const newD = document.createElement("div");
        newD.innerHTML = data;
        closePin("pin-body");
        document.body.appendChild(newD);
      }else{
        showMessage("bi bi-x-circle", data, "err");
      }
      removeP(payB, formerTxt);
    })
    .catch(error => {
      alert(error);
    });
  }
  </script>
  
  </body>
</html>