<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$verification = Control::fetchVerification($conn, $user_id);
if(!empty($verification["email"])){
  echo '
   <script>
    window.history.back();
   </script>
  ';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Email Verification</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Email Verification</span>
  </div>
  
  <form class="form-box" id="email-otp">
    <div class="f-head">Kindly enter OPT(One Time Passcode) to verify</div>
    
    <div class="s-txt"></div>
    
    <input type="email" id="email" name="email" value="<?php echo $user["email"]; ?>" hidden>
    
    <input type="text" id="type" name="tye" value="verify" hidden>
    
    <div class="inputs">
      <span>Enter OTP Code</span>
      <input type="tel" name="otp-code" id="otp-code" placeholder="1234" maxlength="6" oninput="checkValue('otp-code', 'otp-code-err', 6, 'length', 'Invalid otp', '')">
      <b id="otp-code-err"></b>
    </div>
    <button type="button" class="button" onclick="updateV(this)">SUBMIT</button>
    
    
    <button type="button" id="resend" class="b-resend" onclick="resendOtp(this)">Send OTP code</button>
  </form>
  
  <script>
    <?php include "js/msg.js"; ?>
    const form = document.getElementById("email-otp");
    const codeInput = document.getElementById("otp-code");
    function resendOtp(thisInn){
      thisInn.innerHTML = "Sending Code . . .";
      thisInn.disabled = true;
      thisInn.classList.add("disabled");
      
        fetch("server/send-email-otp.php", {
          method: "POST",
          body: new FormData(form),
        })
        .then(response => response.text())
        .then(data => {
          if(data.includes("INBOX")){
            showMessage("bi bi-check-circle", data, "suc");
            startCount(30, "resend", "Resend OTP code");
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
            thisInn.innerHTML = "Resend OTP Code";
            thisInn.disabled = false;
            thisInn.classList.remove("disabled");
          }
        });
    }
    
    
    function updateV(thisBtn){
      if(codeInput.value < 6){
        codeInput.dispatchEvent(new Event("input"));
      }else{
        let former = thisBtn.innerText;
        showP(thisBtn);
        fetch("server/update-email-v.php", {
          method: "POST",
          body: new FormData(form),
        })
        .then(response => response.text())
        .then(data => {
          removeP(thisBtn, former);
          if(data.includes("success")){
            showMessage("bi bi-check-circle", data, "suc");
            window.history.back();
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        });
      }
    }
  </script>
  </body>
</html>