<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Electricity");
 
 $stats = "On";
 $ser = "Electricity";
 $sql = "SELECT * FROM service_id WHERE service = ? AND status = ? ORDER BY ab ASC";
 $stmt = $conn->prepare($sql);
 $stmt->bind_param("ss", $ser, $stats);
 $stmt->execute();
 $query = $stmt->get_result();
 
 $allF = [];
 if($query->num_rows > 0){
   while($row = $query->fetch_assoc()){
     $allF[] = $row;
   }
 }
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/service.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Electricity</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Buy Electricity</span>
    <?php include "includes/user.php"; ?>
  </div>
  
  <form class="serviceBox" id="electricity-form">
    
    <div class="inputs" hidden>
      <span>Select Provider</span>
      <select name="provider" id="provider" onchange="checkValue('provider', 'provider-err', '', 'empty', 'Select Provider', '')">
        <option value="">-- Select Provider --</option>
        <?php 
         if(!empty($allF)){
           foreach ($allF as $a){
             echo '
             <option value="'.$a["provider_id"].'">'.$a["provider"].' ('.$a["ab"].')</option>
             ';
           }
         }
        ?>
      </select>
      
    </div>
<input type="text" name="meter-name" id="meter-name" hidden>
      
      <input type="text" name="type-name" id="type-name" hidden>
      
      <input type="text" name="provider-name" id="provider-name" hidden>
    
    
    <div class="inputs" id="meter-no:inputs"><img src="logos/121.jpg" alt="Header Image" style="border-radius: 10px; max-width: 100%; height: auto;">
      <span>Meter No</span>
      <input type="tel" name="meter-no" id="meter-no" placeholder="83756890278" maxlength="11" oninput="checkValue('meter-no', 'meter-no-err', 5, 'length', 'Invalid meter no required(5 digits)', '')">
      <b id="meter-no-err"></b>
    </div>
    
    <div class="inputs" hidden>
      <span>Select Type</span>
      <select name="type" id="type" onchange="checkValue('type', 'type-err', '', 'empty', 'Select Type', '')">
        <option value="">-- Select Type --</option>
        <option value="1">Prepaid</option>
        <option value="2">Postpaid</option>
      </select>
    </div>
    
    <div class="inputs" id="type:inputs">
      <span>Select Type</span>
      <div class="drop-btn" id="type:1" onclick="addActive(this, 'type-detail')">
        <span>-- Select Type --</span>
        <i class="fas fa-chevron-down"></i>
      </div>
      
      <div class="drop-detail two" id="type-detail">
         <div class="drop-detail-divs type" onclick="removeDrop('type', '1', this, 'drop-detail-divs.type', 'type:1')">
             <i class="bi bi-infinity"></i>
             <span>Prepaid</span>
        </div>
         <div class="drop-detail-divs type" onclick="removeDrop('type', '2', this, 'drop-detail-divs.type', 'type:1')">
             <i class="bi bi-infinity"></i>
             <span>Postpaid</span>
        </div>
      </div>
      
      <b id="type-err"></b>
    </div>
    
    
    
      
    
    <div class="inputs" id="amount:inputs">
      <span>Amount</span>
      <input type="number" name="amount" id="amount" placeholder="1000" oninput="checkValue('amount', 'amount-err', 1000, 'value', 'Invalid amount minimum(NGN 1000)', '')">
      <b id="amount-err"></b>
     </div>

    <div class="inputs" id="provider:inputs" style="margin-top: 0px;">
      <span>Select Provider</span>
      <div class="drop-btn" id="provider:1" onclick="addActive(this, 'provider-detail')">
        <span>-- Select Provider --</span>
        <i class="fas fa-chevron-down"></i>
      </div>
      
     <!---------------------------------------------------- 
     <!---- Html of details
     ---------------------------------------------------->
      <div class="drop-detail" id="provider-detail">
          <?php 
           if(!empty($allF)){
             foreach ($allF as $a){
               echo '
               <div class="drop-detail-divs provider" onclick="removeDrop(`provider`, `'.$a["provider_id"].'`, this, `drop-detail-divs.provider`, `provider:1`)">
                 <i class="bi bi-infinity"></i>
                 <span>'.$a["provider"].' ('.$a["ab"].')</span>
               </div>
               ';
             }
           }
          ?>
      </div>
     <!---------------------------------------------------> 
     <!---------------------------------------------------> 
      
      <b id="provider-err"></b>
    </div>
    <div class="inputs" id="amount:inputs">
      <span>Amount to pay</span>
      <input type="number" class="disabled" name="discount" id="discount" placeholder="1000" disabled>
      <b id="amount-err"></b>
    </div>
    
    <?php include "includes/select-method.php"; ?>
    
     <?php include "includes/electricity.php";?>
     
     <a href="dashboard.php" style="text-decoration: none; color: #5e1d3d"><i class="ri-home-smile-2-line">Dashboard</i></a>
    
    <button type="button" class="showPin" onclick="showPin()">PROCEED <i class="fas fa-arrow-right"></i></button>
  </form>
  
  
  <script>
   <?php include "js/msg.js"; ?>
   const form = document.getElementById("electricity-form");
   const provider = document.getElementById("provider");
   const type = document.getElementById("type");
   const meter_no = document.getElementById("meter-no");
   const meter_no_err = document.getElementById("meter-no-err");
   const meter_name = document.getElementById("meter-name");
   const amount = document.getElementById("amount");
   const discount = document.getElementById("discount");
   
   amount.addEventListener("input", ()=> {
      let discountV = parseInt("<?php echo $fetchDiscount["discount"]; ?>") / 100;
      discount.value = (parseInt(amount.value) * (1 - discountV)).toFixed(2);
   })
   
   meter_no.addEventListener("input", ()=> {
     if(meter_no.value.length > 4){
       if(meter_no.value == "" || type.value == ""){
         provider.dispatchEvent(new Event("change"));
       }else{
         showChecking(meter_no_err, "Verifying meter name");
         fetch("server/auto.php?i=VerifyElectricity", {
           method: "POST",
           body: new FormData(form),
         })
         .then(response => response.json())
         .then(data => {
           if(data.status == true){
             meter_name.value = data.name;
             showSuccess(meter_no_err, data.name);
           }else{
             meter_name.value = "";
             showError(meter_no_err, data.msg);
           }
         })
         .catch(err => {
           showMessage("bi bi-exclamation-circle", "something went wrong", "err");
         });
       }
     }
   })
   
   provider.addEventListener("change", doD);
   
   function doD(){
     type.dispatchEvent(new Event("change"));
     meter_no.dispatchEvent(new Event("input"));
     amount.dispatchEvent(new Event("input"));
   }
   
   function showPin(){
     if(provider.value == ""){
       showMessage("bi bi-exclamation-circle", "Please Select Provider", "err");
     }else if(type.value == ""){
       showMessage("bi bi-exclamation-circle", "Please Select electricity type", "err");
     }else if(meter_no.value.length < 5){
       showMessage("bi bi-exclamation-circle", "Invalid Meter No required(11 digits)", "err");
     }else if(amount.value < 1000){
       showMessage("bi bi-exclamation-circle", "Invalid amount minimum(NGN 1000)", "err");
     }else if(meter_name.value == ""){
       showMessage("bi bi-exclamation-circle", "Please verify meter name before proceeding", "err");
     }else{
       document.getElementById("provider-name").value = provider.options[provider.selectedIndex].text;
       document.getElementById("input-t").innerHTML = type.options[type.selectedIndex].text;
       document.getElementById("type-name").value = type.options[type.selectedIndex].text;
       document.getElementById("input-p").innerHTML = provider.options[provider.selectedIndex].text;
       document.getElementById("input-nm").innerHTML = meter_name.value;
       document.getElementById("input-n").innerHTML = meter_no.value;
       document.getElementById("input-a").innerHTML = "NGN " +  (parseFloat(discount.value)).toLocaleString();
       
       document.querySelector(".pin-body").style.display = "flex";
     }
   }
   
   function payElectric(thisBtn){
     let formerTxt = thisBtn.innerText;
     showP(thisBtn);
     fetch("server/auto.php?i=BuyElectricity", {
       method: "POST",
       body: new FormData(form),
     })
     .then(response => response.text())
     .then(data => {
        if(data.includes("<table>")){
          const newD = document.createElement("div");
          newD.innerHTML = data;
          document.body.appendChild(newD);
        }else{
          showMessage("bi bi-x-circle", data, "err");
        }
       removeP(thisBtn, formerTxt);
     })
   }
  </script>
  
  </body>
</html>