<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once "server/conn.php";
require_once "server/controller.php";

validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Data");

function getId($name){
  global $conn;
  $stats = "On";
  $ser = "Data";
  $sql = "SELECT * FROM service_id WHERE service = ? AND status = ? AND provider = ? ORDER BY provider_id ASC";
  $stmt = $conn->prepare($sql);
  $stmt->bind_param("sss", $ser, $stats, $name);
  $stmt->execute();
  $query = $stmt->get_result();
  
  if($query->num_rows > 0){
    $row = $query->fetch_assoc();
    
    return $row["provider_id"];
  }
}
// Retrieve saved contacts
$sql = "SELECT * FROM contacts WHERE unique_id = '$user_id'";
$result = $conn->query($sql);

// Display saved contacts
$saved_contacts = array();
if ($result->num_rows > 0) {
  while($row = $result->fetch_assoc()) {
    $saved_contacts[] = array(
      'name' => $row["name"],
      'phone' => $row["phone"]
    );
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/service.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Buy Data || Buypoint</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    select{
        width:100%;
        height:50px;
        border-radius:8px;
        border:none;
    }
    <?php include "css/animation.css";?>
  </style>
  <script>
    function updateInput(value) {
      document.getElementById("phone").value = value;
    }
  </script>

</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Buy Data</span>
    <a href="datatrx.php" style="text-decoration: none; color: #333"><i class="fas fa-history"></i></a>
  </div>
  
  <form class="serviceBox" id="data-form">
    <div class="selectBtns">
    <img src="logos/122.jpg" alt="Header Image" style="border-radius: 10px; max-width: 100%; height: auto;">
     <span class="span">Select Network Provider</span>
      <!------------------------------------
      <!Services provider images 
     ----------------------------------->
      <div class="selectBtns-body">
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("MTN"); ?>', 0, 'MTN')">
          <img src="images/mtn.png" alt="service providers images">
          <span>MTN</span>
        </div>
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("GLO"); ?>', 1, 'GLO')">
          <img src="images/glo.png" alt="service providers images">
          <span>GLO</span>
        </div>
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("9MOBILE"); ?>', 2, '9MOBILE')">
          <img src="images/9mobile.png" alt="service providers images">
          <span>9MOBILE</span>
        </div>
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("AIRTEL"); ?>', 3, 'AIRTEL')">
          <img src="images/airtel.png" alt="service providers images">
          <span>AIRTEL</span>
        </div>
      </div>
    </div>
    
      <select name="network" id="network" hidden>
        <option value="">Select Network</option>
        <option value="<?php  echo getId("MTN"); ?>">MTN</option>
        <option value="<?php  echo getId("GLO"); ?>">GLO</option>
        <option value="<?php  echo getId("9MOBILE"); ?>">9MOBILE</option>
        <option value="<?php  echo getId("AIRTEL"); ?>">AIRTEL</option>
      </select>
      
    <div class="inputs" hidden>
      <span>Select Type</span>
      <select name="data-type" id="data-type" onchange="checkValue('data-type', 'data-type-err', '', 'empty', 'Select data type', '')">
        <option value="">-- Select Type --</option>
      </select>
    </div>
    
    
    <div class="inputs" id="data-type:inputs">
      <span>Select Type</span>
      <div class="drop-btn" id="data-type:1" onclick="addActive(this, 'type-detail')"> 
       <span>-- Select Type --</span>
       <i class="fas fa-chevron-down" id="i"></i>
      </div>
      
      <div class="drop-detail" id="type-detail">
         
      </div>
      
      <b id="data-type-err"></b>
    </div>
    
    
     <div class="inputs" hidden>
      <span>Select Plan</span>
      <select name="data-plan" id="data-plan" onchange="checkValue('data-plan', 'data-plan-err', '', 'empty', 'Select data plan', '')">
        <option value="">-- Select Plan --</option>
      </select>
    </div>
    
    
    <div class="inputs" id="data-plan:inputs">
      <span>Select Plan</span>
      <div class="drop-btn" id="data-plan:1" onclick="addActive(this, 'plan-detail')"> 
       <span>-- Select Plan --</span>
       <i class="fas fa-chevron-down" id="i"></i>
      </div>
      
      <div class="drop-detail" id="plan-detail">
         <div class="no"><i class="fas fa-times-circle"></i><span>No plan found or not available</span></div>
      </div>
      
      <b id="data-plan-err"></b>
    </div>
    
    
    <div class="inputs" id="phone:inputs">
      <span>Phone Number</span>
      <input type="tel" name="phone" id="phone" placeholder="08012345678" oninput="checkValue('phone', 'phone-err', 11, 'length', 'Invalid Phone Number', '')" maxlength="11">
      <b id="phone-err"></b>
      <b id="number-valid" class="validator"></b>
    </div>
     
    </select>
      
      <input type="tel" name="amount" id="amount" placeholder="1000" hidden>
      
      <input type="text" name="data-plan-name" id="data-plan-name" placeholder="1000" hidden>
      
      <input type="text" name="data-type-name" id="data-type-name" placeholder="1000" hidden>
      
      <input type="text" name="network-name" id="network-name" placeholder="1000" hidden>

    <div class="inputs">
      <span>Amount To Pay</span>
      <input type="tel" class="disabled" name="discount" id="discount" placeholder="0" disabled>
      <b id="discount-err"></b>
    </div>
    
   
    
    <?php include "includes/data.php"; ?>
    <a href="dashboard.php" style="text-decoration: none; color: #5e1d3d"><i class="ri-home-smile-2-line">Dashboard</i></a>
    <button class="showPin" type="button" onclick="showPin()">PROCEED <i class="fas fa-arrow-right"></i></button>
  </form>
  
  <?php include "includes/reset-pin.php"; ?>
  
  <script>
   
  <?php include "js/msg.js"; ?>
   <?php include "js/other.js"; ?>
   
    const network = document.getElementById("network");
    const datatype = document.getElementById("data-type");
    const type_detail = document.getElementById("type-detail");
    const dataplan = document.getElementById("data-plan");
    const phone = document.getElementById("phone");
    const amount = document.getElementById("amount");
    const plan_detail = document.getElementById("plan-detail");
    const plan_span = document.getElementById("data-plan:1");
    <?php
      $outputs2 = "";
      $sts2 = "On";
      $sts3 = "DATA";
      $sql2 = "SELECT * FROM available_types WHERE status = ? AND service_name = ?";
      $stmt3 = $conn->prepare($sql2);
      $stmt3->bind_param("ss", $sts2, $sts3);
      $stmt3->execute();
      $res3 = $stmt3->get_result();
      if($res3->num_rows > 0){
        while($row3 = $res3->fetch_assoc()){
          $outputs2 .= json_encode($row3).", ";
        }
      }
   ?>

   const alltypes = JSON.parse(`[<?php echo rtrim($outputs2, ', '); ?>]`);
    network.addEventListener("change", updateSecond);
    
    function updateSecond(){
      datatype.innerHTML = "<option value=''>-- Select Type --</option>";
      type_detail.innerHTML = '';

      const netName = network.options[network.selectedIndex].text;
      const filteredTypes = alltypes.filter(type => type.service === netName);

      filteredTypes.forEach(typeData => {
        const dPname = typeData.type_name;

        const option = document.createElement("option");
        option.value = typeData.id;
        option.innerHTML = dPname;
        datatype.appendChild(option);

        const newOptionDiv = document.createElement("div");
        newOptionDiv.innerHTML = `
          <div class="drop-detail-divs type" onclick="removeDrop('data-type', '${typeData.id}', this, 'drop-detail-divs.type', 'data-type:1')" onmousemove="createRipple(event, true, 'black')">
            <i class="fas fa-check"></i>
            <span>${typeData.type_name}</span>
          </div>
        `;
        type_detail.appendChild(newOptionDiv);

        type_detail.className = 'drop-detail';

        const count = filteredTypes.length;
        if(count < 5){
          const numberWords = ["zero", "one", "two", "three", "four"];
          const gWord = numberWords[count];
          type_detail.className = 'drop-detail ' + gWord;
        }
      });
    }

    function validatePhoneNumber(phoneNumber) {
        // Remove any non-digit characters
        phoneNumber = phoneNumber.replace(/\D/g, '');

        // Regular expressions for different network providers
        const mtnRegex = /^(0803|0806|0703|0706|0810|0813|0814|0816|0903|0906|0913|0916)\d{7}$/;
        const airtelRegex = /^(0802|0808|0708|0812|0902|0907|0912)\d{7}$/;
        const gloRegex = /^(0805|0807|0705|0811|0815|0905|0915)\d{7}$/;
        const mobile9Regex = /^(0809|0817|0818|0909|0908|0918)\d{7}$/;

        if (mtnRegex.test(phoneNumber)) {
            return "This is an MTN number";
        } else if (airtelRegex.test(phoneNumber)) {
            return "This is an AIRTEL number";
        } else if (gloRegex.test(phoneNumber)) {
            return "This is a GLO number";
        } else if (mobile9Regex.test(phoneNumber)) {
            return "This is a 9MOBILE number";
        } else {
            return "";
        }
    }

    phone.addEventListener('input', ()=> {
      if(phone.value.length > 3){
        document.getElementById("number-valid").innerHTML = validatePhoneNumber(phone.value);
      }
    });


    <?php
      $outputs = "";
      $sts = "On";
      $sql2 = "SELECT * FROM service_details WHERE status = ?";
      $stmt2 = $conn->prepare($sql2);
      $stmt2->bind_param("s", $sts);
      $stmt2->execute();
      $res2 = $stmt2->get_result();
      if($res2->num_rows > 0){
        while($row2 = $res2->fetch_assoc()){
          $outputs .= json_encode($row2).", ";
        }
      }
   ?>
   const allplans = JSON.parse(`[<?php echo rtrim($outputs, ', '); ?>]`);
    
    network.addEventListener("change", updateThird);
    datatype.addEventListener("change", updateThird);
    
    function updateThird(){
      dataplan.innerHTML = "<option value=''>-- Select Plan --</option>"; // Reset the plan options
      plan_detail.innerHTML = "";
      const netName = network.options[network.selectedIndex].text;
      const dataName = datatype.options[datatype.selectedIndex].text;
      const filteredPlans = allplans.filter(plan => plan.service === netName && plan.name === dataName);
      
      if(filteredPlans.length === 0){
        dataplan.innerHTML = "<option value=''>-- Select Plan --</option>";
        plan_detail.innerHTML = `<div class="no"><i class="fas fa-times-circle"></i><span>No plan found or not available</span></div>`;
      }else{
        filteredPlans.forEach(planData => {
            const dPname = planData.service + ' ' + planData.name + ' ' + planData.plan + ' = (' + (planData.amount).toLocaleString() + ') ' + planData.validity;
            const option = document.createElement("option");
            option.value = planData.service_id;
            option.innerHTML = dPname;

            const newOptionDiv = document.createElement("div");
            newOptionDiv.innerHTML = `
            <div class="drop-detail-divs" onclick="removeDrop('data-plan', '${planData.service_id}', this, 'drop-detail-divs', 'data-plan:1')" onmousemove="createRipple(event, true, 'black')">
              <img src="images/${netName}.png">
              <span>${dPname}</span>
            </div>
            `;

            dataplan.appendChild(option);
            plan_detail.appendChild(newOptionDiv);
        });
      }
    }
    
    dataplan.addEventListener("change", ()=> {
      const selectOption = dataplan.options[dataplan.selectedIndex];
      const regex = /\(([\d,]+)\)/;
      const matches = regex.exec(selectOption.text);
      if(matches){
        const extractedNumber = matches[1].replace(',', '');
        
        const new_d = parseInt("<?php echo $fetchDiscount["discount"]; ?>") / 100;
        amount.value = extractedNumber;
        discount.value = (parseInt(extractedNumber) * (1 - new_d)).toFixed(2);
        document.getElementById("data-plan-name").value = selectOption.text;
        document.getElementById("data-type-name").value = datatype.options[datatype.selectedIndex].text;
        document.getElementById("network-name").value = network.options[network.selectedIndex].text;
      }
    })
    
    function showPin(){
      
      if(network.value == ""){
        showMessage("bi bi-exclamation-circle", "Please select network", "err");
      }else if(datatype.value == ""){
        showMessage("bi bi-exclamation-circle", "Please select data type", "err");
      }else if(dataplan.value == ""){
        showMessage("bi bi-exclamation-circle", "Please select data plan", "err");
      }else if(phone.value.length < 11 || phone.value.length > 11){
        showMessage("bi bi-exclamation-circle", "Please enter a valid Phone Number required(11 digits)", "err");
      }else if(amount.value < 20){
        showMessage("bi bi-exclamation-circle", "Please enter a valid amount minimum(NGN 100)", "err");
      }else{
        if(isNaN(phone.value)){
          showMessage("bi bi-exclamation-circle", "Please enter a valid phone number required(11 digits) Number Format", "err");
        }else if(isNaN(amount.value)){
          showMessage("bi bi-exclamation-circle", "Please enter a valid amount required(Number Format)", "err");
        }else{
          document.getElementById("input-p").innerHTML = phone.value;
          document.getElementById("input-n").innerHTML = network.options[network.selectedIndex].text;
          document.getElementById("input-a").innerHTML = "NGN " + parseFloat(discount.value).toLocaleString();
          document.getElementById("input-pl").innerHTML = ((((dataplan.options[dataplan.selectedIndex].text.replace('=', '')).replace("(", "")).replace(")", "")).replace(",", "")).replace(amount.value, "");
          document.getElementById("input-t").innerHTML = datatype.options[datatype.selectedIndex].text;
          document.querySelector(".pin-body").style.display = "flex";
        }
      }
    }
    const data_from = document.getElementById("data-form");
    function payData(payB){
 
      let formerTxt = payB.innerText;
      showP(payB);
      fetch("server/auto.php?i=BuyData", {
        method: "POST",
        body: new FormData(data_from),
      })
      .then(response => response.text())
      .then(data => {
        if(data.includes("<table>")){
          const newD = document.createElement("div");
          newD.innerHTML = data;
          closePin("pin-body");
          document.body.appendChild(newD);
        }else{
          showMessage("bi bi-x-circle", data, "err");
        }
        removeP(payB, formerTxt);
      })
      .catch(error => alert(error));
    }
     document.addEventListener("DOMContentLoaded", function() {
    const plans = [
      { value: "plan1", text: "Plan 1 - 1GB for $5" },
      { value: "plan2", text: "Plan 2 - 5GB for $20" },
      { value: "plan3", text: "Plan 3 - 10GB for $35" }
    ];
    
    let select = document.getElementById("data-plan");

    plans.forEach(plan => {
      let option = document.createElement("option");
      option.value = plan.value;
      option.textContent = plan.text;
      select.appendChild(option);
    });
  });
  
  </script>
 
  </body>
</html>