<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$site = Control::site($conn);

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Dashboard || Honemek</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    <?php include "css/dashboard.php"; ?>
     <?php include "css/dash.php"; ?>
     
 

.badge.bg-success {
  position: fixed;
  bottom: 0;
  right: 95%;
}
.nav {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 15px;
    border-radius: 8px;
    cursor: pointer;
    transition: background 0.3s ease-in-out;
    position: relative;
}

.nav:hover {
    background: rgba(0, 0, 0, 0.1);
}

.nav i {
    font-size: 20px;
    transition: transform 0.3s ease-in-out;
}

.nav:hover i {
    transform: scale(1.2);
}

.nav span {
    font-size: 16px;
    font-weight: bold;
    transition: color 0.3s ease-in-out;
}

.nav:hover span {
    color: black;
}


  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  
  <div class="head">
   <div class="site-img">
  <?php echo "
    <img onclick='window.location.href=\"profile.php\"' src='Uploads/avatar.png' alt='Profile Image'>
  "; ?>
<style>
.username-container {
  text-align: center;
  
}

.username {
 
  color: #5e1d3d;
  font-size: 15px;
} 

.tier {
  background-color: #5e1d3d;
  padding: 3px;
  position:absolute;
  left:70px;
  bottom:1px;
  font-size:10px;
  z-index:100;
  font-weight:bold;
  border-radius: 10px;
}
#bottom, #bottom * {
    color: #5e1d3d !important;
}


</style>

<div class="username-container">
  <p class="username">Hello, <?php echo $user["fname"]; ?></p>
 
</div>


    </div>
    
    <div class="toggle">
        
        
    </div>
    <div class="i" id="nav:4">
      <i class="ri-customer-service-2-line" id="nav:4"></i>
      <b class="count txt" id="nav:4">Help</b>
    </div>
    <div class="i" onclick="showNotification()">
      <i class="ri-notification-4-line"></i>
      <b class="count">1</b>
    </div>
  </div>
  <div id="inn" class="inn"></div>
  
 <div class="custom-nav" id="custom-nav" style="
    position: fixed; 
    bottom: 0; 
    left: 0; 
    right: 0;
    width: 100%; 
    background-color: #f4f7fa; 
    display: grid;
    grid-template-columns: repeat(5, 1fr);
    height: 60px;
    z-index: 20;
    align-items: center;
    text-align: center;
   
    color: #5e1d3d !important;
    padding: 0;
">

    <div class="nav" id="nav:1" style="display: flex; flex-direction: column; align-items: center; justify-content: center;">
        <i class="ri-home-smile-2-line" id="nav:1" style="color: #5e1d3d !important; font-size: 20px;"></i>
        <span id="nav:1" style="color: #5e1d3d !important; margin-top: -6px; font-size: 10px;">Home</span>
    </div>

    <a href="virtual-card.php" style="text-decoration: none;">
        <div class="nav" id="nav:2" style="display: flex; flex-direction: column; align-items: center; justify-content: center;">
            <i class="bi bi-credit-card" id="nav:3" style="color: #5e1d3d !important; font-size: 20px;"></i>
            <span id="nav:2" style="color: #5e1d3d !important; margin-top: -13px; font-size: 10px;">Cards</span>
        </div>
    </a>

    <div class="nav" id="nav:3" style="display: flex; flex-direction: column; align-items: center; justify-content: center;">
        <i class="bi bi-piggy-bank" id="nav:3" style="color: #5e1d3d !important; font-size: 20px;"></i>
        <span id="nav:3" style="color: #5e1d3d !important; margin-top: -13px; font-size: 10px;">HoneyWell</span>
    </div>

    <div class="nav" id="nav:4" style="display: flex; flex-direction: column; align-items: center; justify-content: center;">
        <i class="ri-chat-smile-2-line" id="nav:4" style="color: #5e1d3d !important; font-size: 20px;"></i>
        <span id="nav:4" style="color: #5e1d3d !important; margin-top: -6px; font-size: 10px;">Support</span>
    </div>

    <div class="nav" id="nav:5" style="display: flex; flex-direction: column; align-items: center; justify-content: center;">
        <i class="ri-user-smile-line" id="nav:5" style="color: #5e1d3d !important; font-size: 20px;"></i>
        <span id="nav:5" style="color: #5e1d3d !important; margin-top: -6px; font-size: 10px;">Me</span>
   </div>
   
 </div>
 <?php
 $uri = $_SERVER["REQUEST_URI"];
 ?>
 <script>
   <?php include "js/msg.js"; ?>
   const nav = document.querySelectorAll(".nav");
   window.addEventListener("DOMContentLoaded", ()=> {
     <?php
      if($uri === "/mobile/dashboard.php" || $uri === "/mobile/dashboard-home.php"){
        echo '
         setFrigament(new TabHome);
         addClassList(nav, 0);
        ';
      }else if($uri === "/mobile/virtual-card.php"){
        echo '
         setFrigament(new TabFund);
         addClassList(nav, 1);
        ';
      }else if($uri === "/mobile/fund-lock-activate.php"){
        echo '
         setFrigament(new TabFundLock);
         addClassList(nav, 2);
        ';
      }else if($uri === "/mobile/support.php"){
        echo '
         setFrigament(new TabSupport);
         addClassList(nav, 3);
        ';
      }else if($uri === "/mobile/user-account.php"){
        echo '
         setFrigament(new TabAccount);
         addClassList(nav, 4);
        ';
      }
     ?>
   })
// Event listener for popstate
window.addEventListener('popstate', (event) => {
    console.log('popstate event:', event);
    // Handle the history state change here
    const state = event.state;
    const currentPath = window.location.pathname;
    
    // Check if the current path is /fund or /lock
    if(currentPath === '/mobile/dashboard.php'){
      setFrigament(new TabHome);
      addClassList(nav, 0);
    } else if (currentPath === '/mobile/dashboard-home.php') {
      setFrigament(new TabHome);
      addClassList(nav, 0);
    } else if (currentPath === '/mobile/virtua-card.php') {
      setFrigament(new TabFund);
      addClassList(nav, 1);
    } else if (currentPath === '/mobile/lock-fund.php') {
      setFrigament(new TabFundLock);
      addClassList(nav, 2);
    } else if (currentPath === '/mobile/support.php') {
      setFrigament(new TabSupport);
      addClassList(nav, 3);
    } else if (currentPath === '/mobile/user-account.php') {
      setFrigament(new TabAccount);
      addClassList(nav, 4);
    } else if (state) {
        document.getElementById("inn").innerHTML = state.additionalInformation;
    }
});
   function changeUrl(link, pgtitle){
       // Update the browser history
       const newUrl = link;
       const title = pgtitle; // Optional, you can set a title for the new state
       const state = { additionalInformation: 'Additional data' }; //Optional, you can pass additional state data

       // Push the new state to the history stack
       history.pushState(state, title, newUrl);
       document.title = pgtitle;
   }
   const inn = document.getElementById("inn");
   const bottom = document.getElementById("bottom");
   document.body.addEventListener("click", (e)=> {
     const targetE = e.target;
     if(targetE.id == "nav:1"){
       setFrigament(new TabHome);
       addClassList(nav, 0);
       changeUrl("http://localhost:7070/mobile/dashboard-home.php", "Dashboard Home || buypoint");
     }else if(targetE.id == "nav:2"){
       setFrigament(new TabFund);
       addClassList(nav, 1);
       changeUrl("http://localhost:7070/mobile/virtual-card.php", "Fund Wallet || buypoint");
     }else if(targetE.id == "nav:3"){
       setFrigament(new TabFundLock);
       addClassList(nav, 2);
       changeUrl("http://localhost:7070/mobile/lock-fund.php", "Fund Lock || buypoint");
     }else if(targetE.id == "nav:4"){
       setFrigament(new TabSupport);
       addClassList(nav, 3);
       changeUrl("http://localhost:7070/mobile/support.php", "Support || buypoint");
     }else if(targetE.id == "nav:5"){
       setFrigament(new TabAccount);
       addClassList(nav, 4);
       changeUrl("http://localhost:7070/mobile/user-account.php", "Account || buypoint");
     }
   });
   
   function addClassList(class_name, to_add){
     class_name.forEach(navs => {
       navs.classList.remove("active");
       if(!navs.innerHTML.includes("img")){
         const navs_i = navs.querySelector("i").getAttribute("class");
         if(navs_i.includes("ri-")){
           const navs_remove = navs_i.replace("-fill", "-line");
           navs.querySelector("i").className = navs_remove;
         }else if(navs_i.includes("bi")){
           const navs_remove = navs_i.replace("-fill", "");
           navs.querySelector("i").className = navs_remove;
         }
       }
     })
     nav[to_add].classList.add("active");
     const nav_add = nav[to_add].querySelector("i").getAttribute("class");
     if(nav_add.includes("ri-")){
       const nav_add_r = nav_add.replace("-line", "-fill");
       nav[to_add].querySelector("i").className = nav_add_r;
     }else if(nav_add.includes("bi")){
       const nav_add_r = nav_add + "-fill";
       nav[to_add].querySelector("i").className = nav_add_r;
     }
   }
   
   function setFrigament(page){
     inn.innerHTML = "";
     inn.appendChild(page);
   }
   
   
   class TabHome {
     constructor(){
       const newPage = document.createElement("div");
       fetch("server/auto.php?i=homeD")
       .then((response) => response.text())
       .then((data) => {
         newPage.innerHTML = data;
         greetUser("welcome-msg")
       });
       return newPage;
     }
   }
   
   class TabFund {
     constructor(){
       const newPage = document.createElement("div");
       fetch("server/auto.php?i=fundD")
       .then((response) => response.text())
       .then((data) => {
         newPage.innerHTML = data;
       });
       return newPage;
     }
   }
   
   class TabFundLock {
     constructor(){
       const newPage = document.createElement("div");
       fetch("server/auto.php?i=lockD")
       .then((response) => response.text())
       .then((data) => {
         newPage.innerHTML = data;
       });
       return newPage;
     }
   }
   
   class TabSupport {
     constructor(){
       const newPage = document.createElement("div");
       fetch("server/auto.php?i=supportD")
       .then((response) => response.text())
       .then((data) => {
         newPage.innerHTML = data;
       });
       return newPage;
     }
   }
   
   class TabAccount {
     constructor(){
       const newPage = document.createElement("div");
       fetch("server/auto.php?i=accountD")
       .then((response) => response.text())
       .then((data) => {
         newPage.innerHTML = data;
       });
       return newPage;
     }
   }
   
    function toggleFund(thisBtn, toShow, toRemoveDisplay, toRemoveClass){
     const fund_btn = document.querySelectorAll(toRemoveClass);
     const fund_form = document.querySelectorAll(toRemoveDisplay);
     
     fund_btn.forEach(fund_btns => {
       fund_btns.classList.remove("active");
     });
     
     fund_form.forEach(fund_forms => {
       fund_forms.style.display = "none";
     });
     
     thisBtn.classList.add("active");
     if(toShow == "paystack"){
       document.getElementById(toShow).style.display = "grid";
     }else{
       document.getElementById(toShow).style.display = "block";
     }
   }
   
   function fundPay(thisBtn, formToSend){
     const formSend = document.getElementById(formToSend);
     let formerTxt = thisBtn.innerHTML;
     const amount = document.getElementById("amount");
     if(amount.value < 100){
       amount.dispatchEvent(new Event("input"));
     }else{
       showP(thisBtn);
       document.getElementById("cl-fm").disabled = true;
       fetch("server/auto.php?i=fundPaystack", {
         method: "POST",
         body: new FormData(formSend),
       })
       .then(response => response.text())
       .then(data => {
         if(data.includes("https://")){
           showMessage("bi bi-check2-circle", "Payment initiated successfully you will be redirected shortly.", "suc");
           window.location = data;
         }else{
           showMessage("bi bi-x-circle", data, "err");
         }
         removeP(thisBtn, formerTxt);
       });
     }
   }
   
   function moveLeft(toMvLeft, toShow){
     const to_mv_left = document.getElementById(toMvLeft);
     to_mv_left.style.transform = "translateX(-110%)";
     setTimeout(()=> {
       to_mv_left.style.display = "none";
       document.getElementById(toShow).style.display = "block";
     }, 360);
   }
   
   function toggleMode(clickId){
     const click_id_gt = document.getElementById(clickId);
       fetch("server/auto.php?i=modeUpdate")
       .then(response => response.text())
       .then(data => {
         if(data.includes("successfully")){
           click_id_gt.classList.toggle("active");
           document.body.classList.toggle("active");
         }
       });
   }
   
   function showForm(formId, form_d_type, form_d){
     const formGet = document.getElementById(formId);
     if(form_d_type == "open"){
       formGet.style.display = form_d;
     }else{
       formGet.querySelector("form").classList.add("r")
       setTimeout(()=> {
         formGet.style.display = form_d;
         formGet.querySelector("form").classList.remove("r")
       }, 350);
     }
   }
   
   function toggleEye(thisEye, balInn){
     const eyeInn = document.getElementById(balInn);
     let formerBal = eyeInn.innerHTML;
     if(thisEye.className == "ri-eye-line"){
       eyeInn.innerHTML = " ********";
       thisEye.className = "ri-eye-off-line";
     }else{
       eyeInn.innerHTML = '<?php echo $user["format_balance"]; ?>';
       thisEye.className = "ri-eye-line";
     }
   }
 </script>
</body>
</html>
<?php include "includes/notification.php"; ?>