
<?php echo'
:root{
  --box-shadow: 0.6px 3px 5px 0.6px hsl(0, 0%, 93%);
  --box-shadow-two: 0.6px 3px 5px 0.6px hsl(0, 0%, 93%);
  --box-shadow-three: 0 0 3px 1.1px #fff,
                      1px 1px 3px 0 hsl(0, 0%, 89%);
  --box-shadow-four: 0 0 3px 2px #fff,
                      2px 3px 3px 0 hsl(0, 0%, 80%);
  --poppins: "Poppins", Sans-Serif;
  --mitr: "Mitr", Sans-Serif;
  --site-clr:#ff8000;
  --bg: hsl(0, 0%, 99%);
}
span, h1, h2, h3, h4, h5, h6, div, button, table, p, b, i, section, form, em, input, textarea{
  font-family: var(--mitr);
}
input{
  letter-spacing: 0.7px;
}
body{
  font-family: var(--mitr);
  display: flex;
  align-items: center;
  justify-content: center;
  background: var(--bg);
  letter-spacing: 0px;
  transition: overflow 20s;
  user-select: none;
}
body.active{
  background: hsl(0, 0%, 10%);
}

#inn{
  margin-top: 50px;
  width: 100%;
  box-sizing: border-box;
  margin-bottom: 15px;
}
.bottom{
  position: fixed;
  bottom: 0;
  left: 0;
  right: 0;
  background: var(--bg);
  box-sizing: border-box;
  display: grid;
  grid-template-columns: repeat(5, 1fr);
  height:60px;
  z-index: 20;
  align-items: center;
  padding: 0;
}
body.active .bottom{
  box-shadow: none;
  background: hsl(0, 0%, 18%);
}
.bottom .nav{
  text-align: center;
  height: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
  flex-direction: column;
  transition: 0.1s;
  height: 83%;
  width: 90%;
  margin: 0;
  margin-left: 5%;
  margin-right: 5%;
  border-radius: 0px;
}
.bottom .nav img{
  width: 24px;
  height: 24px;
  display: flex;
  align-items: center;
  justify-content: center;
  padding: 2px;
  background: #fff;
  border: 2px solid #888;
  border-radius: 50%;
  box-sizing: border-box;
}
.bottom .nav i{
  font-size: 15px;
  color: #333;
  display: flex;
  align-items: center;
  margin-bottom: 0;
  margin-top: 0;
  transition: 0.1s;
  font-weight: 100;
  box-sizing: border-box;
  height: 23px;
}
body.active .bottom .nav i{
  color: hsl(0, 0%, 97%);
}
.bottom .nav span{
  font-size: 7px;
  margin-bottom: 0;
  margin-top: 5px;
  color: #555;
  font-weight: 900;
  transition: 0.1s;
  display: block;
  letter-spacing: 0.4px;
}
body.active .bottom .nav span{
  color: hsl(0, 0%, 97%);
}
.bottom .indicator{
  position: absolute;
  top: 0px;
  width: 19.7%;
  height: 2px;
  background: var(--site-clr);
  transition: 0.5s;
  padding: 1px;
}
.bottom .nav.active:nth-child(1) ~ .indicator{
  transform: translateX(calc(100% * 0));
}
.bottom .nav.active:nth-child(2) ~ .indicator{
  transform: translateX(calc(100% * 1));
}
.bottom .nav.active:nth-child(3) ~ .indicator{
  transform: translateX(calc(100% * 2));
}
.bottom .nav.active:nth-child(4) ~ .indicator{
  transform: translateX(calc(100% * 3));
}
.bottom .nav.active:nth-child(5) ~ .indicator{
  transform: translateX(calc(100% * 4));
}
.bottom .nav.active{
  color: var(--site-clr);
  background: transparent;
}
body.active .bottom .nav.active{
  background: linear-gradient(hsl(0, 0%, 100%, 0.05), hsl(0, 0%, 100%, 0));
}
.bottom .nav.active img{
  border: 2px solid var(--site-clr);
}
.bottom .nav.active i{
 background:blue;
 -webkit-background-clip:text;
 -webkit-text-fill-color:transparent
}
body.active .bottom .nav.active i{
  color: var(--site-clr);
}
.bottom .nav.active span{
  color: blue;
  font-weight: 800;
}
body.active .bottom .nav.active span{
  color: blue;
}


/* Home design */
.welcome{
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 10px;
  padding: 2px;
  box-sizing: border-box;
  width: 100%;
}
.welcome span{
  font-size: 11px;
  font-weight: 600;
  color: #0000ff;
}
body.active .welcome span{
  color: hsl(0, 0%, 97%);
}
.welcome span b{
  font-weight: 400;
}
.welcome .button{
  padding: 8px;
  background: rgba(69%, 0%, 30%, 0.1);
  color: var(--site-clr);
  height: 32px;
  width: 80px;
  border-radius: 25px;
  border: none;
  outline: none;
  font-family: var(--mitr);
  font-weight: 900;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 10px;
  position: relative;
  box-sizing: border-box;
  z-index: 3;
  user-select: none;
  letter-spacing: 1px;
}
body.active .welcome .button{
  border: 1px solid #fff;
  background: transparent;
}
.welcome .button .span{
  color: var(--site-clr);
}
.welcome .button .span i{
  margin-left: 6px;
  font-size: 11px;
}
body.active .welcome .button .span{
  color: #fff;
}
.welcome .button .currency{
  position: absolute;
  top: 37px;
  left: -2px;
  width: 82px;
  height: 100px;
  box-sizing: border-box; 
  border-radius: 12px;
  background: rgba(80%, 0%, 50%, 0.3);
  backdrop-filter: blur(50px);
  overflow: hidden;
  display: none;
  animation: dropDown 0.4s;
  color: #fff;
  z-index: 10;
}
body.active .welcome .button .currency{
  background: rgba(80%, 0%, 50%, 0.3);
  backdrop-filter: blur(50px);
  color: hsl(0, 0%, 97%);
}
@keyframes dropDown{
  0%{
    height: 0px;
  }
  100%{
    height: "";
  }
}
.welcome .button .currency div{
  padding: 10px;
  box-sizing: border-box;
  width: 100%;
  height: 33px;
}
.welcome .button .span:hover ~ .currency,
.welcome .button .span:active ~ .currency{
  display: block;
}
.t-topic b{
    font-size: 14px;
    color: #0000ff;
    font-weight: 900;
    display: block;
    margin: 0;
    margin-top: 10px;
}
.t-topic span{
    font-size: 10px;
    color: #666;
    font-weight: 300;
    display: block;
    margin-bottom: 20px;
}
.dash{
  padding: 20px;
  padding-bottom: 43px;
  box-sizing: border-box;
  width: 100%;
  background: var(--site-clr);

  color: #fff;
  display: flex;
  align-items: center;
  margin-bottom: 15px;
  flex-direction: column; 
  position: relative;
  overflow: hidden;
  height: 165px;
}
.dash .left span{
    display: block;
    margin: 0;
    margin-bottom: 5px;
    font-size: 13px;
    font-weight: 300;
    color: #fff;
    text-align: center;
}
.dash .left b b{
    margin-bottom: 0;
}
.dash .left b{
    display: flex;
    align-items: center;
    margin: 0;
    margin-bottom: 10px;
    text-align: center;
    font-size: 17px;
    font-weight: 900;
}
.dash .left b i{
    margin-left: 20px;
}
.dash a{
    color: #fff;
}
.dash .right{
    padding: 10px;
    background: hsl(0, 0%, 100%, 40%);
   margin-bottom:20px;
    height: 53px;
    display: flex;
    margin: 0;
    align-items: center;
    justify-content: center;
    width: 180px;
    font-size: 13px;
   
}
.dash .right i{
    margin-left: 10px;
}
.services-details{
  margin-top: 0px;
}
.user-topic{
  width: 100%;
  box-sizing: border-box;
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-top: 10px;
  padding: 5px;
}
.user-topic span{
  font-size: 11.6px;
  font-weight: 800;
}
body.active .user-topic span{
  color: hsl(0, 0%, 97%);
}
.user-topic button{
  background: rgba(60%, 0%, 25%, 0.1);
  padding: 10px;
  height: 18px;
  border: none;
  outline: none;
  color: var(--site-clr);
  font-size: 9px;
  font-weight: 900;
  font-family: var(--mitr);
  line-height: 0;
  border-radius: 25px;
  border: 1px solid rgba(70%, 0%, 30%, 0.15);
}
body.active .user-topic button{
  border: 1px solid #fff;
  color: #fff;
  background: transparent;
}
.services-body{
  padding: 3px;
  background: transparent;
  color: #000;
  font-size: 12px;
  display: grid;
  grid-template-columns: repeat(4, 1fr);
  grid-column-gap: 10px;
  grid-row-gap: 10px;
  align-items: start;
  width: 100%;
  box-sizing: border-box;
  border-radius: 6px;
  margin-top: 15px;
  overflow: hidden;
}
body.active .services-body{
  box-shadow: 0.5px 2px 3px 1px hsl(0, 0%, 0%);
  background: hsl(0, 0%, 20%);
}
.services-body .services{
  padding: 10px;
  display: flex;
  align-items: center;
  justify-content: center;
  flex-direction: column;
  position: relative;
  text-align: center;
  width: 100%;
  background: #fff;
  border-radius: 11px;
}
.services-body .services i{
  font-size: 21px;
  display: flex;
  align-items: center;
  justify-content: center;
  color: var(--site-clr);
  margin: 0;
  margin-top: 0px;
  width: 30px;
  height: 30px;
}
.services-body .services span{
  font-size: 8px;
  font-weight: 400;
  color: #333;
  display: block;
  margin-top: 5px;
  letter-spacing: 0.4px;
}
body.active .services-body .services span{
  color: hsl(0, 0%, 95%);
}
.v-all{
  display: flex;
  align-items: center;
  justify-content: center;
  margin-top: 15px;
}
.v-all button{
  padding: 10px;
  background: rgba(70%, 0%, 40%, 0.1);
  color: var(--site-clr);
  border-radius: 25px;
  outline: none;
  border: none;
  width: 95px;
  height: 40px;
  line-height: 0;
  font-family: var(--mitr);
  font-size: 10px;
  border: 1px solid rgba(79%, 0%, 30%, 0.15);
  display: flex;
  align-items: center;
  justify-content: center;
}
body.active .v-all button{
  background: transparent;
  color: hsl(0, 0%, 90%);
  border: 1px solid hsl(0, 0%, 90%);
}
.v-all button i{
  margin-left: 7px;
  transform: rotate(179deg);
}
 a{
  text-decoration: none;
}
 a:link{
   cursor: none;
 }
 
 /*  fund design */
 .fund-payment-link-body{
   padding: 20px;
   width: 100%;
   box-sizing: border-box;
   box-shadow: var(--box-shadow-two);
   background: #fff;
   border-radius: 5px;
   word-break: break-word;
   margin-top: 15px;
 }
 body.active .fund-payment-link-body{
   box-shadow: 0.5px 3px 3px 0.5px hsl(0, 0%, 0%);
   background: hsl(0, 0%, 17%);
 }
 .fund-payment-link-body div{
   display: flex;
   align-items: center;
 }
 .fund-payment-link-body h2{
   margin-top: 0;
   margin-bottom: 3px;
   font-size: 11px;
   font-weight: 900;
   color: #222;
 }
 body.active .fund-payment-link-body h2{
   color: hsl(0, 0%, 83%);
 }
 .fund-payment-link-body div{
   border: 1px dashed var(--site-clr);
   padding: 10px;
   border-radius: 2px;
 }
 body.active .fund-payment-link-body div{
   border: 1px dashed #fff;
 }
 .fund-payment-link-body div span{
   font-size: 10px;
   color: var(--site-clr);
   font-weight: 600;
   flex: 1;
 }
 body.active .fund-payment-link-body div span{
   color: #fff;
 }
 .fund-payment-link-body div button{
   padding: 5px;
   height: 28px;
   background: transparent;
   color: rgba(0%, 60%, 0%);
   border-radius: 5px;
   font-size: 9px;
   line-height: 0;
   border: none;
   outline: none;
   font-family: var(--mitr);
   line-height: 0;
 }
 .fund-methods{
   width: 100%;
   box-sizing: border-box;
   padding: 20px;
   background: #fff;
   box-shadow: var(--box-shadow-two);
   border-radius: 4px;
   transition: height 0.5s;
 }
 body.active .fund-methods{
   background: hsl(0, 0%, 17%);
   box-shadow: 0.5px 3px 3px 0.5px hsl(0, 0%, 0%);
 }
 .fund-methods .how{
   width: 100%;
   box-sizing: border-box;
   margin-top: 20px;
 }
 .fund-methods .h-sep{
   display: flex;
   align-items: center;
   justify-content: space-between;
   margin-bottom: 17px;
   margin-top: 8px;
   width: 100%;
   box-sizing: border-box;
 }
 .fund-methods .h-sep div:nth-child(1){
   text-align: left;
 }
 .fund-methods .h-sep div:nth-child(2){
   text-align: right;
 }
 .fund-methods .h-sep div b{
   font-size: 12px;
   color: #222;
   font-weight: 800;
   display: block;
   margin: 0;
 }
 body.active .fund-methods .h-sep div b{
   color: hsl(0, 0%, 100%);
 }
 .fund-methods .h-sep div span{
   font-size: 11px;
   color: #555;
   font-weight: 300;
   display: block;
   margin: 0;
 }
 body.active .fund-methods .h-sep div span{
   color: hsl(0, 0%, 80%);
 }
 .fund-methods .how .h-t{
   font-size: 11.5px;
   font-weight: 500;
   color: rgba(0%, 60%, 0%);
   margin: 0;
   margin-bottom: 2px;
 }
 .fund-methods .fund-buttons{
   display: flex;
   align-items: center;
   justify-content: space-between;
   margin-top: 0px;
   width: 100%;
   box-sizing: border-box;
 }
 .fund-methods .fund-buttons .fund-btn{
   padding: 10px;
   width: 50%;
   background: #fff;
   border: 1px solid hsl(0, 0%, 90%);
   border-radius: 0px;
   height: 45px;
   outline: none;
   font-size: 8px;
   font-family: var(--mitr);
   color: #444;
   display: inline-flex;
   align-items: center;
   justify-content: center;
 }
 .fund-methods .fund-buttons .fund-btn:nth-child(1){
   border-top-left-radius: 20px;
   border-bottom-left-radius: 20px;
   border-right: 1px solid hsl(0, 0%, 90%);
 }
 .fund-methods .fund-buttons .fund-btn:nth-child(3){
   border-top-right-radius: 20px;
   border-bottom-right-radius: 20px;
   border-left: 0.3px solid hsl(0, 0%, 90%);
 }
 .fund-methods .fund-buttons .fund-btn.active{
   background: rgba(0%, 55%, 80%);
   color: #fff;
   border: 0.3px solid rgba(0%, 55%, 80%);
 }
 .fund-methods .top-txt{
  margin-top:0; 
  margin-bottom:20px; 
  font-size:11px;
  font-weight:900; 
  color:#000;
 }
 body.active .fund-methods .top-txt{
   color: hsl(0, 0%, 80%);
 }
 .fund-methods .fund-form{
   padding: 20px;
   box-shadow: var(--box-shadow-four);
   background: hsl(0, 0%, 95%);
   border-radius: 4px;
   margin-top: 15px;
   position: relative;
   transition: height 3s;
 }
 body.active .fund-methods .fund-form{
   background: hsl(0, 0%, 8%);
   box-shadow: none;
 }
 .soon{
   text-align: center;
   width: 100%;
   background: hsl(0, 0%, 93%);
   color: #222;
   padding: 20px;
   box-sizing: border-box;
 }
 .soon i{
   font-size: 40px;
 }
 .soon span{
   font-size: 8px;
   display: block;
   margin-bottom: 0;
   margin-top: 10px;
 }
 .help{
   text-align: right;
   font-size: 10px;
   color: var(--site-clr);
   font-weight: 900;
   margin-top: 13px;
 }
 body.active .help{
   color: hsl(0, 0%, 85%);
 }
 .help i{
   margin-right: 3px;
 }
 .fund-methods .fund-form.sep{
   display: grid;
   grid-template-columns: repeat(2, 1fr);
   grid-column-gap: 3px;
   padding: 10px;
 }
 .fund-methods .fund-form button{
   padding: 10px;
   background: transparent;
   color: var(--site-clr);
   border-radius: 4px;
   outline: none;
   border: 1px solid var(--site-clr);
   width: 96%;
   font-family: var(--mitr);
   text-align: center;
   height: 35px;
   margin: 4px;
   font-size: 9px;
   line-height: 0;
   font-weight: 600;
   letter-spacing: 1px;
 }
 body.active .fund-methods .fund-form button{
   border: 1px solid hsl(0, 0%, 90%);
   color: hsl(0, 0%, 90%);
 }
 .fund-methods .fund-form button img{
   width: 20px;
   height: 20px;
   border-radius: 3px;
   margin-right: 4px;
 }
 .fund-methods .fund-form button span{
   font-size: 9px;
   font-weight: 900;
   text-align: center;
 }
 .recent-transaction{
   margin-top: 15px;
 }
 .fund-other{
   display: grid;
   grid-template-columns: repeat(2, 1fr);
   grid-column-gap: 15px;
   align-items: start;
 }
 .fund-other .fund-option{
   padding: 15px;
   background: #fff;
   box-shadow: var(--box-shadow-two);
   border-radius: 3px;
   margin-bottom: 15px;
   position: relative;
   overflow: hidden;
 }
 .fund-other .fund-option .n-av{
   padding: 15px;
   height: 100%;
   width: 100%;
   box-sizing: border-box;
   background: hsl(0, 0%, 10%, 0.4);
   position: absolute;
   top: 0;
   bottom: 0;
   left: 0;
   right: 0;
   display: flex;
   align-items: center;
   justify-content: center;
   font-size: 7.5px;
   font-weight: 900;
   color: #fff;
   text-align: center;
   flex-direction: column;
 }
 body.active .fund-other .fund-option .n-av{
   background: hsl(0, 0%, 10%, 0.7);
 }
 .fund-other .fund-option .n-av i{
   font-size: 25px;
   margin-bottom: 5px;
 }
 body.active .fund-other .fund-option{
   background: hsl(0, 0%, 17%);
   box-shadow: 0.5px 3px 3px 0.5px hsl(0, 0%, 0%);
 }
 .fund-other .fund-option b{
   font-size: 11px !important;
   display: block;
   margin-bottom: 7px;
   margin-top: 0;
   color: #000;
 }
 body.active .fund-other .fund-option b{
   color: hsl(0, 0%, 100%);
 }
 .fund-other .fund-option span{
   color: #444;
   font-size: 8px !important;
   display: block;
   margin-bottom: 0;
   margin-top: 0;
 }
 body.active .fund-other .fund-option span{ 
   color: hsl(0, 0%, 85%);
 }
 .fund-other .fund-option button{
   font-size: 10px;
   background: transparent;
   color: var(--site-clr);
   font-weight: 900;
   border: none;
   outline: none;
   margin-top: 15px;
   padding: 0;
   font-family: var(--mitr);
   letter-spacing: 1px;
   box-shadow: border-box;
 }
 body.active .fund-other .fund-option button{
   background: rgba(0%, 60%, 0%, 0.1);
   border: 1px solid rgba(0%, 60%, 0%);
   color: rgba(0%, 60%, 0%);
   padding: 6px;
   border-radius: 2px;
   height: 23px;
   line-height: 0;
 }
 .fund-other .fund-option button i{
   margin-left: 3px;
 }
 .fixed-fund{
   position: fixed;
   top: 0;
   bottom: 0;
   left: 0;
   right: 0;
   background: hsl(0, 0%, 10%, 0.5);
   z-index: 50;
   box-sizing: border-box;
   display: none;
   justify-content: center;
   align-items: center;
 }
 .fixed-fund form{
   padding: 14px;
   background: #fff;
   border-radius: 5px;
   box-sizing: border-box;
   width: 290px;
   animation: drawD 0.4s;
 }
 .fixed-fund form.r{
   animation: drawDT 0.4s;
 }
 @keyframes drawD{
   0%{
    transform: translateY(-30%); 
    opacity: 0;
   }
   100%{
    transform: translateY(0%); 
    opacity: 1;
   }
 }
 @keyframes drawDT{
   0%{
    transform: translateY(0%); 
    opacity: 1;
   }
   100%{
    transform: translateY(-30%); 
    opacity: 0;
   }
 }
 .fixed-fund form .inputs{
   display: block;
   margin: 0;
   margin-bottom: 25px;
   width: 100%;
   box-sizing: border-box;
 }
 .fixed-fund form .button{
   background: var(--site-clr);
   font-family: var(--mitr);
   width: 100%;
   height: 48px;
   font-size: 11px;
   font-weight: 900;
   border-radius: 9px;
   box-sizing: border-box;
   outline: none;
   margin: 0;
   color: #fff;
   border: none;
   letter-spacing: 1px;
 }
 .fixed-fund form .inputs span{
   display: block;
   margin: 0;
   font-size: 9px;
   color: #444;
   box-sizing: border-box;
   font-weight: 900;
 }
 .fixed-fund form .inputs input::placeholder{
   color: #9997;
   font-size: 12px;
   font-weight: 800;
 }
 .fixed-fund form .inputs input{
   width: 100%;
   height: 48px;
   border: 0.9px solid #000;
   border-radius: 9px;
   padding: 10px;
   outline: none;
   background: #fff;
   box-sizing: border-box;
   font-weight: 900;
   font-size: 12px;
   letter-spacing: 0;
   margin-top: 3px;
   font-family: var(--mitr);
 }
 .fixed-fund form .f-txt{
   display: flex;
   align-items: center;
   margin-bottom: 15px;
   width: 100%;
   box-sizing: border-box;
 }
 .fixed-fund form .f-txt span{
   flex: 1;
   font-size: 13px;
   color: #333;
   font-weight: 500;
 }
 .fixed-fund form .f-txt i{
   color: rgba(100%, 0%, 0%);
   font-size: 15px;
 }
 
 
 
 .create-plan{
   text-align: center;
   width: 100%;
   box-sizing: border-box;
   margin-bottom: 50px;
   transition: 0.4s;
 }
 .create-plan img{
   width: 340px;
   height: 220px;
   margin-left: -2%;
   box-sizing: border-box;
 }
 .create-plan .create-txt{
   text-align: center;
   width: 100%;
   box-sizing: border-box;
 }
 .create-plan .create-txt h2{
   font-size: 18px;
   font-weight: 900;
   color: #111;
   text-align: center;
   margin-bottom: 15px;
   margin-top: 40px;
 }
 body.active .create-plan .create-txt h2{
   color: hsl(0, 0%, 90%);
 }
 .create-plan .create-txt span{
   font-size: 11px;
   color: #555;
   font-weight: 200;
   text-align: center;
   display: block;
   margin: 0;
   margin-bottom: 45px;
   letter-spacing: 0.2px;
 }
 body.active .create-plan .create-txt span{
   color: hsl(0, 0%, 80%);
   width: 90%;
 }
 .create-plan .create-txt button{
   padding: 10px;
   height: 45px;
   border-radius: 3px;
   font-size: 11px;
   color: #fff;
   background: var(--site-clr);
   font-family: var(--mitr);
   border: none;
   outline: none;
   width: 305px;
   font-weight: 900;
   letter-spacing: 1px;
 }
 .create-method{
   display: none;
   animation: toLeft 0.2s;
 }
 .create-method .create-method-divs{
   margin-bottom: 24px;
   margin-top: 5px;
   padding: 20px;
   width: 100%;
   box-sizing: border-box;
   border-radius: 7px;
   background: hsl(0, 0%, 91%);
 }
 .create-method .create-method-divs h2{
   font-size: 14px;
   color: var(--site-clr);
   margin: 0;
   margin-bottom: 10px;
   font-weight: 500;
   display: flex;
   align-items: center;
   margin-top: 0;
 }
 .create-method .create-method-divs h2 i{
   margin-right: 10px;
   color: var(--site-clr);
   font-size: 17px;
   padding: 4px;
   width: 20px;
   height: 20px;
   background: #fff;
   border-radius: 7px;
   text-align: center;
   font-weight: 300;
   line-height: 20px;
   box-shadow: var(--box-shadow);
 }
 .create-method .create-method-divs span{
   font-size: 9px;
   color: #444;
   display: block;
   margin: 0;
 }
 @keyframes toLeft{
   0%{
     transform: translateX(100%);
   }
   100%{
     transform: translateX(0%);
   }
 }
 
 
 
 .support{
   background: transparent;
   display: flex;
   align-items: center;
   width: 100%;
   box-sizing: border-box;
   height: 63px;
 }
 .support i{
   padding: 10px;
   box-sizing: border-box;
   width: 33px;
   height: 33px;
   color: var(--site-clr);
   border-radius: 50%;
   display: flex;
   align-items: center;
   justify-content: center;
   margin-right: 10px;
   background: rgba(70%, 0%, 30%, 0.2);
 }
 body.active .support i{
   border: 1px solid var(--site-clr);
 }
 .support div{
   flex: 1;
 }
 .support div h2{
   color: #111;
   font-weight: 0;
   margin: 0;
   margin-bottom: 0px;
   font-size: 12px;
   letter-spacing: 0.5px;
 }
 body.active .support div h2{
   color: hsl(0, 0%, 100%);
 }
 .support div span{
   display: block;
   margin: 0;
   color: #777;
   font-weight: 200;
   font-size: 8px;
   letter-spacing: 0.4px;
 }
 body.active .support div span{
   color: hsl(0, 0%, 80%);
 }
 
 
 .profile-info{
   display: flex;
   align-items: center;
 }
 .profile-info .p-left{
   flex: 1;
   display: flex;
   align-items: center;
 }
 .profile-info .p-left img{
   padding: 5px;
   box-sizing: border-box;
   width: 55px;
   height: 55px;
   border: 2px solid #222;
   border-radius: 50%;
   margin-right: 5px;
   background: #fff;
 }
 .profile-info .p-left .p-left-left b{
   font-weight: 900;
   color: #222;
   font-size: 13px;
   direction: block;
   margin: 0;
   letter-spacing: 0.3px;
 }
 body.active .profile-info .p-left .p-left-left b{
   color: hsl(0, 0%, 90%);
 }
 .profile-info .p-left .p-left-left{
   display: flex;
   align-items: center;
   flex-direction: column;
   justify-content: flex-start;
 }
 .profile-info .p-left .p-left-left span{
   color: #777;
   font-size: 9px;
   font-weight: 300;
   direction: block;
   margin: 0;
   letter-spacing: 0.3px;
 }
 .profile-info .p-right i{
   padding: 8px;
   box-sizing: border-box;
   width: 50px;
   height: 50px;
   border-radius: 50%;
   text-align: center;
   line-height: 22px;
   color: var(--site-clr);
   background: rgba(70%, 0%, 30%, 0.1);
   font-size: 16px;
   margin-right: 5px;
   margin-left: 5px;
 }
 body.active .profile-info .p-right i{
   border: 1px solid var(--site-clr);
 }
 .p-other{
   margin-top: 10px;
   width: 100%;
   box-sizing: border-box;
   display: flex;
   align-items: center;
   box-shadow: none;
   border-radius: 4px;
   padding: 16px;
   background: hsl(0, 0%, 92%);
 }
 body.active .p-other{
   background: hsl(0, 0%, 18%);
   box-shadow: none;
 }
 .p-other .p-o-left{
   flex: 1;
   text-align: left;
 }
 .p-other .p-o-left span{
   font-size: 7.5px;
   color: #666;
   font-weight: 200;
   display: block;
   margin: 0;
   letter-spacing: 0.5px;
 }
 body.active .p-other .p-o-left span{
   color: hsl(0, 0%, 75%);
 }
 .p-other .p-o-left b{
   font-weight: 600;
   color: var(--site-clr);
   display: block;
   margin: 0;
   font-size: 9px;
   margin-top: 5px;
   width: 90%;
 }
 body.active .p-other .p-o-left b{
   color: #fff;
 }
 .p-other.n:nth-first{
   margin-top: 25px;
 }
 .p-other.n .p-o-left span{
   color: #222;
   font-weight: 900;
   font-size: 10px;
 }
 body.active .p-other.n span{
   color: hsl(0, 0%, 95%);
 }
 .p-other.n .p-o-left b{
   font-size: 8px;
   color: #666;
   font-weight: 200;
 }
 body.active .p-other.n b{
   color: hsl(0, 0%, 80%);
 }
 .p-other button{
   padding: 10px;
   width: 55px;
   color: rgba(0%, 60%, 0%);
   display: flex;
   align-items: center;
   justify-content: center;
   font-size: 9px;
   border: none;
   outline: none;
   background: transparent;
   font-family: var(--mitr);
   font-weight: 900;
   letter-spacing: 1px;
 }
 .p-other button i{
   margin-left: 5px;
   font-size: 9px;
 }
 body.active .p-other i.fas.fa-chevron-right{
   color: hsl(0, 0%, 90%);
 }
 .toggle{
   position: relative;
 }
 .toggle .span{
   display: block;
   width: 50px;
   height: 25px;
   border-radius: 14px;
   background: rgba(0%, 50%, 90%, 0.1);
   border: 1px solid rgba(0%,  50%, 90%, 0.2);
   box-sizing: border-box;
 }
 .toggle .span.active{
   background: rgba(0%, 60%, 0%, 0.1);
   border: 1px solid rgba(0%, 80%, 0%, 0.8);
 }
 .toggle .b{
   background: rgba(0%, 50%, 90%);
   border-radius: 50%;
   padding: 2px;
   height: 10px;
   width: 10px;
   display: block;
   position: absolute;
   top: 5.8px;
   left: 5px;
   transition: 0.3s;
 }
 .toggle .span.active ~ .b{
   transform: translateX(26px);
   background: #fff;
 }
@media screen and (max-width: 761px){
  #inn{
    padding: 7px;
  }
  .home-grid{
    display: grid;
    grid-template-columns: repeat(1, 1fr);
    grid-column-gap: 10px;
  }
  .fund{
    display: grid;
    grid-template-columns: repeat(1, 1fr);
    margin-bottom: 50px;
  }
  .fund-methods{
    margin-top: 15px;
  }
  .fund-other{
    margin-top: 15px;
  }
  .create-method{
    grid-template-columns: repeat(1, 1fr);
  }
  .support-box{
    display: grid;
    grid-template-columns: repeat(1, 1fr);
  }
}

@media screen and (min-width: 762px){
  #inn{
    padding: 20px;
  }
  .home-grid{
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    grid-column-gap: 18px;
    align-items: start;
    width: 100%;
    box-sizing: border-box;
  }
  .fund{
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    grid-column-gap: 15px;
    align-items: start;
  }
  .services-details{
    width: 90%;
    box-sizing: border-box;
  }
  .services-details-trans{
    width: 110%;
    box-sizing: border-box;
    margin-left: -10%;
  }
  .fund-payment-link-body{
    margin-top: 15px;
    margin-bottom: 0;
  }
  .fund-other{
    margin-top: 0px;
  }
  .create-method{
    grid-template-columns: repeat(3, 1fr);
    grid-column-gap: 10px;
  }
  .support-box{
    display: grid;
    grid-template-columns: repeat(1, 1fr);
    grid-column-gap: 10px;
  }
}
 
.alertErr,
.alertSuc{
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  z-index: 60;
  display: flex;
  align-items: center;
  justify-content: center;
  background: hsl(0, 0%, 10%, 0.4);
  transition: 0.25s;
}
.alertErr .adiv,
.alertSuc .adiv{
  padding: 0px;
  border-radius: 16px;
  background: #fff;
  width: 290px;
  box-shadow: border-box;
  word-break: break-word;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  animation: zoomInMsg 0.2s;
  transition: 0.25s;
  overflow: hidden;
}
@keyframes zoomInMsg{
  from{
    transform: scale(0.9);
    opacity: 0.1;
  }
  to{
    transform: scale(1);
    opacity: 1;
  }
}
.alertErr .adiv i,
.alertSuc .adiv i{
  font-size: 50px;
  margin-bottom: 5px;
  margin-top: 20px;
}
.alertErr .adiv span,
.alertSuc .adiv span{
  font-size: 13px;
  font-weight: 400;
  color: #222;
  margin-top: 10px;
  margin-bottom: 18px;
  text-align: center;
  padding: 0px;
  padding-left: 13px;
  padding-right: 13px;
}
.alertSuc .adiv i{
  color: rgba(0%, 50%, 0%);
}
.alertErr .adiv i{
  color: rgba(80%, 0%, 0%);
}
.alertErr .adiv .button,
.alertSuc .adiv .button{
  display: inline-flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  box-sizing: border-box;
  margin-bottom: 0;
  border-top: 1px solid hsl(0, 0%, 70%);
  padding-top: 0px;
}
.alertErr .adiv .button button,
.alertSuc .adiv .button button{
  padding: 10px;
  color: #fff;
  line-height: 0;
  display: flex;
  align-items: center;
  justify-content: center;
  outline: none;
  border-radius: 0px;
  height: 45px;
  width: 50%;
  font-size: 12px;
  font-family: var(--mitr);
  background: #fff;
  color: #666;
  border: none;
}
.alertErr .adiv .button button:hover,
.alertSuc .adiv .button button:hover,
.alertErr .adiv .button button:active,
.alertSuc .adiv .button button:active{
  background: hsl(0, 0%, 90%);
}
.alertSuc .adiv .button #cancelBtn,
.alertErr .adiv .button #cancelBtn{
  border-right: 0.8px solid hsl(0, 0%, 70%);
}
.alertErr .adiv .button #okBtn,
.alertSuc .adiv .button #okBtn{
  border-left: 0.8px solid hsl(0, 0%, 70%);
}
.spin{
  padding: 2px;
  height: 25px;
  width: 25px;
  box-sizing: border-box;
  border: 2.7px solid #fff;
  border-top: 2.7px solid #0003;
  background: transparent;
  border-radius: 50%;
  animation: infinitySpin 0.5s linear infinite;
  display: inline-block;
}
@keyframes infinitySpin{
  0%{
    transform: rotate(0deg);
  }
  100%{
    transform: rotate(360deg);
  }
}
.transaction-detail{
  padding:15px; 
  background: hsl(0, 0%, 100%); 
  color: #222;
  border-radius: 5.7px; 
  display: flex; 
  align-items: center;
  margin-bottom: 10px;
  box-shadow: 0.6px 3px 3px 0.6px #0001; 
  word-break: break-word;
  font-family: var(--mitr);
}
body.active .transaction-detail{
  background: hsl(0, 0%, 21%);
  box-shadow: 0.5px 2px 3px 0.5px hsl(0, 0%, 0%);
}
.transaction-detail i{
  padding: 10px; 
  height: 30px;
  width: 30px;
  border-radius: 50%;
  display: flex; 
  align-items: center;
  justify-content: center; 
  font-size: 15px;
  margin-right: 10px;
  box-sizing: border-box;
}
.transaction-detail .left{
  flex:1;
  text-align:left; 
  width:60%;
}
.transaction-detail .left .span{
  font-size: 11.5px; 
  color: #444; 
  display: block;
  margin-bottom: 3px; 
  margin-top: 0; 
  font-weight: 900;
}
body.active .transaction-detail .left .span{
  color: hsl(0, 0%, 97%);
}
.transaction-detail .left .b{
  font-size: 10px; 
  display: inline-block; 
  margin-bottom: 0; 
  margin-top: 0; background: transparent; 
  color: #666;
  padding: 0px; 
  border-radius: 6px;
  height: 15px; 
  box-sizing: border-box;
  width: 100%; 
  text-align: left;
  font-size: 8px;
  font-weight: 300;
}
body.active .transaction-detail .left .b{
  color: hsl(0, 0%, 97%);
}
.transaction-detail .right{
  text-align: 
  right;
  width: 40%;
}
.transaction-detail .right .span{
  font-size: 10px; 
  display: block; 
  margin-bottom: 0; 
  margin-top: 5px; 
  margin-bottom: 5px;
  color: #555; 
  font-weight: 900;
}
body.active .transaction-detail .right .span{
  color: hsl(0, 0%, 97%);
}
.transaction-detail .right .span.t{
  font-size: 7px;
}
@keyframes over{
  from{
    transform: translateY(-7px);
    opacity: 0;
  }
  to{
    transform: translateY(0px);
    opacity: 1;
  }
}
@keyframes overUp{
  from{
    transform: translateY(0px);
    opacity: 1;
  }
  to{
    transform: translateY(-6px);
    opacity: 0;
  }
}

.slider {
  display: flex;
  overflow-x: auto;
  scroll-snap-type: x mandatory;
  scroll-behavior: smooth;
  -webkit-overflow-scrolling: touch;
  margin: 10px 0; /* Adjust this value to change the space above and below the slider */
  box-sizing: border-box;
  width: 100%;
  margin-top: 30px;
  margin-bottom: 20px;
}

.slider .slide {
  scroll-snap-align: start;
  flex-shrink: 0;
  width: 85%; /* Adjust the width */
  height: 43px;
  background: rgba(0%, 50%, 70%, 0.1);
  transform-origin: center center;
  transform: scale(1);
  position: relative;
  display: flex;
  border-left: 5px solid var(--site-clr);
  justify-content: space-between;
  align-items: center;
  margin: 0 10px; 
  padding: 10px;
  padding-right: 0;
  border-top-left-radius: 3px;
  border-bottom-left-radius: 3px;
}
.slider .slide b{
  font-size: 12px;
  font-weight: 500;
  color: var(--site-clr);
  display: block;
  line-height: 15px;
}
.slider .slide a{
  display: inline-block;
  margin-right: 0;
  width: auto;
}
.slider .slide button{
  padding: 10px;
  height: 40px;
  background: var(--site-clr);
  color: #fff;
  font-weight: 600;
  border: none;
  outline: none;
  border-radius: 5px;
  border-bottom: 2px solid rgba(30%, 0%, 0%);
  margin-left: 5px;
  display: flex;
  justify-content: center;
  align-items: center;
  min-width: 90px;
}'
?>
