<?php
  include_once "../server/conn.php";
  
 if($_SERVER["REQUEST_METHOD"] === "POST"){
   $sender_id = htmlspecialchars(mysqli_real_escape_string($conn, $_POST["sender"]));
   $reciever_id = htmlspecialchars(mysqli_real_escape_string($conn, $_POST["reciever"])); 
   $output = "";
   $empty = "";
   
   if(!empty($sender_id) && !empty($reciever_id)){
     $sql = "SELECT * FROM message WHERE (sender = ? AND reciever = ?) OR (sender = ? AND reciever = ?)";
     $stmt = $conn->prepare($sql);
     $stmt->bind_param("ssss", $sender_id, $reciever_id, $reciever_id, $sender_id);
     $stmt->execute();
     $res = $stmt->get_result();
     if($res->num_rows > 0){
      while($row = $res->fetch_assoc()){
        $originalMessage = $row["msg"];
        
        $originalMessage = preg_replace_callback('/\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Z|a-z]{2,}\b/', function ($matches) {
                return "<a href='mailto:{$matches[0]}' style='text-decoration:none;'>{$matches[0]}</a>";
            }, $originalMessage);
            
        $originalMessage = preg_replace_callback('/\b(?:https?|ftp):\/\/\S+\b/', function ($matches) {
                return "<a href='{$matches[0]}' target='_blank' style='text-decoration:none;'>{$matches[0]}</a>";
            }, $originalMessage);
            
            
          $storedDateTime = new DateTime($row["date"]);
          $currentDateTime = new DateTime();
          $interval = $currentDateTime->diff($storedDateTime);
          if ($interval->d > 0) {
              $time =  $interval->d . ($interval->d == 1 ? "day ago" : "days ago");
          } elseif ($interval->h > 0) {
              $time =  $interval->h . ($interval->h == 1 ? " hour ago" : " hours ago");
          } elseif ($interval->i > 0) {
              $time =  $interval->i . ($interval->i == 1 ? " minute ago" : " minutes ago");
          } else {
              $time = "just now";
          }
          
          
        if($row["sender"] === $sender_id){
          
          if(empty($row["msg"])){
                $output .= "
                <div class='rec r'>
                 <img src='http://".$_SERVER["HTTP_HOST"]."/app/chatimage/{$row["image"]}' alt='upload' id='imgs'>
                </div>
                ";
          }else{
            $output .= "
            <div class='rec r'>
             <div>{$originalMessage}<br><span>{$time}</span></div>
            </div>
          ";
          }
          
        }else{
          
          if(empty($row["msg"])){
            $output .= "
            <div class='rec r'>
            <i class='fas fa-user-circle'></i>
             <img src='http://".$_SERVER["HTTP_HOST"]."/app/chatimage/{$row["image"]}' alt='upload'>
            </div>
            ";
          }else{
            $output .= "
            <div class='rec l'>
              <i class='fas fa-user-circle'></i>
              <div>{$originalMessage}<br><span>{$time}</span></div>
            </div>
            ";
          }
          
        }
      }
     }else{
       echo "";
     }
   }
   echo $output;
 }
?>