<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/service.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Cable TV Subscription</title>
  <style>
    @font-face { 
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Buy Cable TV</span>
    <?php include "includes/user.php"; ?>
  </div>
  
  <form class="serviceBox" id="data-form">
    <div class="selectBtns">
     <span class="span">Select Cable Type</span>
      <!------------------------------------
      <!-- Services provider images 
      ------------------------------------->
      <div class="selectBtns-body">
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'cable-type', '2', 0, 'DSTV')">
          <img src="images/dstv.png" alt="service providers images">
          <span>DSTV</span>
        </div>
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'cable-type', '1', 1, 'GOTV')">
          <img src="images/gotv.png" alt="service providers images">
          <span>GOTV</span>
        </div>
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'cable-type', '3', 2, 'STARTIME')">
          <img src="images/images.jpg" alt="service providers images">
          <span>STARTIME</span>
        </div>
      </div>
    </div>
    
    <select name="cable-type" id="cable-type" hidden="">
      <option value="">-- Select Cable Type --</option>
      <option value="2">DSTV</option>
      <option value="1">GOTV</option>
      <option value="3">STARTIME</option>
    </select>
    
    <div class="inputs" hidden>
      <span>Select Cable Plan</span>
      <select type="tel" name="cable-plan" id="cable-plan" onchange="checkValue('cable-plan', 'cable-plan-err', '', 'empty', 'select a cable plan', '')">
        <option value="">-- Select Cable Plan --</option>
      </select>
    </div>
    
    
    <div class="inputs" id="cable-plan:inputs">
      <span>Select Cable Plan</span>
      <div class="drop-btn" id="cable-plan:1" onclick="addActive(this, 'plan-detail')">
        <span>-- Select Cable Plan --</span>
        <i class="fas fa-chevron-down"></i>
      </div>
      
      <div class="drop-detail" id="plan-detail">
         <div class="no"><i class="fas fa-times-circle"></i><span>No plan found or not available</span></div>
      </div>
      
      <b id="cable-plan-err"></b>
    </div>
    
    
    <div class="inputs" id="iuc-number:inputs">
      <span>IUC Number</span>
      <input type="tel" name="iuc-number" id="iuc-number" placeholder="1234567890000" oninput="checkValue('iuc-number', 'iuc-number-err', 5, 'length', 'Enter a valid IUC number (5 digits)', '')" maxlength="15">
      <b id="iuc-number-err"></b>
    </div>
    
    <input type="tel" name="amount" id="amount" hidden>
    
    <input type="text" name="cable-type-name" id="cable-type-name" hidden>
    
    <input type="text" name="cable-plan-name" id="cable-plan-name" hidden>
    
    <input type="text" name="iuc-name" id="iuc-name" hidden>
    
    <div class="inputs">
      <span>Amount To Pay</span>
      <input type="tel" class="disabled" name="discount" id="discount" placeholder="0" disabled>
      <b id="discount-err"></b>
    </div>
    
    <?php include "includes/select-method.php"; ?>
    
    <?php include "includes/cable.php"; ?>
     <div class="link">
    <span style="text-align: right;"><a href="https://buypoint.com.ng/app/dashboard.php">Dashboard</a></span>
    </div>
    <button class="showPin" type="button" onclick="showPin()">PROCEED <i class="fas fa-arrow-right"></i></button>
     <div class="link">
    
    </div>
  </form>
  
  
  <script>
   <?php include "js/msg.js"; ?>
   
    const cable_form = document.getElementById("data-form");
    
    const cable_type = document.getElementById("cable-type");
    const cable_plan = document.getElementById("cable-plan");
    const iuc_number = document.getElementById("iuc-number");
    const no_err = document.getElementById("iuc-number-err");
    const iuc_name = document.getElementById("iuc-name");
    const amount = document.getElementById("amount");
    const discount = document.getElementById("discount");
    const cable_plan_btn = document.getElementById("cable-plan:1");
    const plan_detail = document.getElementById("plan-detail");
    
    iuc_number.addEventListener("input", ()=> {
      if(iuc_number.value.length > 4){
        if(cable_type.value == ""){
          showMessage("bi bi-exclamation-circle", "Please select cable type", "err")
        }else{
         const no_err = document.getElementById("iuc-number-err")
         showChecking(no_err, "Verifying meter name");
         fetch("server/auto.php?i=VerifyCable", {
           method: "POST",
           body: new FormData(cable_form),
         })
         .then(response => response.json())
         .then(data => {
           //alert(data);
          if(data.status == true){
            iuc_name.value = data.name;
            showSuccess(no_err, data.name);
          }else{
            iuc_name.value = "";
            showError(no_err, data.msg);
          } 
         })
         .catch(err => {
           showMessage("bi bi-exclamation-circle", "something went wrong", "err");
         });
        }
      }
    })
    
   <?php
     function getIt($pname) {
       global $conn;
       $sts = "On";
       $outputs = "";
       $sql2 = "SELECT * FROM service_details WHERE service = ? AND status = ?";
       $stmt2 = $conn->prepare($sql2);
       $stmt2->bind_param("ss", $pname, $sts);
       $stmt2->execute();
       $res2 = $stmt2->get_result();
       if($res2->num_rows > 0){
         while($row2 = $res2->fetch_assoc()){
           $outputs .= "'".$row2["service_id"]."': '".$row2["service"]." ".$row2["name"]." = (".number_format($row2["amount"]).") (".$row2["validity"].")',\n";
         }
       }
       return $outputs;
     }
   ?>
    
    const dstv = {
      <?php echo getIt("DStv"); ?>
    };
    
    const gotv = {
      <?php echo getIt("GOtv"); ?>
    };
    
    const startime = {
      <?php echo getIt("Startime"); ?>
    };
    
    cable_type.addEventListener("change", updateThird);
    function updateThird(){
      plan_detail.innerHTML = "";
      if(cable_type.value == 2){
        
        cable_plan.innerHTML = "";
        const emptyOption = document.createElement("option");
        emptyOption.value = "";
        emptyOption.textContent = "-- Select Cable Plan --";
        cable_plan.appendChild(emptyOption);
        for(const key in dstv){
          const newOption = document.createElement("option");
          newOption.value = key;
          newOption.textContent = dstv[key];
          const newOptionDiv = document.createElement("div");
          newOptionDiv.innerHTML = `
           <div class="drop-detail-divs" onclick="removeDrop('cable-plan', '${key}', this, 'drop-detail-divs', 'cable-plan:1')">
             <img src="images/dstv.png">
             <span>${dstv[key]}</span>
           </div>
          `;
          plan_detail.appendChild(newOptionDiv);
          cable_plan.appendChild(newOption);
        }
        
      }else if(cable_type.value == 1){
        
        cable_plan.innerHTML = "";
        const emptyOption = document.createElement("option");
        emptyOption.value = "";
        emptyOption.textContent = "-- Select Cable Plan --";
        cable_plan.appendChild(emptyOption);
        for(const key in gotv){
          const newOption = document.createElement("option");
          newOption.value = key;
          newOption.textContent = gotv[key];
          const newOptionDiv = document.createElement("div");
          newOptionDiv.innerHTML = `
           <div class="drop-detail-divs" onclick="removeDrop('cable-plan', '${key}', this, 'drop-detail-divs', 'cable-plan:1')">
             <img src="images/gotv.png">
             <span>${gotv[key]}</span>
           </div>
          `;
          plan_detail.appendChild(newOptionDiv);
          cable_plan.appendChild(newOption);
        }
        
      }else if(cable_type.value == 3){
        
        cable_plan.innerHTML = "";
        const emptyOption = document.createElement("option");
        emptyOption.value = "";
        emptyOption.textContent = "-- Select Cable Plan --";
        cable_plan.appendChild(emptyOption);
        for(const key in startime){
          const newOption = document.createElement("option");
          newOption.value = key;
          newOption.textContent = startime[key];
          const newOptionDiv = document.createElement("div");
          newOptionDiv.innerHTML = `
           <div class="drop-detail-divs" onclick="removeDrop('cable-plan', '${key}', this, 'drop-detail-divs', 'cable-plan:1')">
             <img src="images/images.jpg">
             <span>${startime[key]}</span>
           </div>
          `;
          plan_detail.appendChild(newOptionDiv);
          cable_plan.appendChild(newOption);
        }
        
      }else{
        cable_plan.innerHTML = "<option value=''>-- Select Cable Plan --</option>";
        cable_plan_btn.querySelector("span").innerHTML = "-- Select Plan --";
        plan_detail.innerHTML = `
          <div class="no"><i class="fas fa-times-circle"></i><span>No plan found or not available</span></div>
        `;
      }
        cable_type.dispatchEvent(new Event("change"));
        cable_plan.dispatchEvent(new Event("change"));
        iuc_number.dispatchEvent(new Event("input"));
    }
    
    cable_plan.addEventListener("change", ()=> {
      const selectOption = cable_plan.options[cable_plan.selectedIndex];
      const regex = /\(([\d,]+)\)/;
      const matches = regex.exec(selectOption.text);
      if(matches){
        const extractedNumber = matches[1].replace(',', '');
        amount.value = extractedNumber;
        discount.value = extractedNumber;
        document.getElementById("cable-plan-name").value = selectOption.text;
      }
    })
    function showPin(){
      if(cable_type.value == ""){
        showMessage("bi bi-exclamation-circle", "Please select cable type", "err");
      }else if(cable_plan.value == ""){
        showMessage("bi bi-exclamation-circle", "Please select cable plan", "err");
      }else if(iuc_number.value == ""){
        showMessage("bi bi-exclamation-circle", "Please enter iuc number", "err");
      }else if(iuc_number.value.length < 5){
        showMessage("bi bi-exclamation-circle", "Please enter a valid iuc number (15 digits)", "err");
      }else if(amount.value == ""){
        showMessage("bi bi-exclamation-circle", "Please enter amount", "err");
      }else if(iuc_name.value == ""){
        showMessage("bi bi-exclamation-circle", "Please Verify cable name before proceeding", "err");
      }else{
        document.getElementById("input-t").innerHTML = cable_type.options[cable_type.selectedIndex].text;
        document.getElementById("cable-type-name").value = cable_type.options[cable_type.selectedIndex].text;
        document.getElementById("cable-plan-name").value = cable_plan.options[cable_plan.selectedIndex].text;
        document.getElementById("input-p").innerHTML = (((cable_plan.options[cable_plan.selectedIndex].text.replace('=', '')).replace("(", "")).replace(")", "")).replace(amount.value, "");
        document.getElementById("input-h").innerHTML = iuc_name.value;
        document.getElementById("input-a").innerHTML = "NGN " + parseFloat(discount.value).toLocaleString();
        document.querySelector(".pin-body").style.display = "flex";
      }
    }
    
    function payCable(thisBtn){
      let formerTxt = thisBtn.innerText;
      showP(thisBtn);
      fetch("server/auto.php?i=BuyCable", {
        method: "POST",
        body: new FormData(cable_form),
      })
      .then(response => response.text())
      .then(data => {
        if(data.includes("<table>")){
          const newD = document.createElement("div");
          newD.innerHTML = data;
          closePin("pin-body");
          document.body.appendChild(newD);
        }else{
          showMessage("bi bi-x-circle", data, "err");
        }
        removeP(payB, formerTxt);
      })
    }
  </script>
  
  </body>
</html>