<?php
session_start();
require_once 'server/controller.php';
require_once 'server/conn.php';

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['save-beneficiary'])) {
        $name = trim($_POST['name']);
        $phone = trim($_POST['phone']);
        
        if (!empty($name) && !empty($phone)) {
            $checkSql = $conn->prepare("SELECT * FROM contacts WHERE phone = ?");
            $checkSql->bind_param("s", $phone);
            $checkSql->execute();
            $result = $checkSql->get_result();
            
            if ($result->num_rows == 0) {
                $sql = $conn->prepare("INSERT INTO contacts (phone, name, unique_id) VALUES (?,?, ?)");
                $sql->bind_param("sss", $phone, $name, $user_id);
                $_SESSION['message'] = $sql->execute() ? 'Beneficiary added successfully.' : 'Error adding beneficiary.';
            } else {
                $_SESSION['message'] = 'Beneficiary already exists.';
            }
        } else {
            $_SESSION['message'] = 'Please fill in all fields.';
        }
    } elseif (isset($_POST['delete-beneficiary'])) {
        $id = trim($_POST['id']);
        if (!empty($id)) {
            $sql = $conn->prepare("DELETE FROM contacts WHERE id = ?");
            $sql->bind_param("i", $id);
            $_SESSION['message'] = $sql->execute() ? 'Contact deleted successfully.' : 'Error deleting contact.';
        }
    }
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/style.css">
    <title>Add Beneficiary</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #ffffff;
            margin: 0;
            padding: 20px;
        }
        font-family: Arial, sans-serif;
    background-color: #ffffff; /* Change this line to #ffffff */
    margin: 0;
    padding: 20px;
}
        .card {
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            padding: 20px;
            max-width: 500px;
            margin: auto;
        }
        .input-style {
            margin-bottom: 15px;
        }
        .input-style input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .form-button button {
            background: #3333ff;
            color: white;
            padding: 10px;
            border: none;
            border-radius: 5px;
            width: 100%;
            cursor: pointer;
            transition: background 0.3s ease;
        }
        .form-button button:hover {
            background: #3333ff;
        }
        .table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
        }
        .table td {
            padding: 10px;
            border-bottom: 1px solid #ddd;
        }
        .text-danger {
            color: red;
            cursor: pointer;
        }
        .delete-button {
    background-color: #3333ff; /* Red background color */
    color: white; /* White text */
    padding: 8px 16px; /* Padding for better spacing */
    border: none; /* Remove default border */
    border-radius: 5px; /* Rounded corners */
    cursor: pointer; /* Show a pointer cursor on hover */
    font-weight: bold; /* Make text bold */
    transition: background-color 0.3s, transform 0.2s; /* Smooth hover transition */
}

.delete-button:hover {
    background-color: #3333ff; /* Darker red on hover */
    transform: scale(1.05); /* Slightly increase size on hover */
}

.delete-button:focus {
    outline: none; /* Remove focus outline */
}

    </style>
</head>
<body>
    <div class="page-content header-clear-medium">
        <div class="card card-style">
            <div class="content">
                <h1 class="card-title">Add Beneficiary</h1>
                <?php if (isset($_SESSION['message'])): ?>
                    <div class="alert"> <?php echo $_SESSION['message']; unset($_SESSION['message']); ?> </div>
                <?php endif; ?>
                <form method="post" enctype="multipart/form-data">
                    <div class="input-style input-style-always-active has-borders validate-field mb-4">
                        <label for="name" class="color-theme opacity-80 font-700 font-12">Name:</label>
                        <input type="text" name="name" id="name" required>
                    </div>
                    <div class="input-style input-style-always-active has-borders validate-field mb-4">
                        <label for="phone" class="color-theme opacity-80 font-700 font-12">Phone Number:</label>
                        <input type="text" name="phone" required>
                    </div>
                    <div class="form-button">
                        <button type="submit" name="save-beneficiary">Add Beneficiary</button>
                    </div>
                </form>
                <table class="table">
                    <h1 class="text-primary mt-5"> Beneficiary </h1>
                    <?php $sql = "SELECT * FROM contacts WHERE unique_id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("s", $user_id);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    while ($row = $result->fetch_assoc()) { ?>
                        <tr>
                            <td><b><i class="fa fa-address-book"></i> <?php echo $row['name']; ?></b></td>
                            <td><b><?php echo $row['phone']; ?></b></td>
                            <td>
                                <form method="POST">
    <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
    <button type="submit" name="delete-beneficiary" class="delete-button"><b>Delete</b></button>
</form>
                            </td>
                        </tr>
                    <?php } ?>
                </table>
            </div>
        </div>
    </div>
</body>
</html>
