<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Airtime");

$sql = "SELECT acc_name, bank, name FROM contacts WHERE unique_id = '$user_id' AND acc_name IS NOT NULL AND acc_name <> '' AND bank IS NOT NULL AND bank <> '' AND name IS NOT NULL AND name <> ''";
$result = $conn->query($sql);

// Display saved numbers
$saved_numbers = array();
if ($result->num_rows > 0) {
  while($row = $result->fetch_assoc()) {
    $saved_numbers[] = array(
      'acc_name' => $row['acc_name'],
      'bank' => $row['bank'],
      'name' => $row['name']
    );
  }
} else {
  $saved_numbers = array(); // return empty array if no records found
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/service.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Bank Transfer</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    body{
      font-family: "Teko", sans-Serif;
    }
    <?php include "css/animation.css"; ?>
  select{
        width:100%;
        height:50px;
        border-radius:8px;
        border:none;
    }
  </style>
   <script>
    function updateInput(value) {
      document.getElementById("phone").value = value;
    }
  </script>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Bank Transfer</span>
    <?php include "includes/user.php"; ?>
  </div>
  
  <?php
  $resp = array();
  if(!isset($_SESSION["banks"])){
    $url = 'https://strowallet.com/api/banks/lists/?public_key=7XBBHDSE5XUNK2XH4A4F64Q2D6QEWX';
    
    $ch = curl_init($url);
    
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: application/json',
    ]);
    
    $response = curl_exec($ch);
    $resp_decode = json_decode($response, true);
    
    if(curl_errno($ch)){
      echo '
      <script>
        showMessage(`bi bi-exclamation-circle`, `Unable to get bank list`, `err`);
      </script>
      ';
    }else{
      $resp = $resp_decode["data"]["bank_list"];
      $_SESSION["banks"] = $resp_decode["data"]["bank_list"];
      usort($resp, function($a, $bk) {
         return strcasecmp($a["bankName"][0], $bk["bankName"][0]);
      });
    }
  }else{
      $resp = $_SESSION["banks"];
      usort($resp, function($a, $bk) {
         return strcasecmp($a["bankName"][0], $bk["bankName"][0]);
      });
  }
  
  ?>
  <br><br><br>
  <pr>
      
  </pr>
  <form class="serviceBox" id="transfer-form">
      
   
    
    <select name="bank" id="bank" onchange="checkValue('bank', 'bank-err', '', 'empty', 'Select Bank', '')" hidden>
      <option value="">-- Select Bank --</option>
      <?php
       foreach($resp as $b){
         echo '<option value="'.strval($b["bankCode"]).'">'.$b["bankName"].'</option>';
       }
      ?>
    </select>
    <div class="inputs" id="bank:inputs">
       <span>Select Bank</span>
       
      <div class="drop-btn" id="bank:1" onclick="addActive(this, 'bank-detail')"> 
      <span id="show-banks" contenteditable="true"
      style="height: 40px;outline:none;padding-top:20px;"></span>
       <i class="fas fa-chevron-down" id="i"></i>
      </div>
      
      <div class="drop-detail active" id="bank-detail">
      
   <?php
       foreach($resp as $b){
         echo '
         <div class="drop-detail-divs bank" onclick="removeDrop(`bank`, `'.strval($b["bankCode"]).'`, this, `drop-detail-divs.bank`, `bank:1`)" onmousemove="createRipple(event, true, `black`)">
           <i class="fas fa-check"></i>
           <span>'.$b["bankName"].'</span>
         </div>';
       }
    ?>
      </div>
      
      <b id="bank-err"></b>
    </div>
    
    
    
    <div class="inputs" id="phone:inputs">
      <span>Account Number</span>
      <input type="number" name="account-no" id="account-no" placeholder="1234567890" oninput="checkValue('account-no', 'account-no-err', 10, 'length', 'Invalid account number', '')" pattern="[0-9]{11}" maxlength="10">
      <b id="account-no-err"></b>
    </div>
     <select onchange="updateInput(this.value)">
  <option value>Find Beneficiary</option>
  <?php foreach ($saved_numbers as $number) : ?>
    <option value="<?php echo $number['bank']; ?>">
       (<?php echo $number['name']; ?>) - <?php echo $number['acc_name']; ?>
    </option>
  <?php endforeach; ?>
</select>

<script>
  function updateInput(value) {
    document.getElementById("account-no").value = value;
  }
</script>
    <div class="inputs" id="amount:inputs">
      <span>Amount</span>
      <input type="tel" name="amount" id="amount" placeholder="1000" oninput="checkValue('amount', 'amount-err', 100, 'value', 'Enter a valid amount minimum(&#x20a6;50)', '')">
      <b id="amount-err"></b>
    </div>
    


    <div class="inputs" id="narration:inputs">
      <span>Narration</span>
      <input type="text" name="narration" id="narration" placeholder="Sent from <?php echo $site["site_name"]; ?>">
    </div>
    
    
    <input type="text" name="bank-name" id="bank-name" hidden>
    <input type="text" name="account-name" id="account-name" hidden>
    <input type="text" name="session-id" id="session-id" hidden>
    
    
    <div class="inputs">
      <span>Amount To Pay</span>
      <input type="tel" class="disabled" name="discount" id="discount" placeholder="0.00" disabled>
   
      <b id="discount-err"></b>
    </div>
    
  
  
    
    
    <?php include "includes/bank-transfer.php"; ?>
    <a href="dashboard.php" style="text-decoration: none; color: #3333ff"><i class="ri-home-smile-2-line">Dashboard</i></a>
    <button class="showPin" type="button" onclick="showPin()">PROCEED <i class="fas fa-arrow-right"></i></button>
 
  </form>
  
  <?php include "includes/reset-pin.php"; ?>
  
  <script>
   <?php include "js/msg.js"; ?>
   <?php include "js/other.js"; ?>
   
   const transfer_form = document.getElementById("transfer-form");
   const bank = document.getElementById("bank");
   const account_no = document.getElementById("account-no");
   const account_name = document.getElementById("account-name");
   const bank_name = document.getElementById("bank-name");
   const account_no_err = document.getElementById("account-no-err");
   const amount = document.getElementById("amount");
   const narration = document.getElementById("narration");
   const discount = document.getElementById("discount");
   const ssId = document.getElementById("session-id");
   
   
   const showBaks = document.getElementById("show-banks");
   const bankDetail = document.getElementById("bank-detail");
   showBaks.addEventListener("input", ()=> {
     if(!bankDetail.classList.contains("active")){
       document.getElementById("bank:inputs").click();
     }
     
     const searchValue = showBaks.innerText.toLowerCase();
     if(searchValue !== ""){
       const allBanks = document.querySelectorAll(".drop-detail-divs.bank");
       allBanks.forEach(b => {
         const bVal = b.innerText.toLowerCase();
         if(!bVal.includes(searchValue)){
           b.style.display = "none";
         }else{
           b.style.display = "";
         }
       });
     }
   });
   
   bank.addEventListener("change", ()=> {
     bank_name.value = bank.options[bank.selectedIndex].text;
   });
   
   
   account_no.addEventListener("input", ()=> {
     
     if(account_no.value.length > 9){
       if(bank.value === ""){
         alert(bank.value);
         bank.dispatchEvent(new Event("change"));
       }else{
         showChecking(account_no_err, "Verifying account name");
         fetch("server/verify-bank-name.php", {
           method: "POST",
           body: new FormData(transfer_form),
         })
         .then(response => response.json())
         .then(data => {
           if(data.status == true){
             account_name.value = data.account_name;
             ssId.value = data.session_id;
             showSuccess(account_no_err, data.account_name);
           }else{
             ssId.value = "";
             account_name.value = "";
             showError(account_no_err, data.msg);
           }
         })
         .catch(err => {
           alert("Server/Network error");
         });
       }
     }
     
   });
   
   
   amount.addEventListener("input", (e)=> {
     discount.value = parseInt(e.target.value) + 20;
   });
   
   function showPin(){
     if(bank.value === "" || account_no.value.length < 10 || amount.value < 100){
       bank.dispatchEvent(new Event("change"));
       account_no.dispatchEvent(new Event("input"));
       amount.dispatchEvent(new Event("input"));
     }else if(account_name.value === ""){
       showMessage("bi bi-exclamation-circle", "Please verify bank name", "err");
     }else{
       document.getElementById("input-b").innerText = bank_name.value;
       document.getElementById("input-nm").innerText = account_name.value;
       document.getElementById("input-a").innerText = "NGN " + (discount.value).toLocaleString();
       document.getElementById("input-n").innerText = narration.value;
       document.querySelector(".pin-body").style.display = "flex";
     }
   }
   
   function sendMoney(thisBtn){
     let formerTxt = thisBtn.innerText;
     showP(thisBtn);
     
     fetch("server/send-money.php", {
       method: "POST",
        body: new FormData(transfer_form),
     })
     .then(response => response.text())
     .then(data => {
       removeP(thisBtn, formerTxt);
       if(data.includes("<table>")){
          const newD = document.createElement("div");
          newD.innerHTML = data;
          closePin("pin-body");
          document.body.appendChild(newD);
       }else{
         showMessage("bi bi-exclamation-circle", data, "err");
       }
     })
     .catch(err => {
       alert("Server/Network error");
     });
   }
  </script>

  <?php
      $int = (INT)$user["bal"];
      $low = 100;
      if($int < $low){
          echo '
          <script>
             function redir(){
                 window.location.href = "dashboard.php";
             }
            showMessage("bi bi-info-circle", "Wallet below minimum vending amount NGN '.number_format($int).'", "ver", redir, redir);
          </script>
          ';
      }
    ?>
  </body>
</html>