<?php
 header("Access-Control-Allow-Origin: *");
 header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
 header("Access-Control-Allow-Headers: Content-Type");

 include_once "../server/conn.php";
 require "../server/controller.php";
 
 date_default_timezone_set("Africa/Lagos");
 
 $response = array();
 if($_SERVER["REQUEST_METHOD"] !== "POST"){
   $response["status"] = "fail";
   $response["msg"] = "invalid server request method";
   return $response;
   exit();
 }
 
 $data = json_decode(file_get_contents("php://input"), true);
 
 $domain = validate::validateUrl($conn, $data["domain"]);
 
 $query = $conn->prepare("SELECT * FROM lisense WHERE domain = ?");
 $query->bind_param("s", $domain);
 $query->execute();
 $res = $query->get_result();
 if($res->num_rows > 0){
   $response["status"] = "success";
   $response["msg"] = "Site verification successful site has lisense to use script";
   echo json_encode($response);
   exit();
 }else{
   $response["status"] = "fail";
   $response["msg"] = "invalid site has no lisense to use script";
   echo json_encode($response);
   exit();
 }
?>