<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Airtime");

function getId($name){
  global $conn;
   $stats = "On";
   $ser = "Airtime";
   $sql = "SELECT * FROM service_id WHERE service = ? AND status = ? AND provider = ? ORDER BY provider_id ASC";
   $stmt = $conn->prepare($sql);
   $stmt->bind_param("sss", $ser, $stats, $name);
   $stmt->execute();
   $query = $stmt->get_result();
   
   if($query->num_rows > 0){
     $row = $query->fetch_assoc();
     
     return $row["provider_id"];
   }
 }
 // Retrieve saved contacts
$sql = "SELECT * FROM contacts WHERE unique_id = '$user_id'";
$result = $conn->query($sql);

// Display saved contacts
$saved_contacts = array();
if ($result->num_rows > 0) {
  while($row = $result->fetch_assoc()) {
    $saved_contacts[] = array(
      'name' => $row["name"],
      'phone' => $row["phone"]
    );
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/service.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Login || buypoint</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    body{
      font-family: "Teko", sans-Serif;
    }
    select{
        width:100%;
        height:50px;
        border-radius:8px;
        border:none;
    }
    
    <?php include "css/animation.css"; ?>
  </style>
  <script>
    function updateInput(value) {
      document.getElementById("phone").value = value;
    }
  </script>

</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Buy Airtime</span>
     
      <a href="airtime-trx.php" style="text-decoration: none; color: #3333ff"><i class="fas fa-history"></i></a>
    <?php include "includes/user.php"; ?>
    
  </div>
  
  <form class="serviceBox" id="airtime-form">
    <div class="selectBtns">
    <img src="logos/121.jpg" alt="Header Image" style="border-radius: 10px; max-width: 100%; height: auto;">
     <span class="span">Select Network Provider</span>
      <!------------------------------------
      <!-- Services provider images 
      ------------------------------------->
      <!-- Add Image at the top of the page -->
  <div class="image-container" style="text-align: center; margin-bottom: 20px;">
    
  </div>
      <div class="selectBtns-body">
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("MTN"); ?>', 0, 'MTN')">
          <img src="images/mtn.png" alt="service providers images">
          <span>MTN</span>
        </div>
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("GLO"); ?>', 1, 'GLO')">
          <img src="images/glo.png" alt="service providers images">
          <span>GLO</span>
        </div>
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("9MOBILE"); ?>', 2, '9MOBILE')">
          <img src="images/9mobile.png" alt="service providers images">
          <span>9MOBILE</span>
        </div>
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("AIRTEL"); ?>', 3, 'AIRTEL')">
          <img src="images/airtel.png" alt="service providers images">
          <span>AIRTEL</span>
        </div>
      </div>
    </div>
    
      <select name="network" id="network" hidden>
        <option value="">Select Network</option>
        <option value="<?php  echo getId("MTN"); ?>">MTN</option>
        <option value="<?php  echo getId("GLO"); ?>">GLO</option>
        <option value="<?php  echo getId("9MOBILE"); ?>">9MOBILE</option>
        <option value="<?php  echo getId("AIRTEL"); ?>">AIRTEL</option>
      </select>
    <div class="inputs" id="phone:inputs">
      <span>Phone Number</span>
      <input type="tel" name="phone" id="phone" placeholder="08012345678" oninput="checkValue('phone', 'phone-err', 11, 'length', 'Invalid phone number', '')" pattern="[0-9]{11}" maxlength="11">
      <b id="phone-err"></b>
    </div>
    <select onchange="updateInput(this.value)">
      <option>Select a saved number</option>
  <?php foreach ($saved_contacts as $contact) : ?>
    <option value="<?php echo $contact['phone']; ?>">
      <?php echo $contact['name']; ?> (<?php echo $contact['phone']; ?>)
    </option>
  <?php endforeach; ?>
</select>
    </a>
    <a href="ben.php" style="text-decoration: none; color: #000"><i class="ri-smile-5-line">Add Beneficiary</i></a>
  
   </body>
   
<div class="inputs" id="amount:inputs">
      <span>Amount</span>
      <input type="tel" name="amount" id="amount" placeholder="1000" oninput="checkValue('amount', 'amount-err', 50, 'value', 'Enter a valid amount minimum(&#x20a6;50)', '')">
      <b id="amount-err"></b>
    </div>
    
    <input type="text" id="network-name" name="network-name" hidden>
    
    <div class="inputs">
      <span>Amount To Pay</span>
      <input type="tel" class="disabled" name="discount" id="discount" placeholder="0.00" disabled>
    </div>
    
    <?php include "includes/select-method.php"; ?>
    
    <?php include "includes/airtime.php"; ?>
    <a href="dashboard.php" style="text-decoration: none; color: #5e1d3d"><i class="ri-home-smile-2-line">Dashboard</i></a>
   
    <button class="showPin" type="button" onclick="showPin()">PROCEED <i class="fas fa-arrow-right"></i></button>
 
  </form>
  
  <?php include "includes/reset-pin.php"; ?>
  
  <script>
   <?php include "js/msg.js"; ?>
   <?php include "js/other.js"; ?>

    const network = document.getElementById("network");
    const phone = document.getElementById("phone");
    const amount = document.getElementById("amount");
    network.onchange = function(){
      phone.dispatchEvent(new Event("input"));
      amount.dispatchEvent(new Event("input"));
    }
    function showPin(){
      if(network.value == ""){
        showMessage("bi bi-exclamation-circle", "Please Select network", "err");
      }else if(phone.value.length < 11){
        showMessage("bi bi-exclamation-circle", "Please enter a valid phone number", "err");
      }else if(amount.value < 50){
        showMessage("bi bi-exclamation-circle", "Please enter a valid amount minimum(NGN 50)", "err");
      }else{
        if(!isNaN(amount.value)){
            document.getElementById("input-p").innerText = phone.value;
            document.getElementById("input-n").innerText = network.options[network.selectedIndex].text;
            document.getElementById("input-a").innerHTML = "NGN " + parseFloat(document.getElementById("discount").value).toLocaleString();
            document.querySelector(".pin-body").style.display = "flex";
        }else{
            showMessage("bi bi-exclamation-circle", "Please enter a valid amount must be in number minimum(NGN 50)", "err");
        }
      }
    }
    let discount = parseInt("<?php echo $fetchDiscount["discount"]; ?>") / 100;
    amount.addEventListener("input", ()=> {
      if(amount.value !== ""){
        document.getElementById("discount").value = (parseInt(amount.value) * (1 - discount)).toFixed(2);
      }else{
        document.getElementById("discount").value = 0.00;
      }
    })
  const airtime_form = document.getElementById("airtime-form");

  network.addEventListener("change", ()=> {
   if(network.value !== ""){
    document.getElementById("network-name").value = network.options[network.selectedIndex].text;
   }
  });

  function payAirtime(payB){
   
    let formerTxt = payB.innerText;
    showP(payB);
    fetch("server/auto.php?i=BuyAirtime", {
      method: "POST",
      body: new FormData(airtime_form),
    })
    .then(response => response.text())
    .then(data => {
      if(data.includes("<table>")){
        const newD = document.createElement("div");
        newD.innerHTML = data;
        closePin("pin-body");
        document.body.appendChild(newD);
      }else{
        showMessage("bi bi-x-circle", data, "err");
      }
      removeP(payB, formerTxt);
    })
    .catch(error => {
      alert(error);
    });
  }
  </script>
 
  </body>
</html>