<?php
session_start();
 include "server/conn.php";
 include "server/controller.php";
 $limit = "";
 $user_id = $_SESSION["user_id"];
 $user = Control::fetchDetail($conn, $user_id);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Airtime History || Cidapay #easylifeishere</title>
  <style>
    <?php  
      $site = Control::site($conn);
    ?>
:root{
  --site-clr: <?php echo $site["site_color"] ?>;
  --bg: <?php echo $site["site_background"]; ?>;
  --box-shadow: 0.5px 3px 5px 2px hsl(0, 0%, 85%);
  --box-shadow-two: 0.5px 3px 5px 2px hsl(0, 0%, 83%);
  --box-shadow-three: 0 0 3px 1.1px #fff,
                      1px 1px 3px 0 hsl(0, 0%, 80%);
  --box-shadow-four: 0 0 3px 2px #fff,
                      2px 3px 3px 0 hsl(0, 0%, 80%);
  --poppins: "Poppins", Sans-Serif;
  --mitr: "Mitr", Sans-Serif;
}
body{
  font-family: var(--poppins);
  background: var(--bg);
  padding: 4px;
  letter-spacing: 1px;
}
body.active{
  background: hsl(0, 0%, 10%);
}
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    a{
      text-decoration: none;
    }
    a:link{
      cursor: none;
    }
    div, session, input, textarea, span, b, h1, h2, h3, h4, h5, h6, i, table, tr{
      box-sizing: border-box;
      font-family: var(--mitr);
    }
    .head{
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      height: 40px;
      background: #fff;
      display: flex;
      align-items: center;
      padding: 20px;
      height: 55px;
      z-index: 12;
    }
    body.active .head{
      background: hsl(0, 0%, 23%);
      color: hsl(0, 0%, 95%);
    }
    .head i{
      font-size: 15px;
      margin-left: 5px;
      margin-right: 27px;
    }
    .head span{
      font-size: 11px;
      color: #222;
    }
    body.active .head span{
      color: hsl(0, 0%, 95%);
    }
    .all-t{
      margin-top: 125px;
    }
    .search-top{
      position: fixed;
      top: 55px;
      left: 0;
      right: 0;
      height: 65px;
      padding: 12px;
      background: #fff;
      box-shadow: none;
      display: flex;
      align-items: center;
      z-index: 10;
      border-top: 1px solid hsl(0, 0%, 100%);
    }
    body.active .search-top{
      background: hsl(0, 0%, 23%);
      box-shadow: none;
      border-top: 1px solid hsl(0, 0%, 23%);
    }
    .search-top .inputs{
      display: flex;
      align-items: center;
      width: 100%;
      padding: 10px;
      border-radius: 3px;
      background: hsl(0, 0%, 93%);
      height: 45px;
    }
    body.active .search-top .inputs{
      background: hsl(0, 0%, 40%);
    }
    .search-top .inputs i{
      padding: 10px;
      background: transparent;
      color: #222;
      width: 32px;
      height: 30px;
      border-radius: 5px;
      text-align: center;
      line-height: 10.5px;
      font-size: 12px;
    }
    body.active .search-top .inputs i{
      color: hsl(0, 0%, 90%);
    }
    .search-top .inputs input{
      outline: none;
      border: none;
      background: transparent;
      height: 31px;
      padding: 10px;
      width: 100%;
      font-family: var(--poppins);
      font-size: 13px;
      margin-left: 4px;
      border-radius: 2px;
    }
    body.active .search-top .inputs input{
      background: transparent;
      color: hsl(0, 0%, 90%);
    }
    body.active .search-top .inputs input::placeholder{
      color: hsl(0, 0%, 80%);
    }
.transaction-detail{
  padding:15px; 
  background: hsl(0, 0%, 100%); 
  color: #222; border-radius: 5.7px; 
  display: flex; 
  align-items: center;
  margin-bottom: 10px;
  box-shadow: 0.6px 3px 3px 0.6px #0001; 
  word-break: break-word;
  font-family: var(--poppins);
}
body.active .transaction-detail{
  background: hsl(0, 0%, 23%);
  box-shadow: 0.5px 2px 3px 0.5px hsl(0, 0%, 0%);
}
.transaction-detail i{
  padding: 10px; 
  height: 30px;
  width: 30px;
  border-radius: 50%;
  display: flex; 
  align-items: center;
  justify-content: center; 
  font-size: 15px;
  margin-right: 10px;
  box-sizing: border-box;
}
.transaction-detail .left{
  flex:1;
  text-align:left; 
  width:60%;
}
.transaction-detail .left .span{
  font-size: 11.5px; 
  color: #444; 
  display: block;
  margin-bottom: 3px; 
  margin-top: 0; 
  font-weight: 900;
}
body.active .transaction-detail .left .span{
  color: hsl(0, 0%, 97%);
}
.transaction-detail .left .b{
  font-size: 10px; 
  display: inline-block; 
  margin-bottom: 0; 
  margin-top: 0; background: transparent; 
  color: #666;
  padding: 0px; 
  border-radius: 6px;
  height: 15px; 
  box-sizing: border-box;
  width: 100%; 
  text-align: left;
  font-size: 8px;
  font-weight: 300;
}
body.active .transaction-detail .left .b{
  color: hsl(0, 0%, 97%);
}
.transaction-detail .right{
  text-align: 
  right;width: 40%;
}
.transaction-detail .right .span{
  font-size: 10px; 
  display: block; 
  margin-bottom: 0; 
  margin-top: 5px; 
  margin-bottom: 5px;
  color: #555; 
  font-weight: 900;
}
body.active .transaction-detail .right .span{
  color: hsl(0, 0%, 97%);
}
.transaction-detail .right .span.t{
  font-size: 7px;
}
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Airtime History</span>
  </div>
  <div class="search-top">
    <div class="inputs">
      <i class="fas fa-search"></i>
      <input type="search" id="search" placeholder="Search Transaction" oninput="searchValue('search', 'all-t', '.transaction-detail', '.span')">
    </div>
  </div>
  <div class="all-t" id="all-t">
  <?php
 $user_id = $_SESSION["user_id"];
 
 $user = Control::fetchDetail($conn, $user_id);
 
 function showPop($trans_type, $trans_date, $trans_status, $trans_amount, $trans_reference, $trans_des){
   $icon = "";
  $bg_clr = "rgba(245, 130, 0, 0.1)"; // Deep Orange
$i_clr = "rgba(245, 130, 0)"; // Rich Orange

   
   if($trans_type == "Airtime"){
     $icon = "bi bi-phone";
   }else if($trans_type == "Data"){
     $icon = "bi bi-wifi";
   }else if($trans_type == "Wallet Topup"){
     $icon = "bi bi-arrow-down-circle";
   }else if($trans_type == "Transfer"){
     $icon = "bi bi-send";
   }else if($trans_type == "Exam Pin"){
     $icon = "ri-graduation-cap-line";
   }else if($trans_type == "Cable TV" || $trans_type == "Cable Tv"){
     $icon = "ri-tv-line";
   }else if($trans_type == "Electricity"){
     $icon = "ri-lightbulb-line";
   }else if($trans_type == "Betting"){
     $icon = "ri-football-line";
   }else if($trans_type == "Airtime Pin"){
     $icon = "bi bi-phone";
   }else if($trans_type == "Bulk Sms"){
     $icon = "bi bi-chat-right-text";
   }else if($trans_type == "Airt"){
     $icon = "bi bi-phone";
   }else{
     $icon = "bi bi-arrow-up-circle";
   }
   
   $stat_clr = "";
   $stat_clr_clr = "";
   if($trans_status == "success"){
     $stat_clr = "rgba(0%, 60%, 0%, 0.1)";
     $stat_clr_clr = "rgba(0%, 60%, 0%)";
   }else if($trans_status == "pending"){
     $stat_clr = "rgba(100%, 54%, 0%, 0.1)";
     $stat_clr_clr = "rgba(100%, 54%, 0%)";
   }else if($trans_status == "failed"){
     $stat_clr = "rgba(90%, 0%, 0%, 0.1)";
     $stat_clr_clr = "rgba(90%, 0%, 0%)";
   }
   
   $transaction_to_echo = '
    <a href="reciept.php?ref='.$trans_reference.'" style"text-decoration: none;"><div class="transaction-detail" onclick="window.location = `reciept.php?ref='.$trans_reference.'`;">
    
     <i class="'.$icon.'" class="t-icon" style="background: '.$bg_clr.'; color: '.$i_clr.';"></i>
     
     
      <div class="left">
        <span class="span">'.$trans_type.'</span>
        <b class="b" style="letter-spacing: 0.5px;">'.$trans_des.'</b>
      </div>
      
     
      
      <div class="right">
       <b style="font-size: 9px; display: inline-block; margin-bottom: 0; margin-top: 0; background:'.$stat_clr.'; color: '.$stat_clr_clr.'; padding: 0px; border-radius: 4px; height: 16px; box-sizing: border-box; width: 60px; text-align: center; letter-spacing: 0.3px; border: 1px solid '.$stat_clr.';">'.$trans_status.'</b>
       <span class="span" style="letter-spacing: 0.5px;">NGN '.number_format($trans_amount).'</span>
       <span class="span t" style="letter-spacing: 0.5px;">'.$trans_date.'</span>
      </div>
    </div></a>
   ';
   return $transaction_to_echo;
 }
 
$sql = "SELECT * FROM transaction WHERE unique_id = ? AND type = 'Airtime' ORDER BY id DESC ".(!isset($limit) ? "" : $limit)."";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $user["unique_id"]);
$stmt->execute();
$query = $stmt->get_result();

if($query->num_rows > 0){
    while($row = $query->fetch_assoc()){
        echo showPop($row["type"], $row["date"], $row["status"], $row["amount"], $row["reference"], $row["description"]);

   }
 }else{
   echo '
    <div style="display: flex;align-items: center; justify-content: center; flex-direction: column; padding: 30px; background: hsl(0, 0%, 86%); color: #444; margin-top: 0px; height: 130px;width: 100%; box-sizing: border-box; border-radius:9px; height: 170px;">
    
     <i class="fas fa-info-circle" style="font-size:55px; margin-bottom:15px;"></i>
     <span style="font-size:10px; text-align: center;">No Airtime Transaction Yet, Buy airtime to see transactions</span>
     
    </div>
   ';
 }
?>
  </div>
  <script>
  <?php include "js/msg.js"; ?>
    function searchValue(searchTxt, div_bx_queruy, div_query, txt_query){
      const searchGet = document.getElementById(searchTxt);
      const searchVal = searchGet.value.toLowerCase();
      
      const divsBxQ = document.getElementById(div_bx_queruy);
      divsBxQ.querySelectorAll(div_query).forEach(divsE => {
        const divETxt = divsE.querySelector(txt_query);
        const divETxtLower = divETxt.innerText.toLowerCase();
        
        divsE.style.display = "";
        if(!divETxtLower.includes(searchVal)){
          divsE.style.display = "none";
        }
      })
    }
  </script>
</body>
</html>
