<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Airtime");

function getId($name){
  global $conn;
   $stats = "On";
   $ser = "Airtime_pin";
   $sql = "SELECT * FROM service_id WHERE service = ? AND status = ? AND provider = ? ORDER BY provider_id ASC";
   $stmt = $conn->prepare($sql);
   $stmt->bind_param("sss", $ser, $stats, $name);
   $stmt->execute();
   $query = $stmt->get_result();
   
   if($query->num_rows > 0){
     $row = $query->fetch_assoc();
     
     return $row["provider_id"];
   }
 }
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/service.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Airtime PIN</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    body{
      font-family: "Teko", sans-Serif;
    }
    <?php include "css/animation.css"; ?>
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Airtime PIN</span>
    <i class="fas fa-history" onclick="window.location.href='airtime_pin-trx.php';"></i>
    <?php include "includes/user.php"; ?>
  </div>
  
  <form class="serviceBox" id="airtime-pin-form">
    <div class="selectBtns">
     <span class="span">Select Network Provider</span>
      <!------------------------------------
      <!-- Services provider images 
      ------------------------------------->
      <div class="selectBtns-body">
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("MTN"); ?>', 0, 'MTN')">
          <img src="images/mtn.png" alt="service providers images">
          <span>MTN</span>
        </div>
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("GLO"); ?>', 1, 'GLO')">
          <img src="images/glo.png" alt="service providers images">
          <span>GLO</span>
        </div>
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("9MOBILE"); ?>', 2, '9MOBILE')">
          <img src="images/9mobile.png" alt="service providers images">
          <span>9MOBILE</span>
        </div>
        <div class="selectBtns-inner" onclick="toggSelect('selectBtns-inner', 'network', '<?php  echo getId("AIRTEL"); ?>', 3, 'AIRTEL')">
          <img src="images/airtel.png" alt="service providers images">
          <span>AIRTEL</span>
        </div>
      </div>
    </div>
    
      <select name="network" id="network" hidden>
        <option value="">Select Network</option>
        <option value="<?php  echo getId("MTN"); ?>">MTN</option>
        <option value="<?php  echo getId("GLO"); ?>">GLO</option>
        <option value="<?php  echo getId("9MOBILE"); ?>">9MOBILE</option>
        <option value="<?php  echo getId("AIRTEL"); ?>">AIRTEL</option>
      </select>
      
      <select name="amount" id="amount" onchange="checkValue('amount', 'amount-err', '', 'empty', 'Please select amount', '')" hidden>
        <option value="">Select Amount</option>
        <option value="100">100</option>
        <option value="200">200</option>
        <option value="500">500</option>
        <option value="1000">1000</option>
      </select>
      
      
      
      <div class="inputs" id="amount:inputs">
      <span>Select Amount</span>
      <div class="drop-btn" id="amount:1" onclick="addActive(this, 'amount-detail')"> 
       <span>-- Select Amount --</span>
       <i class="fas fa-chevron-down" id="i"></i>
      </div>
      
      <div class="drop-detail four" id="amount-detail">
         <div class="drop-detail-divs amount" onclick="removeDrop('amount', '100', this, 'drop-detail-divs.amount', 'amount:1')" onmousemove="createRipple(event, true, 'black')">
           <i class="fas fa-check"></i>
           <span>100</span>
         </div>
         <div class="drop-detail-divs amount" onclick="removeDrop('amount', '200', this, 'drop-detail-divs.amount', 'amount:1')" onmousemove="createRipple(event, true, 'black')">
           <i class="fas fa-check"></i>
           <span>200</span>
         </div>
         <div class="drop-detail-divs amount" onclick="removeDrop('amount', '500', this, 'drop-detail-divs.amount', 'amount:1')" onmousemove="createRipple(event, true, 'black')">
           <i class="fas fa-check"></i>
           <span>500</span>
         </div>
         <div class="drop-detail-divs amount" onclick="removeDrop('amount', '1000', this, 'drop-detail-divs.amount', 'amount:1')" onmousemove="createRipple(event, true, 'black')">
           <i class="fas fa-check"></i>
           <span>1,000</span>
         </div>
      </div>
      
      <b id="amount-err"></b>
    </div>
      
    
    <div class="inputs" id="amount:inputs">
      <span>Quantity</span>
      <input type="number" name="quantity" id="quantity" placeholder="Qantity" oninput="checkValue('quantity', 'quantity-err', '1', 'length', 'Enter a valid quantity minimum(1 Qantity)', '')">
      <b id="quantity-err"></b>
    </div>
    
    <div class="inputs" id="amount:inputs">
      <span>Name On card</span>
      <input type="nameoncard" name="nameoncard" id="nameoncard" placeholder="Cidapay" oninput="checkValue('nameoncard', 'nameoncard-err', '3', 'length', 'Enter a valid card name', '')">
      <b id="nameoncard-err"></b>
    </div>
    
    <input type="text" id="network-name" name="network-name" hidden>
    
    <div class="inputs">
      <span>Amount To Pay</span>
      <input type="tel" class="disabled" name="discount" id="discount" placeholder="0.00" disabled>
    </div>
    
    <?php include "includes/select-method.php"; ?>
    
    <?php include "includes/airtime-pin.php"; ?>
    <a href="dashboard.php" style="text-decoration: none; color: #3333ff"><i class="ri-home-smile-2-line">Dashboard</i></a>
    <button class="showPin" type="button" onclick="showPin()">PROCEED <i class="fas fa-arrow-right"></i></button>
 
  </form>
  
  <?php include "includes/reset-pin.php"; ?>
  
  <script>
   <?php include "js/msg.js"; ?>
   <?php include "js/other.js"; ?>
   
   function getId(idName){
       return document.getElementById(idName);
   }
   
   const network = getId("network");
   const amount = getId("amount");
   const quantity = getId("quantity");
   const nameoncard = getId("nameoncard");
   const amountPay = getId("discount");
   
   quantity.addEventListener("input", ()=> {
      amountPay.value = amount.value * quantity.value; 
   });
   
   amount.addEventListener("change", ()=> {
      quantity.dispatchEvent(new Event("input"));
   });
   
   function showPin(){
       if(network.value === "" || amount.value === "" || quantity.value < 1 || nameoncard.value.length < 3){
           network.dispatchEvent(new Event("change"));
           amount.dispatchEvent(new Event("change"));
           quantity.dispatchEvent(new Event("input"));
           nameoncard.dispatchEvent(new Event("input"));
       }else{
           getId("network-name").value = network.options[network.selectedIndex].text;
           getId("input-n").innerHTML = network.options[network.selectedIndex].text;
           getId("input-a").innerHTML = "NGN "+ (amount.value).toLocaleString();
           getId("input-q").innerHTML = quantity.value;
           getId("input-n-c").innerHTML = nameoncard.value;
           getId("pin-airtime").style.display = "flex";
       }
   }
   
   const airtime_pin_form = getId("airtime-pin-form");
   
  function payAirtimePin(payB){
   
    let formerTxt = payB.innerText;
    showP(payB);
    fetch("server/auto.php?i=BuyAirtimePin", {
      method: "POST", 
      body: new FormData(airtime_pin_form),
    })
    .then(response => response.text())
    .then(data => {
      if(data.includes("<table>")){
        const newD = document.createElement("div");
        newD.innerHTML = data;
        closePin("pin-body");
        document.body.appendChild(newD);
      }else{
        showMessage("bi bi-x-circle", data, "err");
      }
      removeP(payB, formerTxt);
    })
    .catch(error => {
      alert(error);
    });
  }
  </script>
  
  </body>
</html>