<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$verification = Control::fetchVerification($conn, $user_id);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Account verification</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    @media screen and (max-width: 761px){
      :root{
        --width: 347px;
        --width-r: 97%;
      }
    }
    @media screen and (min-width: 762px){
      :root{
        --width: 100%;
        --width-r: 99%;
      }
    }
    .kyc-topic.none{
        display: none;
    }
    .kyc-topic{
        background: #0003;
        color: #000;
        padding: 10px;
        border-radius: 4px;
        height: 33px;
        margin-top: 15px;
        margin-bottom: 7px;
        font-size: 12px;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    .v-box-container.none{
        display: none;
    }
    .v-box-container{
        padding: 10px;
        background: #fff;
        box-shadow: 0 2px 3px 1px #0001;
        border-radius: 5px;
    }
    .v-box-container button.green{
        padding: 10px;
        color: #fff;
        background: rgba(0%, 70%, 0%);
        border: ;
    }
    .progress{
        padding: 15px;
        background: #fff;
        border-radius: 9px;
        box-shadow: 0 2px 3px  1px #0002;
        width: 100%;
    }
    .progress .p-text{
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    .progress .p-text b{
        font-size: 11px;
        color: #666;
        display: block;
        font-weight: 400;
    }
    .msg-box i{
        font-size: 12px;
        margin-right: 10px;
        color: var(--site-clr);
    }
    .msg-box{
        display: flex;
        align-items: flex-start;
        font-size: 9px;
        color: #000;
        background: #0001;
        padding: 12px;
        margin-top: 15px;
        border-radius: 9px;
    }
    .progress .p-text button{
        padding: 0;
        outline: none;
        border: none;
        color: rgba(0%, 0%, 80%);
        font-size: 12px;
        background: none;
    }
    .progress .p-check{
        display: flex;
        align-items: center;
        padding: 15px;
        margin-top: 12px;
        margin-bottom: 10px;
        width: 100%;
        position: relative;
    }
    .progress .p-check .p-c-i.active i{
        color: rgba(0%, 80%, 0%);
    }
    .progress .p-check .p-c-i.active span{
        background: rgba(0%, 80%, 0%);
    }
    .progress .p-check .p-c-i.active.icon-only span{
        background: #0002;
    }
    .progress .p-check .p-c-i{
        display: flex;
        align-items: center;
        width: 100%;
        position: relative;
    } 
    .progress .p-check .p-c-i span{
        padding: 1px;
        display: block;
        background: #0002; 
        height: 1px;
        width: 100%;
    }
    .progress .p-check .p-c-i b{
        padding: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: var(--site-clr); 
        height: 8px;
        font-size: 8px;
        position: absolute;
        bottom: -16px;
        left: -8px;
        color: #fff;
        line-height: 0;
        border-radius: 4px; 
    }
    .progress .p-check i{
        font-size: 20px;
        color: hsl(0, 0%, 80%);
    } 
    .sep-btn{
        display: flex;
        justify-content: flex-end;
        margin-top: 3px;
    }
    .sep-btn .btn.black{
        background: hsl(0, 0%, 60%);
    }
    .sep-btn .btn i{
        margin-left: 5px;
        margin-right: 5px;
    }
    .sep-btn .btn{
        padding: 10px;
        background: var(--site-clr);
        color: #fff;
        height: 40px;
        border: none;
        outline: none;
        border-radius: 5px;
        width: auto;
        min-width: 70px;
        margin-left: 5px;
        margin-right: 5px;
    }
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
       <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Account Verification</span>
  </div>
  <pre>
  </pre>
  <div class="progress">
      <div class="p-text">
          <b>Upgrade Progress</b>
          <button>View More</button>
      </div>
      
      <div class="p-check">
          <div class="p-c-i <?php echo (!empty($verification["email"]) ? "active" : ""); ?> <?php echo (empty($verification["bvn"]) ? "icon-only" : ""); ?>" id="prog-one">
              <i class="bi bi-check-circle-fill"></i>
              <span></span>
              <b>Lvl 1</b>
          </div>
           
         <div class="p-c-i <?php echo (!empty($verification["bvn"]) ? "active" : ""); ?> <?php echo (empty($verification["nin"]) ? "icon-only" : ""); ?>" id="prog-two">
              <i class="bi bi-check-circle-fill"></i>
              <span></span>
              <b>Lvl 2</b>
          </div>
          <i class="bi bi-check-circle-fill" style='color: rgba(0%, 80%, 0%);'></i>
           
      </div>
      <!--<div class="msg-box">
          <i class="bi bi-info-circle-fill"></i>
          <span>You are currently on level-3<br>Provide the requirment below to enjoy the benifits</span>
      </div>---->
  </div>


  
  <div class="verification-box">
     
     
    <!----------- for tier one kyc ------------------->
    <div class="kyc-topic" id="level-one-topic">Level 1 <i class="fas fa-chevron-down"></i></div>

    <div class="v-box-container" id="level-one-box">
        <div class="msg-box">
          <i class="bi bi-info-circle-fill"></i>
          <span>You are currently on level-1<br>Provide the requirment below to enjoy the benifits</span>
      </div>
        <div class="v-bx">
          <i class="ri-mail-line"></i>
          <div class="v-t-bx">
            <b>Email</b>
            <span>Status: <?php echo (!empty($verification["email"]) ? "<b class='green'>Verified<b>" : "<b class='red'>Unverified</b>"); ?></span>
          </div>
          <button class="<?php echo (!empty($verification["email"]) ? "disabled" : ""); ?>" onclick="redirect('email-verification.php')" <?php echo (!empty($verification["email"]) ? "disabled" : ""); ?>><?php echo (!empty($verification["email"]) ? "verified" : "verify"); ?> <i class="fas fa-chevron-right"></i></button>
        </div>
        
        <div class="v-bx" style="display: none;">
          <i class="ri-phone-line"></i>
          <div class="v-t-bx">
            <b>Phone Number</b>
            <span>Status: <?php echo (!empty($verification["phone"]) ? "<b class='green'>Verified<b>" : "<b class='red'>Unverified</b>"); ?></span>
          </div>
          <button class="<?php echo (!empty($verification["phone"]) ? "disabled" : ""); ?>" onclick="redirect('phone-verification.php')" <?php echo (!empty($verification["phone"]) ? "disabled" : ""); ?>><?php echo (!empty($verification["phone"]) ? "verified" : "verify"); ?> <i class="fas fa-chevron-right"></i></button>
        </div>
        <div class="sep-btn">
            <button class="btn black"><i class="fas fa-chevron-left"></i>Previous</button>
            <button class="btn" onclick="moveNextOne(<?php echo (!empty($verification["email"]) ? "true" : "false"); ?>, 'next')">Next<i class="fas fa-chevron-right"></i></button>
        </div>
    </div>
    
    
    <!----------- for tier two kyc ------------------->
    <?php 
     $tx = "";
     $dis = "";
     $disCl = "";
     $bclr = "";
     if(!empty($verification["bvn"]) && strstr($verification["bvn"], "_verify")){
      $tx = "Pending";
      $dis = "";
      $disCl = "pending";
      $bclr = "background: rgba(100%, 70%, 10%, 0.2);
        border: 1px solid rgba(100%, 70%, 10%, 50%);
        color: rgba(100%, 70%, 10%); 
        width: 100px;";
     }else if(!empty($verification["bvn"]) && strstr($verification["bvn"], "_rejected")){
      $tx = "rejected";
      $dis = "";
      $disCl = "";
     }else if(empty($verification["bvn"])){
      $tx = "verify";
      $dis = "";
      $disCl = "";
     }else{
       $tx = "verified";
       $dis = "disabled";
       $disCl = "disabled";
     }
    ?> 
    <div class="kyc-topic none" id="level-two-topic">Level 2 <i class="fas fa-chevron-down"></i></div>
   
    <div class="v-box-container none" id="level-two-box">
        <div class="msg-box">
          <i class="bi bi-info-circle-fill"></i>
          <span>You are currently on level-2<br>Provide the requirment below to enjoy the benifits</span>
      </div>
        <div class="v-bx">
          <i class="ri-file-line"></i>
          <div class="v-t-bx">
            <b>BVN</b>
           <span>Status: <?php echo (!empty($verification["bvn"]) ? "<b class='green'>Verified<b>" : "<b class='red'>Unverified</b>"); ?></span>
          </div>
          <button style="<?php echo $bclr; ?>" class="<?php echo $disCl; ?>" onclick="redirect('bvn-verification.php')" <?php echo $dis; ?>><?php echo $tx; ?> <i class="fas fa-chevron-right"></i></button>
        </div>
        <div class="sep-btn">
            <button class="btn <?php echo (empty($verification["bvn"]) ? "black" : ""); ?>" onclick="moveNextOne(true, 'prev')"><i class="fas fa-chevron-left"></i>Previous</button>
            <button class="btn" onclick="moveNextTwo(<?php echo (!empty($verification["bvn"]) ? "true" : "false"); ?>, 'next')">Next<i class="fas fa-chevron-right"></i></button>
        </div>
    </div>
    
    <!----------- for tier three kyc ------------------->
    <?php 
     $tx_two = "";
     $dis_two = "";
     $disCl_two = "";
     $bclr_two = "";
     if(!empty($verification["nin"]) && strstr($verification["nin"], "_verify")){
      $tx_two = "Pending"; 
      $dis_two = "";
      $disCl_two = "pending";
      $bclr_two = "background: rgba(100%, 70%, 10%, 0.2);
        border: 1px solid rgba(100%, 70%, 10%, 50%);
        color: rgba(100%, 70%, 10%); 
        width: 100px;";
     }else if(!empty($verification["nin"]) && strstr($verification["nin"], "_rejected")){
      $tx_two = "rejected";
      $dis_two = "";
      $disCl_two = "";
     }else if(empty($verification["nin"])){
      $tx_two = "verify";
      $dis_two = "";
      $disCl_two = "";
     }else{
       $tx_two = "verified";
       $dis_two = "disabled";
       $disCl_two = "disabled";
     }
    ?> 
    <div class="kyc-topic none" id="level-three-topic">Level 3 <i class="fas fa-chevron-down"></i></div>
    <div class="v-box-container none" id="level-three-box">
        <div class="msg-box">
          <i class="bi bi-info-circle-fill"></i>
          <span>You are currently on level-3<br>Provide the requirment below to enjoy the benifits</span>
      </div>
        <div class="v-bx">
          <i class="ri-file-line"></i>
          <div class="v-t-bx">
            <b>NIN</b>
            <span>Status: <?php echo (!empty($verification["nin"]) ? "<b class='green'>Verified<b>" : "<b class='red'>Unverified</b>"); ?></span>
          </div>
          <button style="<?php echo $bclr_two; ?>" class="<?php echo $disCl_two; ?>" onclick="redirect('nin-verification.php')" <?php echo $dis_two; ?>><?php echo $tx_two; ?> <i class="fas fa-chevron-right"></i></button>
        </div>
        
        <div class="v-bx">
          <i class="ri-file-line"></i>
          <div class="v-t-bx">
            <b>Utility Bill</b>
            <span>Status: <?php echo (!empty($verification["utility_bill"]) ? "<b class='green'>Verified<b>" : "<b class='red'>Unverified</b>"); ?></span>
          </div>
          <button class="<?php echo (!empty($verification["utility_bill"]) ? "disabled" : ""); ?>" onclick="redirect('utility-verification.php')" <?php echo (!empty($verification["utility_bill"]) ? "disabled" : ""); ?>><?php echo (!empty($verification["utility_bill"]) ? "verified" : "verify"); ?> <i class="fas fa-chevron-right"></i></button>
        </div>
        
        <div class="v-bx" style="display: none;">
          <i class="ri-file-line"></i>
          <div class="v-t-bx">
            <b>Face Verification</b>
            <span>Status: <?php echo (!empty($verification["passport"]) ? "<b class='green'>Verified<b>" : "<b class='red'>Unverified</b>"); ?></span>
          </div>
          <button class="<?php echo (!empty($verification["passport"]) ? "disabled" : ""); ?>" onclick="redirect('passport-verification.php')" <?php echo (!empty($verification["passport"]) ? "disabled" : ""); ?>><?php echo (!empty($verification["passport"]) ? "verified" : "verify"); ?> <i class="fas fa-chevron-right"></i></button>
        </div>
        <div class="sep-btn">
            <button class="btn" onclick="moveNextTwo(true, 'prev')"><i class="fas fa-chevron-left"></i>Previous</button>
             <button class="btn" onclick="finish(true)">Finish<i class="fas fa-save"></i></button>
        </div>
    </div>
        
    
  </div style="display: block;">
    <?php 
      $e = (empty($verification["email"]) ? 0 : 1);
      $p = (empty($verification["phone"]) ? 0 : 1);
      $b = (empty($verification["bvn"]) ? 0 : 1);
      $n = (empty($verification["nin"]) ? 0 : 1);
      
      $total = $e + $p + $b + $n;
      
      $txt = "";
      if($total == 1){
        $txt = "25%";
      }else if($total == 2){
        $txt = "50%";
      }else if($total == 3){
        $txt = "75%";
      }else if($total == 4){
        $txt = "100%";
      }
      ?>
 <div style="overflow: hidden; width: var(--width); box-sizing: border-box; display: none;">
   <div class="slides" style="display: flex; transition: transform 0.5s ease-in-out;">
      <?php
    function doMsg($text, $link, $btn){
      return '
      <div class="slide" style="
        background: rgba(70%, 0%, 30%, 0.1);
        border: 1px solid var(--site-clr);
        padding: 10px;
        border: none;
        border-left: 6.6px solid var(--site-clr);
        min-width: var(--width-r);
        min-height: 60px;
        max-width: var(--width-r);
        display: flex;
        align-items: center;
        margin-left: 5px;
        margin-right: 5px;
      " onclick="nextSlide()">
      
        <span style="
          font-size: 10px;
          font-weight: 600;
          color: var(--site-clr);
          flex: 1;
          margin-right: 20px;
          letter-spacing: 0.6px;
        ">'.$text.'</span>
        
        <button style="
           padding: 10px;
           background: var(--site-clr);
           color: #fff;
           height: 30px;
           outline: none;
           border: none;
           width: 90px;
           font-weight: 900;
           font-size: 12px;
           line-height: 0;
           border-radius: 3px;
        " onclick="window.location = `'.$link.'`;">'.$btn.'</button>
        
      </div>
      ';
    }
    echo doMsg("You have complete ".$txt." of your account verification complete it now.", "account-verification.php", "COMPLETE");
    echo doMsg("You are yet to update your account profile details update now", "profile.php", "UPDATE");
    echo doMsg("Our referral program is still on refer your friends and family to use 1app for smooth and easy transaction.", "profile.php", "JOIN");
    ?>
  </div>
</div>
  <script>
    <?php include "js/msg.js"; ?>
    function redirect(link){
      window.location = link;
    }
    
    let currentIndex = 0;
    
    function showSlide(index) {
      const slides = document.querySelector('.slides');
      const totalSlides = document.querySelectorAll('.slide').length;
    
      if (index >= totalSlides) {
        currentIndex = 0;
      } else if (index < 0) {
        currentIndex = totalSlides - 1;
      }else{
         currentIndex = index;
      }
  
      const translateValue = -currentIndex * 100 + '%';
      slides.style.transform = 'translateX(' + translateValue + ')';
    }
    
    function prevSlide(){
      showSlide(currentIndex - 1);
    }
    function nextSlide(){
      showSlide(currentIndex + 1);
    }
    setInterval(nextSlide, 5000);
    
    function getId(idName){
        return document.getElementById(idName);
    }
    
    const progOne = getId("prog-one");
    const progTwo = getId("prog-two");
    
    function moveNextOne(status, moveType){
        const firstTopic = getId("level-one-topic");
        const secondTopic = getId("level-two-topic");
        
        const firstBox = getId("level-one-box");
        const secondBox = getId("level-two-box");
        
        if(status === true){
            firstTopic.classList.toggle("none");
            secondTopic.classList.toggle("none");
            
            firstBox.classList.toggle("none");
            secondBox.classList.toggle("none");
        }else{
            showMessage("bi bi-info-circle", "Please complete your Email verification before proceeding", "err");
        }
        
        if(moveType === "next"){
            progOne.classList.remove("icon-only");
        }else{
            progOne.classList.add("icon-only");
        }
        
        if(progTwo.classList.contains("active")){
            progOne.classList.remove("icon-only");
        }
    }
    
    function moveNextTwo(status, moveType){
        const firstTopic = getId("level-two-topic");
        const secondTopic = getId("level-three-topic");
        
        const firstBox = getId("level-two-box");
        const secondBox = getId("level-three-box");
        
        if(status === true){
            firstTopic.classList.toggle("none");
            secondTopic.classList.toggle("none");
            
            firstBox.classList.toggle("none");
            secondBox.classList.toggle("none");
        }else{
            showMessage("bi bi-info-circle", "Please complete your BVN verification before proceeding", "err");
        }
        
        if(moveType === "next"){
            progTwo.classList.remove("icon-only");
        }else{
            progTwo.classList.add("icon-only");
        }
        
    }
    
     function finish(type){
        if(type === true){
            showMessage("bi bi-check2-circle", "Congratulations your account verification has been completed successfully you can now enjoy our services without limits.", "suc");
            setTimeout(()=> {
              window.location.href = "dashboard.php"; 
            }, 3000);
        }else{
            showMessage("bi bi-info-circle", "Please complete your Level 3 verification before clicking the finish button", "err");
        }
    }
    function goBack(){
        window.history.back();
    }
  </script>
  </body>
</html>