<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Airtime");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Account Settings</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    <?php include "css/animation.css"; ?>
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Profile</span>
    <a href="logout.php" style="text-decoration: none; color: #333"><i class="fas fa-sign-out"></i></a>
  </div>
  
  <form class="profile" id="profile-form">
    <div class="i-image">
      <img src="Uploads/<?php echo $user["img"]; ?>" alt="user profile">
      <button type="button" onclick="document.getElementById('image').click()">Change Picture</button>
      <input type="file" name="image" id="image" hidden>
    </div>
    <div class="p-txt">NOTE: Field with asterisk(*) are editable.</div>
    <div class="sep-input">
        <div class="inputs">
          <span>Fristname *</span>
          <input type="text" name="firstname" id="firstname" value="<?php echo $user["fname"]; ?>" oninput="checkValue('firstname', 'firstname-err', '3', 'length', 'Invalid firstname', '')">
          <b id="firstname-err"></b>
        </div>
        
        <div class="inputs">
          <span>Lastname *</span>
          <input type="text" name="lastname" id="lastname" value="<?php echo $user["lname"]; ?>" oninput="checkValue('lastname', 'lastname-err', '3', 'length', 'Invalid lastname', '')">
          <b id="lastname-err"></b>
        </div>
    </div>
    
    <div class="inputs">
      <span>Email</span>
      <input type="text" name="email" id="email" value="<?php echo $user["email"]; ?>" disabled>
    </div>
    
    <div class="inputs">
      <span>Phone Number</span>
      <input type="tel" name="phone" id="phone" value="<?php echo $user["phone"]; ?>" disabled>
    </div>
    
    <div class="sep-input">
        <div class="inputs">
          <span>State *</span>
          <input type="text" name="state" id="state" oninput="checkValue('state', 'state-err', '3', 'length', 'Invalid state', '')" value="<?php echo $user["state"]; ?>">
          <b id="state-err"></b>
        </div>
        
        <div class="inputs">
          <span>City *</span>
          <input type="text" name="city" id="city" oninput="checkValue('city', 'city-err', '3', 'length', 'Invalid city', '')" value="<?php echo $user["city"]; ?>">
          <b id="city-err"></b>
        </div>
    </div>
    
    <div class="inputs" hidden>
      <span>Gender *</span>
      <select name="gender" id="gender" onchange="checkValue('gender', 'gender-err', '', 'empty', 'Select Gender', '')">
        <option value="">-- Select Gender --</option>
        <option value="Male" <?php echo ($user["gender"] == "Male" ? "selected" : ""); ?>>Male</option>
        <option value="Female" <?php echo ($user["gender"] == "Female" ? "selected" : ""); ?>>Female</option>
      </select>
    </div>
    
    <div class="inputs" id="gender:inputs">
      <span>Gender *</span>
      <div class="drop-btn" id="gender:1" onclick="addActive(this, 'gender-detail')">
        <span style="color: #000;"><?php echo (!empty($user["gender"]) ? $user["gender"] : "-- Select Gender --"); ?></span>
        <i class="fas fa-chevron-down"></i> 
      </div>
      
      <div class="drop-detail two" id="gender-detail">
        <div class="drop-detail-divs gender" onclick="removeDrop('gender', 'Male', this, 'drop-detail-divs.gender', 'gender:1')">
          <i class="bi bi-person"></i>
          <span>Male</span>
        </div>
        <div class="drop-detail-divs gender" onclick="removeDrop('gender', 'Female', this, 'drop-detail-divs.gender', 'gender:1')">
          <i class="bi bi-person"></i>
          <span>Female</span>
        </div>
      </div>
      
      <b id="gender-err"></b>
    </div>
    
    <div class="inputs">
      <span>Address *</span>
      <input type="text" name="address" id="address" value="<?php echo $user["address"]; ?>" oninput="checkValue('address', 'address-err', '5', 'length', 'Invalid address', '')">
      <b id="address-err"></b>
    </div>
    
    <button type="button" class="btn" onclick="updateProfile(this)">SUBMIT</button>
  </form>
  
  <script>
    <?php include "js/msg.js"; ?>
    
    function getId(idName){
        return document.getElementById(idName);
    }
    
    const fname = getId("firstname");
    const lname = getId("lastname");
    const state = getId("state");
    const city = getId("city");
    const gender = getId("gender");
    const address = getId("address");
    const pForm = getId("profile-form");
    
    function updateProfile(thisBtn){
        let formerTxt = thisBtn.innerText;
        if(fname.value.length < 3 || lname.value.length < 3 || state.value.length < 3 || city.value.length < 3 || gender.value === "" || address.value.length < 5){
            fname.dispatchEvent(new Event("input"));
            lname.dispatchEvent(new Event("input"));
            state.dispatchEvent(new Event("input"));
            city.dispatchEvent(new Event("input"));
            gender.dispatchEvent(new Event("change"));
            address.dispatchEvent(new Event("input"));
        }else{
            showP(thisBtn);
            fetch("server/update-profile.php", {
                method: "POST",
                body: new FormData(pForm),
            })
            .then(response => response.text())
            .then(data => {
                removeP(thisBtn, formerTxt);
                if(data.includes("success")){
                    showMessage("bi bi-check2-circle", data, "suc");
                }else{
                    showMessage("bi bi-exclamation-circle", data, "err");
                }
            })
        }
    }
  </script>
  </body>
</html>